<?php
/**
 * ThemeMascot functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 *
 */

global $ereco_mascot_theme_info;
$ereco_mascot_theme_info = wp_get_theme();

if (!function_exists('ereco_mascot_core_plugin_installed')) {
	/**
	 * Core Plugin installed?
	 */
	function ereco_mascot_core_plugin_installed() {
		return defined( 'MASCOT_CORE_ERECO_VERSION' );
	}
}

/* VARIABLE DEFINITIONS
================================================== */
define( 'ERECO_MASCOT_AUTHOR', 'ThemeMascot' );
define( 'ERECO_MASCOT_FRAMEWORK_VERSION', '1.0' );
define( 'ERECO_MASCOT_TEMPLATE_URI', get_template_directory_uri() );
define( 'ERECO_MASCOT_CHILD_THEME_URI', get_stylesheet_directory_uri() );
define( 'ERECO_MASCOT_TEMPLATE_DIR', get_template_directory() );
define( 'ERECO_MASCOT_STYLESHEET_DIR', get_stylesheet_directory() );

define( 'ERECO_MASCOT_ASSETS_URI', ERECO_MASCOT_TEMPLATE_URI . '/assets' );
define( 'ERECO_MASCOT_ASSETS_DIR', ERECO_MASCOT_TEMPLATE_DIR . '/assets' );

define( 'ERECO_MASCOT_ADMIN_ASSETS_URI', ERECO_MASCOT_TEMPLATE_URI . '/admin/assets' );
define( 'ERECO_MASCOT_ADMIN_ASSETS_DIR', ERECO_MASCOT_TEMPLATE_DIR . '/admin/assets' );

define( 'ERECO_MASCOT_FRAMEWORK_FOLDER', 'mascot-framework' );
define( 'ERECO_MASCOT_FRAMEWORK_URI', ERECO_MASCOT_TEMPLATE_URI . '/'. ERECO_MASCOT_FRAMEWORK_FOLDER );
define( 'ERECO_MASCOT_FRAMEWORK_DIR', ERECO_MASCOT_TEMPLATE_DIR . '/'. ERECO_MASCOT_FRAMEWORK_FOLDER );

define( 'ERECO_MASCOT_LANG_DIR', ERECO_MASCOT_TEMPLATE_DIR . '/languages' );

define( 'ERECO_MASCOT_THEME_NAME', $ereco_mascot_theme_info->get( 'Name' ) );
define( 'ERECO_MASCOT_THEME_SHORT', strtolower($ereco_mascot_theme_info->get( 'Name' )) );
define( 'ERECO_MASCOT_THEME_VERSION', $ereco_mascot_theme_info->get( 'Version' ) );
define( 'ERECO_MASCOT_POST_EXCERPT_LENGTH', 25 );


/* Initial Actions
================================================== */
add_action( 'after_setup_theme', 		'ereco_mascot_action_after_setup_theme' );
add_action( 'wp_enqueue_scripts', 		'ereco_mascot_action_wp_enqueue_scripts' );
add_action( 'widgets_init', 			'ereco_mascot_action_widgets_init' );
add_action( 'wp_head', 					'ereco_mascot_action_wp_head',1 );
add_action( 'wp_head', 					'ereco_mascot_action_wp_head_at_the_end', 100 );

//admin actions
add_action( 'admin_enqueue_scripts',	'ereco_mascot_action_theme_admin_enqueue_scripts' );

add_action( 'wp_footer', 				'ereco_mascot_action_wp_footer' );


/* MASCOT FRAMEWORK
================================================== */
require_once( ERECO_MASCOT_FRAMEWORK_DIR . '/mascot-framework.php' );



if(!function_exists('ereco_mascot_action_after_setup_theme')) {
	/**
	 * After Setup Theme
	 */
	function ereco_mascot_action_after_setup_theme() {
		//Theme Support
		global $supported_post_formats;
		$supported_post_formats = array( 'gallery', 'link', 'quote', 'audio', 'video' );

		//This feature enables Post Formats support for this theme
		add_theme_support( 'post-formats', $supported_post_formats );

		//This feature enables Automatic Feed Links for post and comment in the head
		add_theme_support( 'automatic-feed-links' );

		//This feature enables Post Thumbnails support for this theme
		add_theme_support( 'post-thumbnails' );

		//Woocommerce theme suport
		add_theme_support( 'woocommerce' );

		// Custom Backgrounds
		add_theme_support( 'custom-background', array(
			'default-color' => 'fff',
		) );

		//This feature enables plugins and themes to manage the document title tag. This should be used in place of wp_title() function
		add_theme_support( 'title-tag' );

		//This feature allows the use of HTML5 markup for the search forms, comment forms, comment lists, gallery, and caption
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );


		// add excerpt support for pages
		add_post_type_support( 'page', 'excerpt' );

		//Thumbnail Sizes
		set_post_thumbnail_size( 672, 448, true );
		add_image_size( 'ereco_mascot_featured_image', 1100 );
		add_image_size( 'ereco_mascot_thumbnail_height', 600, 800, true );

		add_image_size( 'ereco_mascot_square', 550, 550, true );
		add_image_size( 'ereco_mascot_square_150', 150, 150, true );
		add_image_size( 'ereco_mascot_square_120', 120, 120, true );
		add_image_size( 'ereco_mascot_square_64', 64, 64, true );
		add_image_size( 'ereco_mascot_widget_100', 100, 70, true );

		add_image_size( 'ereco_mascot_bootstrap_3col', 260, 173, true );
		add_image_size( 'ereco_mascot_bootstrap_4col', 360, 240, true );
		add_image_size( 'ereco_mascot_bootstrap_6col', 560, 373, true );

		add_image_size( 'ereco_mascot_wide', 1100, 550, true );
		add_image_size( 'ereco_mascot_height', 550, 1100, true );
		add_image_size( 'ereco_mascot_small_height', 150, 180, true );
		add_image_size( 'ereco_mascot_width_height', 1100, 1100, true );

		//Content Width
		if ( ! isset( $content_width ) ) $content_width = 1170;

		//Theme Textdomain
		load_theme_textdomain( 'ereco-wp', get_template_directory() . '/languages' );

		//Register Nav Menus
		$register_nav_menus_array = array(
			'primary' 					=> esc_html__( 'Primary Navigation Menu', 'ereco-wp' ),
			'page-404-helpful-links' 	=> esc_html__( 'Page 404 Helpful Links', 'ereco-wp' )
		);

		register_nav_menus( $register_nav_menus_array );
	}
}


if(!function_exists('ereco_mascot_action_wp_enqueue_scripts')) {
	/**
	 * Enqueue Script/Style
	 */
	function ereco_mascot_action_wp_enqueue_scripts() {
		wp_enqueue_script( 'jquery-ui-core');
		wp_enqueue_script( 'jquery-ui-tabs');
		wp_enqueue_script( 'jquery-ui-accordion');

		wp_enqueue_style( 'wp-mediaelement' );
		wp_enqueue_script( 'wp-mediaelement' );

		if( !is_admin() ){

			/**
			 * Enqueue Style
			 */

			if( is_rtl() ) {
				wp_enqueue_style( 'bootstrap-rtl', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/bootstrap-rtl.min.css' );
			} else {
				wp_enqueue_style( 'bootstrap', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/bootstrap.min.css' );
			}
			wp_enqueue_style( 'animate', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/animate.min.css' );

			//enable preloader
			wp_register_style( 'ereco-preloader', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/preloader.css' );
			$page_preloader = ereco_mascot_get_redux_option( 'general-settings-enable-page-preloader' );
			if( $page_preloader ) {
				wp_enqueue_style( 'ereco-preloader' );
			}

			/**
			 * Enqueue Fonts
			 */
			//font-awesome icons
			wp_deregister_style( 'font-awesome' );
			wp_deregister_style( 'font-awesome-v4-shims' );
			wp_enqueue_style( 'font-awesome', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/font-awesome5.min.css' );
			wp_enqueue_style( 'font-awesome-v4-shims', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/font-awesome-v4-shims.css' );

			if( ereco_mascot_get_redux_option( 'page-settings-use-flaticon-current-theme' ) ) {
				wp_enqueue_style( 'flaticon-archi-set-current-theme', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/flaticon-archi-set-current-theme.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-flaticon-contact' ) ) {
				wp_enqueue_style( 'flaticon-set-contact', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/flaticon-set-contact.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-flaticon-shop' ) ) {
				wp_enqueue_style( 'flaticon-shop', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/flaticon-shop.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-elegant-icons' ) ) {
				wp_enqueue_style( 'elegant-icons', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/elegant-icons.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-pe-icon-7-stroke' ) ) {
				wp_enqueue_style( 'pe-icon-7-stroke', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/pe-icon-7-stroke.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-icomoon' ) ) {
				wp_enqueue_style( 'icomoon', ERECO_MASCOT_TEMPLATE_URI . '/assets/fonts/icomoon/icomoon.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-ion-icons' ) ) {
				wp_enqueue_style( 'ion-icons', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/ionicons.css' );
			}
			if( ereco_mascot_get_redux_option( 'page-settings-use-simple-line' ) ) {
				wp_enqueue_style( 'simple-line', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/simple-line-icons.css' );
			}


			//google fonts
			wp_enqueue_style( 'ereco-google-fonts', ereco_mascot_google_fonts_url(), null, false, 'all' );



			/**
			 * Enqueue Script
			 */
			wp_enqueue_script( 'html5shiv', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/html5shiv.min.js', array(''), '3.7.3' );
			wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );
			wp_enqueue_script( 'respond', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/respond.min.js', array(''), '1.4.2' );
			wp_script_add_data( 'respond', 'conditional', 'lt IE 9' );


			wp_enqueue_script( 'popper', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/popper.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'bootstrap', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/bootstrap.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'menuzord', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/menuzord/js/menuzord.js', array('jquery'), false, true );

			//external plugins single file:
			wp_enqueue_script( 'jquery-appear', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.appear.js', array('jquery'), false, true );
			wp_enqueue_script( 'isotope', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/isotope.pkgd.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'imagesloaded' );
			wp_enqueue_script( 'jquery-scrolltofixed', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery-scrolltofixed-min.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-easing', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.easing.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-fitvids', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.fitvids.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-localscroll', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.localscroll.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-scrollto', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.scrollto.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-paroller', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.paroller.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-lettering', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.lettering.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-textillate', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.textillate.js', array('jquery'), false, true );
			wp_enqueue_script( 'wow', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/wow.min.js', array('jquery'), false, true );

			//external plugins js & css:
			//used when needed:
			wp_register_script( 'owl-carousel', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );
			wp_register_script( 'jquery-owl-filter', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/jquery.owl-filter.js', array('jquery'), false, true );
			wp_register_script( 'owl-carousel2-thumbs', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl.carousel2.thumbs.min.js', array('jquery'), false, true );
			wp_enqueue_style( 'owl-carousel', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/assets/owl.carousel.min.css' );

			wp_register_script( 'slick', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slick/slick.js', array('jquery'), false, true );
			wp_register_style( 'slick', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slick/slick.css' );
			wp_register_style( 'slick-theme', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/slick/slick-theme.css' );


			wp_register_script( 'lightgallery', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/lightgallery/js/lightgallery.min.js', array('jquery'), false, true );
			wp_register_style( 'lightgallery', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/lightgallery/css/lightgallery.min.css' );
			wp_register_script( 'jquery-mousewheel', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.mousewheel.min.js', array('jquery'), false, true );
			wp_register_script( 'ereco-custom-lightgallery', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/custom-lightgallery.js', array('jquery'), false, true );


			wp_enqueue_script( 'jquery-nice-select', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery-nice-select/jquery.nice-select.min.js', array('jquery'), false, true );
			wp_enqueue_style( 'nice-select', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery-nice-select/nice-select.css' );



			wp_register_script( 'jquery-parallax-scroll', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.parallax-scroll.js', array('jquery'), false, true );


			wp_register_script( 'sticky-sidebar', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/sticky-sidebar.min.js', null, false, true );
			wp_register_script( 'sticky-kit', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/sticky-kit.min.js', array('jquery'), false, true );
			wp_enqueue_script( 'jquery-tilt', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.tilt.min.js', array('jquery'), false, true );



			wp_register_script( 'menufullpage', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/menufullpage/menufullpage.min.js', array('jquery'), false, true );
			wp_register_script( 'matchHeight', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/plugins/jquery.matchHeight-min.js', array('jquery'), false, true );



			//Theme Custom JS
			wp_enqueue_script( 'ereco-custom', ERECO_MASCOT_TEMPLATE_URI . '/assets/js/custom.js', array('jquery'), false, true );



			//Enqueue comment-reply.js
			if ( is_singular() && comments_open() && get_option('thread_comments') ) {
				wp_enqueue_script( 'comment-reply' );
			}
			

			//Navigation Skin
			$navigation_skin = esc_attr( ereco_mascot_get_redux_option( 'header-settings-navigation-skin' ) );
			//if layout type vertical nav then nav skin is set to default:
			$header_layout_type = ereco_mascot_return_header_layout_type();
			if( $header_layout_type == 'header-vertical-nav' ) {
				$navigation_skin = 'default';
			}
			//register and enque menuzord css skin
			if( $navigation_skin ) {
				wp_register_style( 'ereco-mascot-menuzord-navigation-skin', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/menuzord-skins/menuzord-'.$navigation_skin.'.css', array(), ERECO_MASCOT_THEME_VERSION );
				wp_enqueue_style( 'ereco-mascot-menuzord-navigation-skin' );
			}


			//style main for this theme
			if( is_rtl() ) {
				wp_enqueue_style( 'ereco-style-main-rtl', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/style-main-rtl.css', array(), ERECO_MASCOT_THEME_VERSION );
			} else {
				wp_enqueue_style( 'ereco-style-main', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/style-main.css', array(), ERECO_MASCOT_THEME_VERSION );
			}

			//Theme Color
			$mascot_primary_theme_color = '';
			$page_metabox_change_primary_theme_color = ereco_mascot_get_rwmb_group( 'ereco_mascot_' . "page_mb_theme_color_settings", 'change_primary_theme_color', ereco_mascot_get_page_id() );

			if( $page_metabox_change_primary_theme_color ) {
				//Theme Color from page meta box
				$mascot_primary_theme_color = ereco_mascot_get_rwmb_group( 'ereco_mascot_' . "page_mb_theme_color_settings", 'primary_theme_color', ereco_mascot_get_page_id() );

			} else if ( !_empty( ereco_mascot_get_redux_option( 'theme-color-settings-theme-color-type' ) ) ) {
				//Theme Color from Theme Options
				if( ereco_mascot_get_redux_option( 'theme-color-settings-theme-color-type' ) == 'predefined' ) {
					//Primary Theme Color
					$mascot_primary_theme_color = !_empty( ereco_mascot_get_redux_option( 'theme-color-settings-primary-theme-color' ) ) ? ereco_mascot_get_redux_option( 'theme-color-settings-primary-theme-color' ) : '';
				} else if ( ereco_mascot_get_redux_option( 'theme-color-settings-theme-color-type' ) == 'custom' ) {
					//Custom Theme Color
					$redux_css_file_name = ereco_mascot_get_redux_option( 'theme-color-settings-custom-theme-color-filename' );
					if( !empty( $redux_css_file_name ) ) {
						$mascot_primary_theme_color = $redux_css_file_name . '.css';
					} else if ( !is_multisite() ) {
						if ( file_exists( ERECO_MASCOT_ASSETS_DIR . '/css/colors/custom-theme-color.css' ) ) {
							$mascot_primary_theme_color = 'custom-theme-color.css';
						}
					} else {
						if ( file_exists( ERECO_MASCOT_ASSETS_DIR . '/css/colors/custom-theme-color-msid-' . ereco_mascot_get_multisite_blog_id() . '.css' ) ) {
							$mascot_primary_theme_color = 'custom-theme-color-msid-' . ereco_mascot_get_multisite_blog_id() . '.css';
						}
					}
				}
			} else {
				$mascot_primary_theme_color = 'theme-skin-color-set1.css';
			}

			wp_enqueue_style( 'ereco-primary-theme-color', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/colors/' . $mascot_primary_theme_color );


			//Attach Premade CSS File into the header
			$mascot_premade_sitewise_css_file = ereco_mascot_get_redux_option( 'theme-color-settings-premade-sitewise-css-file' );
			if( !empty($mascot_premade_sitewise_css_file) ) {
				wp_enqueue_style( 'ereco-premade-sitewise-css-file', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/sites/' . $mascot_premade_sitewise_css_file );
			}


			if( is_rtl() ) {
				wp_enqueue_style( 'ereco-style-main-rtl-extra', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/style-main-rtl-extra.css' );
			}

			//Dynamic Style
			if ( !is_multisite() ) {
				if ( file_exists( ERECO_MASCOT_ASSETS_DIR . '/css/dynamic-style.css' ) ) {
					wp_enqueue_style( 'ereco-dynamic-style', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/dynamic-style.css' );
				}
			} else {
				if ( file_exists( ERECO_MASCOT_ASSETS_DIR . '/css/dynamic-style-msid-' . ereco_mascot_get_multisite_blog_id() . '.css' ) ) {
					wp_enqueue_style( 'ereco-dynamic-style', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/dynamic-style-msid-' . ereco_mascot_get_multisite_blog_id() . '.css' );
				}
			}

		}
	}
}



if(!function_exists('ereco_mascot_action_theme_admin_enqueue_scripts')) {
	/**
	 * Add Admin Scripts
	 */
	function ereco_mascot_action_theme_admin_enqueue_scripts() {
		wp_enqueue_style( 'font-awesome', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/font-awesome.min.css' );
		wp_enqueue_style( 'pe-icon-7-stroke', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/pe-icon-7-stroke.css' );
		wp_enqueue_style( 'ion-icons', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/ionicons.css' );
		wp_enqueue_style( 'flaticon-archi-set-current-theme', ERECO_MASCOT_TEMPLATE_URI . '/assets/css/flaticon-archi-set-current-theme.css' );

		wp_enqueue_style( 'ereco-custom-admin', ERECO_MASCOT_TEMPLATE_URI . '/admin/assets/css/custom-admin.css' );

		wp_enqueue_script( 'ereco-admin', ERECO_MASCOT_TEMPLATE_URI . '/admin/assets/js/admin.js', array('jquery'), null, true );
	}
}



if(!function_exists('ereco_mascot_detect_elementor_and_add_class')) {
	/**
	 * Detect Elementor Enabled in Page Content and then add class to body
	 */
	function ereco_mascot_detect_elementor_and_add_class( $classes ) {
		$elementor_enabled = false;
		if ( did_action( 'elementor/loaded' ) ) {
			$elementor_enabled = true;
		}
		if (  is_archive() ) {
			$classes[] = 'tm_elementor_page_status_false';
		} else if (  is_search() ) {
			$classes[] = 'tm_elementor_page_status_false';
		} else if ( is_singular( 'portfolio-items' ) ) {
			$classes[] = 'tm_elementor_page_status_false';
		} else if ( $elementor_enabled != 'false' && $elementor_enabled == true ) {
			$classes[] = 'tm_elementor_page_status_true';
		} else {
			$classes[] = 'tm_elementor_page_status_false';
		}
		return $classes;
	}
	add_filter( 'body_class','ereco_mascot_detect_elementor_and_add_class' );
}



if(!function_exists('ereco_mascot_google_fonts_url')) {
	/**
	 * @return string Google fonts URL
	 */
	function ereco_mascot_google_fonts_url() {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		//fonts
		$fonts = apply_filters( 'ereco_mascot_google_web_fonts', $fonts );

		//font subsets
		$subsets = apply_filters('ereco_mascot_google_font_subset', 'latin,latin-ext');

		if ( !empty( $fonts ) ) {
			$fonts_url = add_query_arg(
				array(
					'family' => urlencode( implode( '|', $fonts ) ),
					'subset' => urlencode( $subsets ),
				),
				'//fonts.googleapis.com/css'
			);
		}

		return apply_filters( 'google_web_fonts_url', $fonts_url );
	}
}


if(!function_exists('ereco_mascot_primary_google_fonts')) {
	/**
	 * @return primary google fonts used in this theme
	 */
	function ereco_mascot_primary_google_fonts( $fonts ) {

		/* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Google font: on or off', 'ereco-wp' ) ) {
			$fonts[] = 'Roboto:400,500,700';
			$fonts[] = 'Oswald:500,600,700';
		}

		return $fonts;
	}
	add_filter( 'ereco_mascot_google_web_fonts', 'ereco_mascot_primary_google_fonts' );
}

if(!function_exists('ereco_mascot_wrap_embed_with_div')) {
	function ereco_mascot_wrap_embed_with_div( $cache, $url, $attr, $post_ID ) {
		$classes = array();

		// Add these classes to all embeds.
		$classes_all = array(
			'tm-responsive-video-wrapper',
		);

		// Check for different providers and add appropriate classes.

		if ( false !== strpos( $url, 'vimeo.com' ) ) {
			$classes[] = 'tm-responsive-video';
			$classes[] = 'video-vimeo';
		}

		if ( false !== strpos( $url, 'youtube.com' ) ) {
			$classes[] = 'tm-responsive-video';
			$classes[] = 'video-youtube';
		}

		if ( false !== strpos( $url, 'wordpress.tv' ) ) {
			$classes[] = 'tm-responsive-video';
			$classes[] = 'video-videopress';
		}

		$classes = array_merge( $classes, $classes_all );

		return '<div class="' . esc_attr( implode( ' ', $classes ) ) . '">' . $cache . '</div>';
	}
	add_filter( 'embed_oembed_html', 'ereco_mascot_wrap_embed_with_div', 99, 4 );
}

if(!function_exists('ereco_mascot_override_mce_options')) {
	function ereco_mascot_override_mce_options($initArray) {
		$opts = '*[*]';
		$initArray['valid_elements'] = $opts;
		$initArray['extended_valid_elements'] = $opts;
		return $initArray;
	}
	add_filter('tiny_mce_before_init', 'ereco_mascot_override_mce_options');
}