<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "main-content" div.
 *
 */

?><?php
// This is your option name where all the Redux data is stored.
global $ereco_mascot_redux_theme_opt;
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	
	<link rel="profile" href="//gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php
	/**
	 * ereco_mascot_body_tag_start hook.
	 *
	 */
	do_action( 'ereco_mascot_body_tag_start' );
?>
<div id="wrapper">
	<?php
		/**
		 * ereco_mascot_wrapper_start hook.
		 *
		 */
		do_action( 'ereco_mascot_wrapper_start' );
	?>
	<?php ereco_mascot_get_page_preloader(); ?>

	<?php if( apply_filters('ereco_mascot_filter_show_header', true) ): ?>
	<?php ereco_mascot_get_header_parts(); ?>
	<?php endif; ?>

	<?php
		/**
		 * ereco_mascot_before_main_content hook.
		 *
		 */
		do_action( 'ereco_mascot_before_main_content' );
	?>
	<div class="main-content">
	<?php
		/**
		 * ereco_mascot_main_content_start hook.
		 *
		 */
		do_action( 'ereco_mascot_main_content_start' );
	?>
	