<?php


if(!function_exists('ereco_mascot_get_404_parts')) {
	/**
	 * Function that Renders Coming Soon Page HTML Codes
	 * @return HTML
	 */
	function ereco_mascot_get_404_parts() {
		$params = array();
		$section_classes_array = array();
		$params['section_classes'] = '';
		$layout = ereco_mascot_get_redux_option( '404-page-settings-layout', 'simple' );
		$section_classes_array[] = 'page-404-layout-' . $layout;

		//Text Alignment
		$params['text_align'] = ereco_mascot_get_redux_option( '404-page-settings-text-align', 'text-center' );
		
		//Add Background Overlay
		if( ereco_mascot_get_redux_option( '404-page-settings-bg-layer-overlay-status' ) ) {
			$section_classes_array[] = 'layer-overlay overlay-'.ereco_mascot_get_redux_option( '404-page-settings-bg-layer-overlay-color' ) .'-'.ereco_mascot_get_redux_option( '404-page-settings-bg-layer-overlay' );
		}

		//make array into string
		if( is_array( $section_classes_array ) && count( $section_classes_array ) ) {
			$params['section_classes'] = esc_attr(implode(' ', $section_classes_array));
		}

		$params['page_title'] = ereco_mascot_get_redux_option( '404-page-settings-title', esc_html__( "404", 'ereco-wp' ) );
		$params['page_subtitle'] = ereco_mascot_get_redux_option( '404-page-settings-subtitle', esc_html__( "Oops! Page Not Found!", 'ereco-wp' ) );
		$params['page_content'] = ereco_mascot_get_redux_option( '404-page-settings-content', esc_html__( "The page you are looking for does not exist. It might have been moved or deleted.", 'ereco-wp' ) );


		//fullscreen if not show header footer
		if( ereco_mascot_get_redux_option( '404-page-settings-show-header' ) == true || ereco_mascot_get_redux_option( '404-page-settings-show-footer' ) == true ) {
			$params['fullscreen'] = 'page-404-wrapper-padding';
		} else {
			$params['fullscreen'] = 'section-fullscreen';
		}

		//Search Box
		$params['show_search_box'] = ereco_mascot_get_redux_option( '404-page-settings-show-search-box', true );
		$params['search_box_heading'] = ereco_mascot_get_redux_option( '404-page-settings-search-box-heading' );
		$params['search_box_paragraph'] = ereco_mascot_get_redux_option( '404-page-settings-search-box-paragraph' );

		//Helpful Links
		$params['show_helpful_links'] = ereco_mascot_get_redux_option( '404-page-settings-show-helpful-links', 0 );
		$params['helpful_links_heading'] = ereco_mascot_get_redux_option( '404-page-settings-helpful-links-heading' );
		$params['helpful_links_nav'] = 'page-404-helpful-links';

		//Show Social Links
		$params['show_social_links'] = ereco_mascot_get_redux_option( '404-page-settings-show-social-links', false );

		//Back Button Label
		$params['show_back_to_home_button'] = ereco_mascot_get_redux_option( '404-page-settings-show-back-to-home-button', true );
		$params['back_to_home_button_label'] = ereco_mascot_get_redux_option( '404-page-settings-back-to-home-button-label', esc_html__( "Back to Home", 'ereco-wp' ) );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = ereco_mascot_get_blocks_template_part( 'template', ereco_mascot_get_redux_option( '404-page-settings-layout', 'simple' ), '404/tpl', $params );
		
		return $html;
	}
}