<?php
add_filter( 'rwmb_meta_boxes', 'ereco_mascot_page_metaboxes' );

/**
 * Register meta boxes
 *
 * @param array $meta_boxes
 *
 * @return array
 */
function ereco_mascot_page_metaboxes( $meta_boxes ) {
	//list active sidebars
	$active_sidebar_list = array();
	$active_sidebar_list[ 'inherit' ] = esc_html__( 'Inherit from Theme Options', 'ereco-wp' );
	global $wp_registered_sidebars;
	foreach ( $wp_registered_sidebars as $key => $value ) {
		$active_sidebar_list[ $key ] = $value['name'];
	}

	//list menus
	$active_menu_list = array();
	$nav_menus = wp_get_nav_menus();
	if ( ! empty ( $nav_menus ) ) {
		foreach ( $nav_menus as $item ) {
			$active_menu_list[ $item->term_id ] = $item->name;
		}
		//foreach
	}

	//get primary thme location menu item
	$theme_locations = get_nav_menu_locations();
	$primary_nav_menu_name = 'none';
	if( array_key_exists('primary', $theme_locations) && !empty($theme_locations['primary']) ) {
		$primary_nav_menu_obj = get_term( $theme_locations['primary'], 'nav_menu' );
		$primary_nav_menu_name = $primary_nav_menu_obj->name;
	}

	//ALL custom post types
	//$post_types = get_post_types();

	//Get a List of All Revolution Slider Aliases
	//revslider version 6
	$list_rev_sliders = array();
	if ( class_exists( 'RevSliderSlider' ) ) {
		$list_rev_sliders[0] = esc_html__( 'Select a Slider', 'ereco-wp' );
		$rev_slider = new RevSliderSlider();
		$all_rev_sliders = $rev_slider->get_sliders();
		foreach ( $all_rev_sliders as $each_slide ) {
			$list_rev_sliders[$each_slide->id] = $each_slide->alias;
		}
	}


	//Get a List of All Layer Slider Aliases
	$list_layer_sliders = array();
	if ( class_exists( 'LS_Sliders' ) ) {
		$list_layer_sliders[0] = esc_html__( 'Select a Slider', 'ereco-wp' );
		$LS_Sliders_list = LS_Sliders::find();
		foreach ( $LS_Sliders_list as $each_slide ) {
			$list_layer_sliders[ $each_slide['id'] ] = $each_slide['name'];
		}
	}


	// Background Patterns Reader
	$sample_patterns_path = ERECO_MASCOT_ADMIN_ASSETS_DIR . '/images/pattern/';
	$sample_patterns_url  = ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/pattern/';
	$sample_patterns      = array();
	
	if ( is_dir( $sample_patterns_path ) ) {

		if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
			$sample_patterns = array();

			while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

				if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
					$name              = explode( '.', $sample_patterns_file );
					$name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
					$sample_patterns[$sample_patterns_url . $sample_patterns_file] = $sample_patterns_url . $sample_patterns_file;
				}
			}
		}
	}


	$text_align_array = array(
		'inherit'			=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
		'text-left flip'	=> esc_html__( 'Left', 'ereco-wp' ),
		'text-center'		=> esc_html__( 'Center', 'ereco-wp' ),
		'text-right flip'	=> esc_html__( 'Right', 'ereco-wp' ),
	);

	// Page Sidebar
	$meta_boxes[] = array(
		'id'			=> 'page_sidebar',
		'title'			=> esc_html__( 'Page Sidebar', 'ereco-wp' ),
		'post_types'	=> array( 'post', 'page', 'portfolio', 'campaign' ),
		'context'		=> 'side',
		'priority'		=> 'low',
		// Sub-fields
		'fields'		=> array(
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_sidebar_layout_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// Sub-fields
				'fields' => array(
					array(
						'name'		=> esc_html__( 'Sidebar Layout', 'ereco-wp' ),
						'id'		=> 'sidebar_layout',
						'type'		=> 'image_select',
						'options' 	=> array(
							'inherit'				=> ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/inherit.png',
							'sidebar-right-25'		=> ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-right-25.png',
							'sidebar-right-33'		=> ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-right-33.png',
							'no-sidebar'			=> ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/no-sidebar.png',
							'sidebar-left-25'		=> ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-left-25.png',
							'sidebar-left-33'		=> ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/sidebar-left-33.png',
							'both-sidebar-25-50-25' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/sidebar/both-sidebar-25-50-25.png',
						),
						'std'		=> 'inherit',
					),
					array(
						'name'		=> esc_html__( 'Pick Sidebar Default', 'ereco-wp' ),
						'id'		=> 'sidebar_default',
						'type'		=> 'select',
						'options'	=> $active_sidebar_list,
					),
					array(
						'type' 		=> 'heading',
						'name' 		=> esc_html__( 'Sidebar 2 Settings', 'ereco-wp' ),
						'desc'		=> esc_html__( 'Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Pick Sidebar 2', 'ereco-wp' ),
						'id'		=> 'sidebar_two',
						'type'		=> 'select',
						'options'   => $active_sidebar_list,
					),
					array(
						'name'		=> esc_html__( 'Sidebar 2 Position', 'ereco-wp' ),
						'id'		=> 'sidebar_two_position',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Controls the position of sidebar 2. In that case, sidebar 1 will be shown on opposite side.', 'ereco-wp' ),
						'options'	=> array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'left'		=> esc_html__( 'Left', 'ereco-wp' ),
							'right'	 	=> esc_html__( 'Right', 'ereco-wp' )
						),
					),
				),
			),
		),
	);

	// Meta Box Settings for this Page
	$meta_boxes[] = array(
		'title'	 => esc_html__( 'Page Settings', 'ereco-wp' ),
		'post_types' => array( 'post', 'page', 'portfolio', 'campaign' ),
		'priority'   => 'high',

		// List of tabs, in one of the following formats:
		// 1) key => label
		// 2) key => array( 'label' => Tab label, 'icon' => Tab icon )
		'tabs'		=> array(


			'header'  => array(
				'label' => esc_html__( 'Header', 'ereco-wp' ),
				'icon'  => 'dashicons-arrow-up-alt', // Dashicon
			),
			'logo' => array(
				'label' => esc_html__( 'Logo', 'ereco-wp' ),
				'icon'  => 'dashicons-palmtree', // Dashicon
			),
			'page-title'		=> array(
				'label' => esc_html__( 'Page Title', 'ereco-wp' ),
				'icon'  => 'dashicons-archive', // Dashicon
			),
			'layout-setings'	=> array(
				'label' => esc_html__( 'Layout Settings', 'ereco-wp' ),
				'icon'  => 'dashicons-editor-table', // Dashicon
			),
			'theme-color' => array(
				'label' => esc_html__( 'Theme Color Settings', 'ereco-wp' ),
				'icon'  => 'dashicons-admin-home', // Dashicon
			),
			'footer'	=> array(
				'label' => esc_html__( 'Footer Settings', 'ereco-wp' ),
				'icon'  => 'dashicons-arrow-down-alt', // Dashicon
			),
			'slider' => array(
				'label' => esc_html__( 'Slider Settings', 'ereco-wp' ),
				'icon'  => 'dashicons-update', // Dashicon
			),
			'general' => array(
				'label' => esc_html__( 'General Settings', 'ereco-wp' ),
				'icon'  => 'dashicons-admin-home', // Dashicon
			),
		),

		// Tab style: 'default', 'box' or 'left'. Optional
		'tab_style' => 'left',
		
		// Show meta box wrapper around tabs? true (default) or false. Optional
		'tab_wrapper' => true,

		'fields'	=> array(

			
			//Header tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_header_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'header',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Header Visibility', 'ereco-wp' ),
						'id'		=> 'header_visibility',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Show or hide complete header only for this page.', 'ereco-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'   		=> esc_html__( 'Show', 'ereco-wp' ),
							'0' 		=> esc_html__( 'Hide', 'ereco-wp' ),
						),
					),



					// DIVIDER
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header  (Built with Elementor)', 'ereco-wp' ),
					),

					array(
						'name' => esc_html__( 'Choose Header (Elementor)', 'ereco-wp' ),
						'desc' => sprintf(__('Made using Elementor. Create your own one from <a href="%s" target="_blank">Dashboard > Parts - Header Top</a>', 'ereco-wp'), admin_url('edit.php?post_type=header-top')),
						'id'          => 'headertop_cpt_elementor',
						'type'        => 'post',

						// Post type.
						'post_type'   => 'header-top',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Pre Made Header', 'ereco-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),

					array(
						'name' => esc_html__( 'Or Choose Transparent Header (Elementor)', 'ereco-wp' ),
						'desc' => esc_html__( 'Made From Custom Post Type by using Elementor.', 'ereco-wp' ),
						'id'          => 'headertop_cpt_elementor_transparent',
						'type'        => 'post',

						// Post type.
						'post_type'   => 'header-top',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Pre Made Header', 'ereco-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),

					array(
						'name' => esc_html__( 'Choose Header Sticky (Elementor)', 'ereco-wp' ),
						'desc' => esc_html__( 'It will be shown when you scroll down. Made From Custom Post Type by using Elementor.', 'ereco-wp' ),
						'id'          => 'headertop_cpt_elementor_sticky',
						'type'        => 'post',

						// Post type.
						'post_type'   => 'header-top',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Pre Made Sticky Header', 'ereco-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),

					array(
						'name' => esc_html__( 'Choose Header Mobile/Tab (Elementor)', 'ereco-wp' ),
						'desc' => esc_html__( 'It will be visible on Tab & Mobile devices only. Made From Custom Post Type by using Elementor.', 'ereco-wp' ),
						'id'          => 'headertop_cpt_elementor_mobile',
						'type'        => 'post',

						// Post type.
						'post_type'   => 'header-top',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Pre Made Sticky Header', 'ereco-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),








					array(
						'type' => 'heading',
						'name' => esc_html__( 'Default Header Navigation Row', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Default Header Nav Row (Show/Hide)', 'ereco-wp' ),
						'id'		=> 'header_nav_row_visibility',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Show or hide default header nav row only for this page.', 'ereco-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'   		=> esc_html__( 'Show', 'ereco-wp' ),
							'0' 		=> esc_html__( 'Hide', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Primary Navigation Menu', 'ereco-wp' ),
						'id'		=> 'custom_primary_nav_menu',
						'type'		=> 'taxonomy',
						'desc'		=> sprintf( esc_html__( 'Select which menu you want to display as primary navigation on this page. Currently set to %1$s%2$s%3$s.', 'ereco-wp' ), '<a target="_blank" href="' . esc_url( admin_url( 'nav-menus.php?action=locations' ) ) . '">', $primary_nav_menu_name, '</a>' ),
						'taxonomy'  => 'nav_menu',
						'field_type'=> 'select',
						'query_args'=> array(),
					),
					array(
						'name'		=> esc_html__( 'Enable One Page Nav Smooth Scrolling Effect', 'ereco-wp' ),
						'id'		=> 'enable_one_page_nav_scrolling_effect',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'Check this box in order to enable one page navigation smooth scrollling effect.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Show Custom Button', 'ereco-wp' ),
						'id'		=> 'show_custom_button',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Enabling this option will show Custom Button.', 'ereco-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'   		=> esc_html__( 'Yes', 'ereco-wp' ),
							'0' 		=> esc_html__( 'No', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> 'title',
						'id'		=> 'custom_button_title',
						'type'		=> 'text',
						'visible'   => array( 
							array( 'show_custom_button', '=', '1' )
						),
					),
					array(
						'name'		=> 'link',
						'id'		=> 'custom_button_link',
						'type'		=> 'text',
						'visible'   => array( 
							array( 'show_custom_button', '=', '1' )
						),
					),
					array(
						'name'		=> esc_html__( 'Main Nav Items Text Color', 'ereco-wp' ),
						'id'		=> 'main_nav_items_text_color',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   	=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'white'   	=> esc_html__( 'Text White', 'ereco-wp' ),
							'dark' 	=> esc_html__( 'Text Dark', 'ereco-wp' ),
						),
					),








					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header Layout', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Header Layout Type (Built in)', 'ereco-wp' ),
						'id'		=> 'header_layout_type',
						'type'		=> 'select',
						'options'   => array(
							'inherit'						=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'header-current-theme-style1'	=> esc_html__( 'Header Current Theme Style 1', 'ereco-wp' ),
							'header-current-theme-style2'	=> esc_html__( 'Header Current Theme Style 2', 'ereco-wp' ),

							'header-default'					=> esc_html__( 'Header Default', 'ereco-wp' ),
							'header-default2'					=> esc_html__( 'Header Default 2 - Left Logo Left Nav', 'ereco-wp' ),
							'header-default3'					=> esc_html__( 'Header Default 3 - No logo', 'ereco-wp' ),

							'header-floating-left-logo'	=> esc_html__( 'Floating Header - With Logo', 'ereco-wp' ),
							'header-floating-left-logo-left-nav'	=> esc_html__( 'Floating Header - Left Logo Left Nav', 'ereco-wp' ),
							'header-floating-no-logo'	=> esc_html__( 'Floating Header (No Logo)', 'ereco-wp' ),

							
							'header-nav-hanging'	=> esc_html__( 'Header Nav Hanging', 'ereco-wp' ),

							'header-mobile-nav'				=> esc_html__( 'Mobile Nav', 'ereco-wp' ),
							'header-mobile-nav-floating'				=> esc_html__( 'Mobile Nav - Floating', 'ereco-wp' ),
							'header-side-panel-nav'			=> esc_html__( 'Side Push Panel Nav', 'ereco-wp' ),
							'header-vertical-nav'			=> esc_html__( 'Vertical Nav', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Header Container', 'ereco-wp' ),
						'id'		=> 'header_container',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'container' 		=> esc_html__( 'Container', 'ereco-wp' ),
							'container-fluid' 	=> esc_html__( 'Container Fluid', 'ereco-wp' )
						),
					),



					
					// DIVIDER
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header Floating Options', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Header Background Shadow (Header Floating)', 'ereco-wp' ),
						'id'		=> 'header_floating_bg_shadow',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'header-bg-no-shadow'		=> esc_html__( 'No Shadow', 'ereco-wp' ),
							'header-bg-dark-shadow'		=> esc_html__( 'Dark Background Shadow', 'ereco-wp' ),
							'header-bg-light-shadow'	=> esc_html__( 'Light Background Shadow', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Text Color (Header Floating)', 'ereco-wp' ),
						'id'		=> 'header_floating_text_color',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'header-floating-bg-dark-text-white'	=> esc_html__( 'White Text', 'ereco-wp' ),
							'header-floating-bg-white-text-dark'		=> esc_html__( 'Dark Text', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Background Color (on Header Floating + Sticky)', 'ereco-wp' ),
						'id'		=> 'header_floating_bg_color_sticky',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'header-floating-sticky-bg-white'	=> esc_html__( 'White BG', 'ereco-wp' ),
							'header-floating-sticky-bg-dark'		=> esc_html__( 'Dark BG', 'ereco-wp' ),
						),
					),

					

					array(
						'type' => 'heading',
						'name' => esc_html__( 'Header Layout - Vertical Nav', 'ereco-wp' ),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Color', 'ereco-wp' ),
						'id'		=> 'vertical_nav_bgcolor',
						'type'		=> 'color',
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Image', 'ereco-wp' ),
						'id'		=> 'vertical_nav_bgimg',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Shadow', 'ereco-wp' ),
						'id'		=> 'vertical_nav_shadow',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Vertical Area Border', 'ereco-wp' ),
						'id'		=> 'vertical_nav_border',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),
					array(
						'name'		=> esc_html__( 'Center Content', 'ereco-wp' ),
						'id'		=> 'vertical_nav_content',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
						'visible'   => array( 
							array( 'header_layout_type', '=', 'header-vertical-nav' )
						),
					),

				),
			),
			//Header tab ends





			//theme-color tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_theme_color_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'theme-color',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Theme Color Settings', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Change Primary Theme Color', 'ereco-wp' ),
						'id'		=> 'change_primary_theme_color',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'If you want to change primary theme color of this page then check this option.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Primary Theme Color', 'ereco-wp' ),
						'id'		=> 'primary_theme_color',
						'type'		=> 'select',
						'options'   => ereco_mascot_metabox_get_list_of_predefined_theme_color_css_files(),
						'visible'   => array( 
							array( 'change_primary_theme_color', '=', true )
						),
					),
				),
			),
			//theme-color tab ends



			//Logo tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_logo_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'logo',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Logo Settings', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Alternative Site Brand', 'ereco-wp' ),
						'id'		=> 'logo_site_brand',
						'desc'		=> esc_html__( 'Enter the text that will be appeared as logo.', 'ereco-wp' ),
						'type'		=> 'text',
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Logo', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Use logo in replace of text?', 'ereco-wp' ),
						'id'		=> 'use_logo',
						'type'		=> 'select',
						'options'   => array(
							'inherit' 	=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Logo (Default)', 'ereco-wp' ),
						'id'		=> 'logo_default',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_logo', '!=', '0' ),
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Switchable logo', 'ereco-wp' ),
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Switchable logo(Light/Dark)?', 'ereco-wp' ),
						'id'		=> 'use_switchable_logo',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Default)', 'ereco-wp' ),
						'id'		=> 'logo_light',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_switchable_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Logo (Sticky Mode)', 'ereco-wp' ),
						'id'		=> 'logo_dark',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 'use_switchable_logo', '!=', '0' ),
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Logo height', 'ereco-wp' ),
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
					array(
						'name'		=> esc_html__( 'Maximum logo height(px)', 'ereco-wp' ),
						'id'		=> 'logo_maximum_height',
						'type'		=> 'slider',
						'desc'		=> esc_html__( 'Enter maximum logo height in px.', 'ereco-wp' ),
						'suffix' => esc_html__( 'px', 'ereco-wp' ),
						'js_options' => array(
							'min'  => 20,
							'max'  => 150,
							'step' => 1,
						),
						// Default value
						'std'		=> 40,
						'visible'   => array( 'use_logo', '!=', '0' ),
					),
				),
			),
			//Logo tab ends



			//Page Title tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_page_title_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'page-title',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Page Title', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Enable Page Title', 'ereco-wp' ),
						'id'		=> 'enable_page_title',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),

					array(
						'name' => esc_html__( 'Choose Page Title (Built with Elementor)', 'ereco-wp' ),
						'id'          => 'page_title_widget_area',
						'type'        => 'post',
						'desc'		=> sprintf(__('Create your own one from <a href="%s" target="_blank">Dashboard > Parts - Page Title</a>', 'ereco-wp'), admin_url('edit.php?post_type=page-title')),

						// Post type.
						'post_type'   => 'page-title',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Page Title', 'ereco-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),


					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Title & Subtitle', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Page Title Type', 'ereco-wp' ),
						'id'		=> 'page_title_type',
						'type'		=> 'select',
						'options'   => array(
							'page-title'   		=> esc_html__( 'Show This Page Title', 'ereco-wp' ),
							'custom-title'		=> esc_html__( 'Enter Custom Title', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Custom Title Text', 'ereco-wp' ),
						'id'		=> 'custom_page_title_text',
						'desc'		=> esc_html__( 'Enter the text that will be appeared as page title.', 'ereco-wp' ),
						'type'		=> 'text',
						'visible'   => array( 
							array( 'page_title_type', '=', 'custom-title' )
						),
					),
					array(
						'name'		=> esc_html__( 'Subtitle Text', 'ereco-wp' ),
						'id'		=> 'page_sub_title_text',
						'desc'		=> esc_html__( 'Enter the text that will be appeared as subtitle.', 'ereco-wp' ),
						'type'		=> 'text',
					),


					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Page Title Layout', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Choose Page Title Layout', 'ereco-wp' ),
						'id'		=> 'title_layout',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'standard'  => esc_html__( 'Standard', 'ereco-wp' ),
							'split'	 	=> esc_html__( 'Split', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Page Title Container', 'ereco-wp' ),
						'id'		=> 'title_container',
						'type'		=> 'select',
						'options'   => array(
							'inherit'			=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'container'			=> esc_html__( 'Container', 'ereco-wp' ),
							'container-fluid'   => esc_html__( 'Container Fluid', 'ereco-wp' )
						),
					),
					array(
						'name'		=> esc_html__( 'Page Title Text Alignment', 'ereco-wp' ),
						'id'		=> 'title_text_align',
						'type'		=> 'select',
						'options'   => $text_align_array,
					),
					array(
						'name'		=> esc_html__( 'Default Text Color', 'ereco-wp' ),
						'id'		=> 'title_default_text_color',
						'type'		=> 'select',
						'options'   => array(
							'inherit'		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'text-light' 	=> esc_html__( 'Light Text', 'ereco-wp' ),
							'text-dark'  	=> esc_html__( 'Dark Text', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Page Title Height', 'ereco-wp' ),
						'id'		=> 'title_area_height',
						'type'		=> 'select',
						'options'   => array(
							'inherit'				=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'padding-default'		=> esc_html__( 'Default', 'ereco-wp' ),
							'padding-extra-small'   => esc_html__( 'Extra Small', 'ereco-wp' ),
							'padding-small'			=> esc_html__( 'Small', 'ereco-wp' ),
							'padding-medium'		=> esc_html__( 'Medium', 'ereco-wp' ),
							'padding-large'			=> esc_html__( 'Large', 'ereco-wp' ),
							'padding-extra-large'   => esc_html__( 'Extra Large', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Show Title', 'ereco-wp' ),
						'id'		=> 'title_area_show_title',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Show Breadcrumbs', 'ereco-wp' ),
						'id'		=> 'title_area_show_breadcrumbs',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),


					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Page Title Background', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Page Title Background Type', 'ereco-wp' ),
						'id'		=> 'title_area_bg_type',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'bg-color'  => esc_html__( 'Background Color', 'ereco-wp' ),
							'bg-img'	=> esc_html__( 'Background Image', 'ereco-wp' ),
							'bg-video'	=> esc_html__( 'Background Video', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Background Color', 'ereco-wp' ),
						'id'		=> 'title_area_bgcolor',
						'type'		=> 'color',
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-color' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Image', 'ereco-wp' ),
						'id'		=> 'title_area_bgimg',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-img' )
						),
					),
					array(
						'name'		=> esc_html__( 'Add Background Video', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_status',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
						'visible'   => array( 
							array( 'title_area_bg_type', '=', 'bg-video' )
						),
					),
					array(
						'name'		=> esc_html__( 'Video Type', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_type',
						'type'		=> 'select',
						'options'   => array(
							'youtube'		=> esc_html__( 'Youtube', 'ereco-wp' ),
							'self-hosted'   => esc_html__( 'Self Hosted Video', 'ereco-wp' )
						),
						'visible'   => array( 
							array( 'title_area_bg_video_status', '=', '1' )
						),
					),
					array(
						'name'		=> esc_html__( 'Youtube Video ID', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_youtube_id',
						'desc'		=> esc_html__( 'Only put video ID not the whole URL. Example: E5ln4uR4TwQ', 'ereco-wp' ),
						'type'		=> 'text',
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'youtube' )
						),
					),
					array(
						'name'		=> esc_html__( 'Video Poster', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_video_poster',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),
					array(
						'name'		=> esc_html__( 'MP4 Video', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_mp4_video_url',
						'type'		=> 'file_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),
					array(
						'name'		=> esc_html__( 'WEBM Video', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_webm_video_url',
						'type'		=> 'file_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),
					array(
						'name'		=> esc_html__( 'OGV Video', 'ereco-wp' ),
						'id'		=> 'title_area_bg_video_self_hosted_ogv_video_url',
						'type'		=> 'file_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'title_area_bg_video_type', '=', 'self-hosted' )
						),
					),



					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Background Overlay', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Add Page Title Background Overlay?', 'ereco-wp' ),
						'id'		=> 'title_area_bg_layer_overlay_status',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Overlay Opacity', 'ereco-wp' ),
						'id'		=> 'title_area_bg_layer_overlay_opacity',
						'type'		=> 'slider',
						'desc'		=> esc_html__( 'Overlay on background image on Page Title.', 'ereco-wp' ),
						'js_options' => array(
							'min'  => 1,
							'max'  => 9,
							'step' => 1,
						),
						// Default value
						'std'		=> 7,
						'visible'   => array( 
							array( 'title_area_bg_layer_overlay_status', '=', '1' )
						),
					),
					array(
						'name'		=> esc_html__( 'Overlay Color', 'ereco-wp' ),
						'id'		=> 'title_area_bg_layer_overlay_color',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'dark'  	=> esc_html__( 'Dark', 'ereco-wp' ),
							'white' 	=> esc_html__( 'White', 'ereco-wp' )
						),
						'visible'   => array( 
							array( 'title_area_bg_layer_overlay_status', '=', '1' )
						),
					),



					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Animation Effect', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Title Animation Effect', 'ereco-wp' ),
						'id'		=> 'title_animation_effect',
						'type'		=> 'select_advanced',
						'options'   => ereco_mascot_animate_css_animation_list(),
					),
					array(
						'name'		=> esc_html__( 'Subtitle Animation Effect', 'ereco-wp' ),
						'id'		=> 'subtitle_animation_effect',
						'type'		=> 'select_advanced',
						'options'   => ereco_mascot_animate_css_animation_list(),
					),

					// DIVIDER
					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Typography', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Title Tag', 'ereco-wp' ),
						'id'		=> 'title_tag',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'h1'		=> 'h1',
							'h2'		=> 'h2',
							'h3'		=> 'h3',
							'h4'		=> 'h4',
							'h5'		=> 'h5',
							'h6'		=> 'h6',
						),
					),
					array(
						'name'		=> esc_html__( 'Title Color', 'ereco-wp' ),
						'id'		=> 'title_color',
						'type'		=> 'color',
					),
					array(
						'name'		=> esc_html__( 'Subtitle Tag', 'ereco-wp' ),
						'id'		=> 'subtitle_tag',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'h1'		=> 'h1',
							'h2'		=> 'h2',
							'h3'		=> 'h3',
							'h4'		=> 'h4',
							'h5'		=> 'h5',
							'h6'		=> 'h6',
						),
					),
					array(
						'name'		=> esc_html__( 'Subtitle Color', 'ereco-wp' ),
						'id'		=> 'subtitle_color',
						'type'		=> 'color',
					),
				),
			),
			//Page Title tab ends



			//Layout tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_layout_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'layout-setings',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Layout Settings', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Page Layout', 'ereco-wp' ),
						'id'		=> 'page_layout',
						'type'		=> 'select',
						'options'   => array(
							'inherit'		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'boxed'			=> esc_html__( 'Boxed', 'ereco-wp' ),
							'stretched'	 	=> esc_html__( 'Stretched', 'ereco-wp' )
						),
					),


					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Content Width Setting', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Content Width', 'ereco-wp' ),
						'id'		=> 'content_width',
						'desc'		=> esc_html__( 'Select content width. You can use any width by using custom CSS.', 'ereco-wp' ),
						'type'		=> 'select',
						'options'   => array(
							'inherit'				=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'container-970px'	 	=> esc_html__( '970px', 'ereco-wp' ),
							'container-default'		=> esc_html__( '1170px (Bootstrap Default)', 'ereco-wp' ),
							'container-1230px'		=> esc_html__( '1230px (Wide)', 'ereco-wp' ),
							'container-1300px'		=> esc_html__( '1300px (Wider)', 'ereco-wp' ),
							'container-1340px'		=> esc_html__( '1340px (Wider)', 'ereco-wp' ),
							'container-1440px'		=> esc_html__( '1440px (Wider)', 'ereco-wp' ),
							'container-1500px'		=> esc_html__( '1500px (Wider)', 'ereco-wp' ),
							'container-1600px'		=> esc_html__( '1600px (Wider)', 'ereco-wp' ),
							'container-100pr'	 	=> esc_html__( 'Fullwidth 100%', 'ereco-wp' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Solid Color(Stretched Mode)', 'ereco-wp' ),
						'id'		=> 'stretched_layout_bg_color',
						'type'		=> 'color',
					),


					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Boxed Layout Settings', 'ereco-wp' ),
						'visible'   => array( 'page_layout', '!=', 'stretched' ),
					),
					array(
						'name'		=> esc_html__( 'Padding Top(px)', 'ereco-wp' ),
						'id'		=> 'boxed_layout_padding_top',
						'desc'		=> esc_html__( 'Please put only integer value. Because the unit \'px\' will be automatically added at the end of the value.', 'ereco-wp' ),
						'type'		=> 'number',
						'visible'   => array( 
							array( 'page_layout', '!=', 'stretched' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Padding Bottom(px)', 'ereco-wp' ),
						'id'		=> 'boxed_layout_padding_bottom',
						'desc'		=> esc_html__( 'Please put only integer value. Because the unit \'px\' will be automatically added at the end of the value.', 'ereco-wp' ),
						'type'		=> 'number',
						'visible'   => array( 
							array( 'page_layout', '!=', 'stretched' ),
						),
					),
					array(
						'name'		=> esc_html__( 'Container Shadow?', 'ereco-wp' ),
						'id'		=> 'boxed_layout_container_shadow',
						'desc'		=> esc_html__( 'Add shadow around the container.', 'ereco-wp' ),
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
						'visible'   => array( 'page_layout', '!=', 'stretched' ),
					),


					array(
						'name'		=> esc_html__( 'Background Type', 'ereco-wp' ),
						'id'		=> 'boxed_layout_bg_type',
						'desc'		=> esc_html__( 'You can use patterns, image or solid color as a background.', 'ereco-wp' ),
						'type'		=> 'select',
						'options'   => array(
							'inherit'		=> esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'bg-color'	 	=> esc_html__( 'Solid Color', 'ereco-wp' ),
							'bg-pattern'	=> esc_html__( 'Patterns from Theme Library', 'ereco-wp' ),
							'bg-image'	 	=> esc_html__( 'Upload Own Image', 'ereco-wp' ),
						),
						'visible'   => array( 'page_layout', '!=', 'stretched' ),
					),
					array(
						'name'		=> esc_html__( 'Background Color', 'ereco-wp' ),
						'id'		=> 'boxed_layout_bg_type_color',
						'type'		=> 'color',
						'visible'   => array( 
							array( 'boxed_layout_bg_type', '=', 'bg-color' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Pattern from Theme Library', 'ereco-wp' ),
						'id'		=> 'boxed_layout_bg_type_pattern',
						'type'		=> 'image_select',
						// Array of 'value' => 'Image Source' pairs
						'options'   => $sample_patterns,
						'std'		=> $sample_patterns[key($sample_patterns)],
						// Allow to select multiple values? Default is false
						'visible'   => array( 
							array( 'boxed_layout_bg_type', '=', 'bg-pattern' )
						),
					),
					array(
						'name'		=> esc_html__( 'Background Image', 'ereco-wp' ),
						'id'		=> 'boxed_layout_bg_type_img',
						'type'		=> 'image_advanced',
						'max_file_uploads' => 1,
						'max_status'=> false,
						'visible'   => array( 
							array( 'boxed_layout_bg_type', '=', 'bg-image' )
						),
					),


					array(
						'type'		=> 'heading',
						'name'		=> esc_html__( 'Dark Layout Settings', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Enable Dark Layout Mode', 'ereco-wp' ),
						'id'		=> 'enable_dark_layout_mode',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'Check this box to enable dark layout mode.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Custom Dark Background Color', 'ereco-wp' ),
						'id'		=> 'dark_layout_mode_bg_color',
						'type'		=> 'color',
						'desc'		=> esc_html__( 'You can choose custom Background Color. Otherwise it will come from style css file.', 'ereco-wp' ),
					),
				),
			),
			//Layout tab ends



			//footer tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_footer_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'footer',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Footer Settings', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Footer Visibility', 'ereco-wp' ),
						'id'		=> 'footer_visibility',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Show or hide footer only for this page.', 'ereco-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Show', 'ereco-wp' ),
							'0'			=> esc_html__( 'Hide', 'ereco-wp' ),
						),
					),
					array(
						'name' => esc_html__( 'Choose Footer (Built with Elementor)', 'ereco-wp' ),
						'id'          => 'footer_widget_area',
						'type'        => 'post',
						'desc'		=> sprintf(__('Create your own one from <a href="%s" target="_blank">Dashboard > Parts - Footer</a>', 'ereco-wp'), admin_url('edit.php?post_type=footer')),

						// Post type.
						'post_type'   => 'footer',

						// Field type.
						'field_type'  => 'select_advanced',

						// Placeholder, inherited from `select_advanced` field.
						'placeholder' => esc_html__( 'Select a Footer', 'ereco-wp' ),

						// Query arguments. See https://codex.wordpress.org/Class_Reference/WP_Query
						'query_args'  => array(
							'post_status'    => 'publish',
							'posts_per_page' => - 1,
						),
					),
					array(
						'name'		=> esc_html__( 'Fixed Footer Bottom Effect', 'ereco-wp' ),
						'id'		=> 'footer_fixed_footer_bottom',
						'type'		=> 'select',
						'desc'		=> esc_html__( 'Enabling this option will make Footer gradually appear on scroll. This is popular for OnePage Websites.', 'ereco-wp' ),
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),
				),
			),
			//footer tab ends


			

			//slider tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_slider_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'slider',
				// Sub-fields
				'fields' => array(
					//slider tab starts
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Slider Settings', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Slider Type', 'ereco-wp' ),
						'id'		=> 'slider_type',
						'type'		=> 'select',
						'desc' => esc_html__( 'Select the type of slider you want to display.', 'ereco-wp' ),
						'options'   => array(
							'no-slider'			=> esc_html__( 'No Slider', 'ereco-wp' ),
							'rev-slider'		=> esc_html__( 'Slider Revolution', 'ereco-wp' ),
							'layer-slider'		=> esc_html__( 'Layer Slider', 'ereco-wp' ),
						),
						'std'		=> 'no-slider',
					),
					array(
						'name'		=> esc_html__( 'Choose Revolution Slider', 'ereco-wp' ),
						'id'		=> 'select_rev_slider',
						'type'		=> 'select',
						'desc' => esc_html__( 'Select the name(alias) of the revolution slider you want to display.', 'ereco-wp' ),
						'options'   => $list_rev_sliders,
						'visible'   => array( 'slider_type', '=', 'rev-slider' ),
					),
					array(
						'name'		=> esc_html__( 'Choose Layer Slider', 'ereco-wp' ),
						'id'		=> 'select_layer_slider',
						'type'		=> 'select',
						'desc' => esc_html__( 'Select the name(alias) of the revolution slider you want to display.', 'ereco-wp' ),
						'options'   => $list_layer_sliders,
						'visible'   => array( 'slider_type', '=', 'layer-slider' ),
					),
					array(
						'name'		=> esc_html__( 'Slider Position', 'ereco-wp' ),
						'id'		=> 'slider_position',
						'type'		=> 'select',
						'desc' => esc_html__( 'Choose position of the slider you want to display. You can put it below or above the header.', 'ereco-wp' ),
						'options'   => array(
							'default'		=> esc_html__( 'Default', 'ereco-wp' ),
							'below-header'	=> esc_html__( 'Below Header', 'ereco-wp' ),
							'above-header'	=> esc_html__( 'Above Header', 'ereco-wp' ),
						),
						'std'		=> 'default',
						'visible'   => array( 'slider_position', '!=', 'no-slider' ),
					),
					//slider tab ends


				),
			),
			//slider tab ends


			//general tab starts
			array(
				'id'     => 'ereco_mascot_' . 'page_mb_general_settings',
				// Group field
				'type'   => 'group',
				// Clone whole group?
				'clone'  => false,
				// Drag and drop clones to reorder them?
				'sort_clone' => false,
				// tab
				'tab'  => 'general',
				// Sub-fields
				'fields' => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'General Settings', 'ereco-wp' ),
						'desc' => esc_html__( 'Changes of the following settings will be effective only for this page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Hide Featured Image', 'ereco-wp' ),
						'id'		=> 'hide_featured_image',
						'type'		=> 'checkbox',
						'desc'		=> esc_html__( 'Enable/Disabling this option will show/hide Featured Image in blog page.', 'ereco-wp' ),
					),
					array(
						'name'		=> esc_html__( 'Show Comments', 'ereco-wp' ),
						'id'		=> 'show_comments',
						'type'		=> 'select',
						'options'   => array(
							'inherit'   => esc_html__( 'Inherit from Theme Options', 'ereco-wp' ),
							'1'			=> esc_html__( 'Yes', 'ereco-wp' ),
							'0'			=> esc_html__( 'No', 'ereco-wp' ),
						),
					),
				),
			),
			//general tab ends


		),
	);


	return $meta_boxes;
}
