<?php	
/*
*
*	Core Actions
*	---------------------------------------
*	Mascot Framework v1.0
* 	Copyright ThemeMascot 2017 - http://www.thememascot.com
*
*/


if(!function_exists('ereco_mascot_action_widgets_init')) {
	/**
	 * Init Widgets
	 */
	function ereco_mascot_action_widgets_init() {
	}
}


if(!function_exists('ereco_mascot_action_wp_head')) {
	/**
	 * Head Action
	 */
	function ereco_mascot_action_wp_head() {
		ereco_mascot_wp_head_pingback();
		ereco_mascot_wp_head_responsive_viewport();
		ereco_mascot_wp_head_favicon();
		ereco_mascot_wp_head_apple_touch_icons();
	}
}


if(!function_exists('ereco_mascot_wp_head_pingback')) {
	/**
	 * link pingback
	 */
	function ereco_mascot_wp_head_pingback() {
		if ( is_singular() && pings_open( get_queried_object() ) ) :?>

		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

		<?php endif;
	}
}


if(!function_exists('ereco_mascot_wp_head_responsive_viewport')) {
	/**
	 * Enable Responsive
	 */
	function ereco_mascot_wp_head_responsive_viewport() {
		if( ereco_mascot_get_redux_option( 'general-settings-enable-responsive', true ) ) { ?>
			<meta name="viewport" content="width=device-width, initial-scale=1">
		<?php } else { ?>
			<meta name="viewport" content="width=1140, user-scalable=yes">
		<?php }
	}
}


if(!function_exists('ereco_mascot_wp_head_favicon')) {
	/**
	 * Add Favicon
	 */
	function ereco_mascot_wp_head_favicon() {
		// Stop here if and icon was added via the customizer.
		if ( function_exists( 'has_site_icon' ) && has_site_icon() ) {
			return;
		}

		if( ereco_mascot_get_redux_option( 'general-settings-favicon', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( ereco_mascot_get_redux_option( 'general-settings-favicon', false, 'url' ) ); ?>" rel="shortcut icon">
		<?php } else { ?>
			<link href="<?php echo esc_url( ERECO_MASCOT_ASSETS_URI . '/images/logo/favicon.png') ?>" rel="shortcut icon" type="image/png">
		<?php }
	}
}


if(!function_exists('ereco_mascot_wp_head_apple_touch_icons')) {
	/**
	 * Add Apple Touch Icons 144x144, 114x114, 72x72, 32x32
	 */
	function ereco_mascot_wp_head_apple_touch_icons() {
		//apple-touch-icon
		if( ereco_mascot_get_redux_option( 'general-settings-apple-touch-32', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( ereco_mascot_get_redux_option( 'general-settings-apple-touch-32', false, 'url' ) ); ?>" rel="apple-touch-icon">
		<?php } else { ?>
			<link href="<?php echo esc_url( ERECO_MASCOT_ASSETS_URI . '/images/apple-touch-icon.png') ?>" rel="apple-touch-icon">
		<?php }
		
		//apple-touch-icon-72x72
		if( ereco_mascot_get_redux_option( 'general-settings-apple-touch-72', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( ereco_mascot_get_redux_option( 'general-settings-apple-touch-72', false, 'url' ) ); ?>" rel="apple-touch-icon" sizes="72x72">
		<?php } else { ?>
			<link href="<?php echo esc_url( ERECO_MASCOT_ASSETS_URI . '/images/apple-touch-icon-72x72.png') ?>" rel="apple-touch-icon" sizes="72x72">
		<?php }
		
		//apple-touch-icon-114x114
		if( ereco_mascot_get_redux_option( 'general-settings-apple-touch-114', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( ereco_mascot_get_redux_option( 'general-settings-apple-touch-114', false, 'url' ) ); ?>" rel="apple-touch-icon" sizes="114x114">
		<?php } else { ?>
			<link href="<?php echo esc_url( ERECO_MASCOT_ASSETS_URI . '/images/apple-touch-icon-114x114.png') ?>" rel="apple-touch-icon" sizes="114x114">
		<?php }
		
		//apple-touch-icon-144x144
		if( ereco_mascot_get_redux_option( 'general-settings-apple-touch-144', false, 'url' ) ) { ?>
			<link href="<?php echo esc_url( ereco_mascot_get_redux_option( 'general-settings-apple-touch-144', false, 'url' ) ); ?>" rel="apple-touch-icon" sizes="144x144">
		<?php } else { ?>
			<link href="<?php echo esc_url( ERECO_MASCOT_ASSETS_URI . '/images/apple-touch-icon-144x144.png') ?>" rel="apple-touch-icon" sizes="144x144">
		<?php }
	}
}


if(!function_exists('ereco_mascot_action_wp_head_at_the_end')) {
	/**
	 * Head Action put code at the end
	 */
	function ereco_mascot_action_wp_head_at_the_end() {
		ereco_mascot_wp_header_custom_html_js();
	}
}


if(!function_exists('ereco_mascot_wp_header_custom_html_js')) {
	/**
	 * Custom HTML/JS Code (in Footer)
	 */
	function ereco_mascot_wp_header_custom_html_js() {
		if( ereco_mascot_get_redux_option( 'custom-codes-custom-html-script-header' ) ) {
			echo "\n";
			echo ereco_mascot_get_redux_option( 'custom-codes-custom-html-script-header' );
			echo "\n";
		}
	}
}


if(!function_exists('ereco_mascot_action_wp_footer')) {
	/**
	 * Footer Action
	 */
	function ereco_mascot_action_wp_footer() {
		ereco_mascot_wp_footer_enable_smooth_scroll();
		ereco_mascot_wp_footer_enable_backtotop();
		ereco_mascot_wp_footer_custom_html_js();
	}
}


if(!function_exists('ereco_mascot_wp_footer_enable_smooth_scroll')) {
	/**
	 * Enable Smooth Scrolling
	 */
	function ereco_mascot_wp_footer_enable_smooth_scroll() {
		if( ereco_mascot_get_redux_option( 'general-settings-smooth-scroll' ) ) {
		}
	}
}


if(!function_exists('ereco_mascot_wp_footer_enable_backtotop')) {
	/**
	 * Enable Back To Top
	 */
	function ereco_mascot_wp_footer_enable_backtotop() {
		if( ereco_mascot_get_redux_option( 'general-settings-enable-backtotop' ) ) { ?>
			<a class="scroll-to-top" href="<?php echo esc_url( '#' )?>"><i class="fa fa-angle-up"></i></a>
		<?php }
	}
}


if(!function_exists('ereco_mascot_wp_footer_custom_html_js')) {
	/**
	 * Custom HTML/JS Code (in Footer)
	 */
	function ereco_mascot_wp_footer_custom_html_js() {
		if( ereco_mascot_get_redux_option( 'custom-codes-custom-html-script-footer' ) ) {
			echo "\n";
			echo ereco_mascot_get_redux_option( 'custom-codes-custom-html-script-footer' );
			echo "\n";
		}
	}
}


if (!function_exists( 'ereco_mascot_require_core_plugin_message')) {
	/**
	 * Prints a mesasge in the admin if user hides TGMPA plugin activation message
	 */
	function ereco_mascot_require_core_plugin_message() {
		if ( get_user_meta( get_current_user_id(), 'tgmpa_dismissed_notice_tgmpa', true ) && !ereco_mascot_core_plugin_installed() ) {
			$class = 'notice notice-error';
			$message = sprintf( esc_html__( 'For proper theme functioning, the %s plugins are required', 'ereco-wp' ),
				"<strong>Mascot Core</strong>"
			);
			$message .= '<a href="' . esc_url( admin_url( 'themes.php?page=tgmpa-install-plugins' ) ) . '">' . esc_html__( 'install', 'ereco-wp' ) . '</a>';
			$message .= esc_html__( ' and activate the plugins.', 'ereco-wp' );
			printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message ); 
		}
	}
	add_action( 'admin_notices', 'ereco_mascot_require_core_plugin_message' );
}


if(!function_exists('ereco_mascot_add_theme_page')) {
	/**
	 * Add Theme Page
	 */
	function ereco_mascot_add_theme_page() {
		global $ereco_mascot_theme_info;
		$theme_name = $ereco_mascot_theme_info->get('Name');
		add_menu_page( 
			$theme_name,
			$theme_name,
			'manage_options',
			'mascot-about',
			'ereco_mascot_theme_page_about',
			'dashicons-admin-generic',
			4
		);
		add_submenu_page( 
			'mascot-about',
			esc_html__( 'Support & Help', 'ereco-wp' ),
			esc_html__( 'Support & Help', 'ereco-wp' ),
			'manage_options',
			'mascot-docs',
			'ereco_mascot_theme_page_docs'
		);
		add_submenu_page( 
			'mascot-about',
			esc_html__( 'FAQ', 'ereco-wp' ),
			esc_html__( 'FAQ', 'ereco-wp' ),
			'manage_options',
			'mascot-faq',
			'ereco_mascot_theme_page_faq'
		);
		add_submenu_page( 
			'mascot-about',
			esc_html__( 'System Status', 'ereco-wp' ),
			esc_html__( 'System Status', 'ereco-wp' ),
			'manage_options',
			'mascot-system-status',
			'ereco_mascot_theme_page_system_status'
		);
		if ( ereco_mascot_core_plugin_installed() ) {
			add_submenu_page( 
				'mascot-about',
				esc_html__( 'System Status', 'ereco-wp' ),
				esc_html__( 'System Status', 'ereco-wp' ),
				'manage_options',
				'mascot-system-status', 
				'ereco_mascot_theme_page_system_status'
			);
		}
	}
	add_action('admin_menu', 'ereco_mascot_add_theme_page');
}

if(!function_exists('ereco_mascot_theme_page_about')) {
	function ereco_mascot_theme_page_about() {
		include( ERECO_MASCOT_TEMPLATE_DIR . '/admin/admin-tpl/mascot-about.php' );
	}
}

if(!function_exists('ereco_mascot_theme_page_docs')) {
	function ereco_mascot_theme_page_docs() {
		include( ERECO_MASCOT_TEMPLATE_DIR . '/admin/admin-tpl/mascot-docs.php' );
	}
}

if(!function_exists('ereco_mascot_theme_page_faq')) {
	function ereco_mascot_theme_page_faq() {
		include( ERECO_MASCOT_TEMPLATE_DIR . '/admin/admin-tpl/mascot-faq.php' );
	}
}

if(!function_exists('ereco_mascot_theme_page_system_status')) {
	function ereco_mascot_theme_page_system_status() {
		include( ERECO_MASCOT_TEMPLATE_DIR . '/admin/admin-tpl/mascot-system-status.php' );
	}
}
