<?php




if(!function_exists('ereco_mascot_get_metabox_icon_pack_array')) {
	/**
	 * Makes and return iconpack dropdown fields for metabox with dependency
	 *
	 */
	function ereco_mascot_get_metabox_icon_pack_array( $icon_pack_field_id = "choose_iconpack", $icon_pack_visible = array(), $icon_pack_tab = "" ) {
		global $ereco_mascot_icon_font_packs;
		$icon_pack_key_name_array = $ereco_mascot_icon_font_packs->getIconFontPackNamesAarray();

		//icon pack parent array
		$icon_pack_parent = array(
			'id'	=> $icon_pack_field_id,
			'name'	=> esc_html__( 'Choose Icon Pack', 'ereco-wp' ),
			'type'	=> 'select',
			'options' => $icon_pack_key_name_array,
		);

		if( !empty( $icon_pack_visible ) ) {
			$icon_pack_parent["visible"] = $icon_pack_visible;
		}

		if( $icon_pack_tab != "" ) {
			$icon_pack_parent["tab"] = $icon_pack_tab;
		}

		$icon_pack_icons = array();
		$icon_pack_icons[] = $icon_pack_parent;

		if(is_array($icon_pack_key_name_array) && count($icon_pack_key_name_array)) {
			foreach($icon_pack_key_name_array as $key => $name) {
				$child_icon_pack = array(
					'id'		=> $icon_pack_field_id . '_' . $key,
					'name'		=> $name,
					'type'		=> 'select',
					'options'	=> $ereco_mascot_icon_font_packs->getIconFontPackByKey( $key )->getIconList(),
					'desc'		=> sprintf( esc_html__( 'See full list of icons from %1$shere%2$s', 'ereco-wp' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
					'visible'	=> array( $icon_pack_field_id, '=', $key ),
				);

				if( $icon_pack_tab != "" ) {
					$child_icon_pack["tab"] = $icon_pack_tab;
				}
				$icon_pack_icons[] = $child_icon_pack;
			}
		}
		return $icon_pack_icons;
	}
}



if(!function_exists('ereco_mascot_get_elementor_icon_pack_array')) {
	/**
	 * Makes and return iconpack dropdown fields for elementor
	 *
	 */
	function ereco_mascot_get_elementor_icon_pack_array( $control_object, $icon_pack_dependency = array(), $icon_pack_grounp = "" ) {

		global $ereco_mascot_icon_font_packs;
		$icon_pack_collection = $ereco_mascot_icon_font_packs->getIconFontPackKeys();
		$icon_pack_key_name_array = $ereco_mascot_icon_font_packs->getIconFontPackNamesAarray();

		$control_object->add_control(
				'icon_pack',
				[
						'label' => esc_html__( "Choose Icon Pack", 'ereco-wp' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => $icon_pack_key_name_array,
						'default' => 'font_awesome',
						'condition' => [
							'icon_type' => array('font-icon')
						]
				]
		);

		$icon_pack_icons = array();
		if(is_array($icon_pack_collection) && count($icon_pack_collection)) {
			foreach($icon_pack_collection as $key => $pack_name) {
				$control_object->add_control(
						$pack_name,
						[
							'label' => esc_html__( "Choose Icon", 'ereco-wp' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => ( $ereco_mascot_icon_font_packs->getIconFontPackByKey( $pack_name )->getIconList() ),
							'condition' => [
								'icon_type' => array('font-icon'),
								'icon_pack' => array($pack_name)
							]
						]
				);
			}
		}

		return;
	}
}