<?php
	/**
	 * ReduxFramework Sample Config File
	 * For full documentation, please visit: http://docs.reduxframework.com/
	 */

	if ( ! class_exists( 'Redux' ) ) {
		return;
	}

	// This is your option name where all the Redux data is stored.
	$opt_name = "ereco_mascot_redux_theme_opt";

	// This line is only for altering the demo. Can be easily removed.
	$opt_name = apply_filters( 'ereco_mascot_redux_theme_opt/opt_name', $opt_name );

	$site_url = site_url();

	//custom action hook for this template:
	add_action('redux/options/ereco_mascot_redux_theme_opt/saved', 'ereco_mascot_generate_css_for_custom_theme_color_from_scss');
	add_action('redux/options/ereco_mascot_redux_theme_opt/saved', 'ereco_mascot_generate_dynamic_css');
	add_action('redux/options/ereco_mascot_redux_theme_opt/reset', 'ereco_mascot_generate_css_for_custom_theme_color_from_scss');
	add_action('redux/options/ereco_mascot_redux_theme_opt/reset', 'ereco_mascot_generate_dynamic_css');
	add_action('redux/options/ereco_mascot_redux_theme_opt/section/reset', 'ereco_mascot_generate_css_for_custom_theme_color_from_scss');
	add_action('redux/options/ereco_mascot_redux_theme_opt/section/reset', 'ereco_mascot_generate_dynamic_css');

	//required files
	require_once( 'filter-social-links.php' );
	/*
	 *
	 * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
	 *
	 */

	// Background Patterns Reader
	$sample_patterns_path = ERECO_MASCOT_ADMIN_ASSETS_DIR . '/images/pattern/';
	$sample_patterns_url  = ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/pattern/';
	$sample_patterns      = array();
	
	if ( is_dir( $sample_patterns_path ) ) {

		if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
			$sample_patterns = array();

			while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

				if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
					$name              = explode( '.', $sample_patterns_file );
					$name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
					$sample_patterns[ $sample_patterns_url . $sample_patterns_file ] = array(
						'alt' => $name,
						'img' => $sample_patterns_url . $sample_patterns_file
					);
				}
			}
		}
	}


	/*
	 *
	 * ---> START SECTIONS
	 *
	 */

	/*

		As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


	 */


	// -> START General Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'General', 'ereco-wp' ),
		'id'     => 'general-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-admin-home',
		'fields' => array(
			array(
				'id'       => 'general-settings-favicon',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Favicon', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a 32px x 32px png/gif image that will represent your website favicon.', 'ereco-wp' ),
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/favicon.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-144',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 144x144 Icon', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a 144px x 144px png image that will be your website bookmark on retina iOS devices.', 'ereco-wp' ),
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon-144x144.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-114',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 114x114 Icon', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a 114px x 114px png image that will be your website bookmark on retina iOS devices.', 'ereco-wp' ),
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon-114x114.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-72',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 72x72 Icon', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a 72px x 72px Png image that will be your website bookmark on non-retina iOS devices.', 'ereco-wp' ),
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon-72x72.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-32',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 32x32 Icon', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a 32px x 32px png image that will be your website bookmark on non-retina iOS devices.', 'ereco-wp' ),
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon.png' ),
			),
			array(
				'id'       => 'general-settings-enable-responsive',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Responsive', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable the responsive behaviour of the theme', 'ereco-wp' ),
				'default'  => true,
			),
			array(
				'id'       => 'general-settings-enable-backtotop',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Back To Top', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable Back to Top button that appears in the bottom right corner of the screen.', 'ereco-wp' ),
				'default'  => true,
			),


			array(
				'id'       => 'general-settings-smooth-scroll',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Smooth Scroll', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices).', 'ereco-wp' ),
				'default'  => true,
			),

			array(
				'id'       => 'general-settings-enable-element-animation-effect',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Animation Effect on Different Elements', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will enable animation effect.', 'ereco-wp' ),
				'default'  => true,
			),
		)
	) );

	$my_wp_get_theme = wp_get_theme();
	// -> START Logo Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Logo', 'ereco-wp' ),
		'id'     => 'logo-settings',
		'desc'   => sprintf( esc_html__( 'If you want to upload SVG logo then please install this %1$ssvg plugin%2$s', 'ereco-wp' ), '<a target="_blank" href="' . esc_url( 'https://wordpress.org/plugins/svg-support/' ) . '">', '</a>' ),
		'icon'   => 'dashicons-before dashicons-palmtree',
		'fields' => array(
			array(
				'id'       => 'logo-settings-site-brand',
				'type'     => 'text',
				'title'    => esc_html__( 'Site Brand', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared as logo', 'ereco-wp' ),
				'desc'     => '',
				'default'  => $my_wp_get_theme->get( 'Name' ),
			),

			array(
				'id'       => 'logo-settings-want-to-use-logo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use logo in replace of "Site Brand" Text?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you want to use logo then please enable it.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

			array(
				'id'       => 'logo-settings-switchable-logo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Switchable logo(Light+Dark)?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you want to use switchable logo then please enable it.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),

			array(
				'id'       => 'logo-settings-logo-default',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Default)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload/choose your custom logo image', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => '',
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/logo-wide.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '0' ),
			),

			array(
				'id'       => 'logo-settings-logo-primary',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Default)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a logo for the default mode.', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => '',
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/logo-wide-white.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '1' ),
			),

			array(
				'id'       => 'logo-settings-logo-on-sticky',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Sticky Mode)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Upload a logo for the sticky mode.', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => '',
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/logo-wide.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '1' ),
			),


			array(
				'id'            => 'logo-settings-maximum-logo-width',
				'type'          => 'slider',
				'title'         => esc_html__( 'Maximum Logo Width(px)', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Enter maximum logo width in px.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 220,
				'min'           => 20,
				'step'          => 1,
				'max'           => 500,
				'display_value' => 'text',
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),


			array(
				'id'            => 'logo-settings-maximum-logo-height',
				'type'          => 'slider',
				'title'         => esc_html__( 'Maximum Logo Height(px)', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Enter maximum logo height in px.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 55,
				'min'           => 20,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),
			array(
				'id'            => 'logo-settings-maximum-logo-height-in-sticky-mode',
				'type'          => 'slider',
				'title'         => esc_html__( 'Maximum Logo Height(px) in Sticky Mode', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Enter maximum logo height in px in sticky header mode.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 40,
				'min'           => 20,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),

			array(
				'id'            => 'logo-settings-logo-margin-around',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin(px) Around Logo', 'ereco-wp' ),
			),

			array(
				'id'            => 'logo-settings-logo-sticky-margin-around',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin(px) Around Logo in Sticky Mode', 'ereco-wp' ),
			),

			array(
				'id'       => 'logo-settings-admin-login-logo',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'WordPress Admin Login Logo', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Change the default wordpress login logo. Dimensions should be 250x50 px', 'ereco-wp' ),
				'compiler' => 'true',
				'desc'     => '',
				'default'  => array( 'url' => ERECO_MASCOT_ASSETS_URI . '/images/logo/logo-wide.png' ),
			),

		)
	) );


	// -> START Theme Color Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Theme Color Settings', 'ereco-wp' ),
		'id'     => 'theme-color-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-art',
		'fields' => array(
			array(
				'id'       => 'theme-color-settings-theme-color-type',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Website Primary Theme Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select website primary theme color', 'ereco-wp' ),
				'options' => array(
					'predefined' => esc_html__( 'Predefined Theme Colors', 'ereco-wp' ),
					'custom'     => esc_html__( 'Custom Theme Color', 'ereco-wp' )
				),
				'default' => 'predefined',
			),
			array(
				'id'       => 'theme-color-settings-primary-theme-color',
				'type'     => 'select',
				'title'    => esc_html__( 'Predefined Theme Colors', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose one from these predefined theme colors', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> ereco_mascot_metabox_get_list_of_predefined_theme_color_css_files(),
				'default'  => 'theme-skin-color-set1.css',
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'predefined' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color1',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Primary Theme Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom primary color for the theme.', 'ereco-wp' ),
				'default'  => '#1296CC',
				'transparent'  => false,
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color2',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Secondary Theme Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom secondary color for the theme.', 'ereco-wp' ),
				'default'  => '#dd9933',
				'transparent'  => false,
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color3',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom 3rd Theme Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom 3rd color for the theme.', 'ereco-wp' ),
				'default'  => '#dd9933',
				'transparent'  => false,
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color4',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom 4th Theme Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom 4th color for the theme.', 'ereco-wp' ),
				'default'  => '#dd9933',
				'transparent'  => false,
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color-filename',
				'type'     => 'text',
				'title'    => esc_html__( 'File Name to Save This Color Set (Optional)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you want to save this color set as a css file then give a name of the file. File name must starts with "theme-color-". Same name will override exising one. Leave empty for not to save it as a css file.', 'ereco-wp' ),
				'desc'     => '',
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),



			//Site Category CSS files
			array(
				'id'       	=> 'theme-color-settings-theme-color-custom-site-cssfile-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Attach Premade CSS File to get extra styling throughout the site.', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'theme-color-settings-premade-sitewise-css-file',
				'type'     => 'select',
				'title'    => esc_html__( 'Attach Premade CSS File into the header', 'ereco-wp' ),
				'subtitle' => esc_html__( 'These files are located in assets/css/sites folder of this theme.', 'ereco-wp' ),
				'options'	=> ereco_mascot_metabox_get_list_of_premade_sitewise_css_files(),
			),
		)
	) );


	// -> START Layout Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Layout Settings', 'ereco-wp' ),
		'id'     => 'layout-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-table',
		'fields' => array(
			array(
				'id'        => 'layout-settings-page-layout',
				'type'      => 'button_set',
				'compiler'  => true,
				'title'     => esc_html__( 'Page Layout', 'ereco-wp' ),
				'subtitle'  => esc_html__( 'Select primary page layout of your theme', 'ereco-wp' ),
				'options'   => array(
					'boxed'        => esc_html__( 'Boxed', 'ereco-wp' ),
					'stretched'    => esc_html__( 'Stretched', 'ereco-wp' )
				),
				'default'   => 'stretched',
			),

			array(
				'id'       => 'layout-settings-content-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Content Width', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select content width. You can use any width by using custom CSS', 'ereco-wp' ),
				'options' => array(
					'container-970px'     => esc_html__( '970px', 'ereco-wp' ),
					'container-default'   => esc_html__( '1170px (Bootstrap Default)', 'ereco-wp' ),
					'container-1230px'    => esc_html__( '1230px', 'ereco-wp' ),
					'container-1300px'    => esc_html__( '1300px', 'ereco-wp' ),
					'container-1340px'    => esc_html__( '1340px', 'ereco-wp' ),
					'container-1440px'    => esc_html__( '1440px', 'ereco-wp' ),
					'container-1500px'    => esc_html__( '1500px', 'ereco-wp' ),
					'container-1600px'    => esc_html__( '1600px', 'ereco-wp' ),
					'container-100pr'     => esc_html__( 'Fullwidth 100%', 'ereco-wp' )
				),
				'default' => 'container-1230px',
			),
			array(
				'id'       => 'layout-settings-stretched-layout-bg-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Solid Color(Stretched Mode)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom color for background.', 'ereco-wp' ),
				'transparent' => false,
				'required' => array( 'layout-settings-page-layout', '=', 'stretched' ),
			),


			//section H3 Starts
			array(
				'id'       => 'layout-settings-boxed-layout-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Boxed Layout Settings', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for Boxed Layout.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 'layout-settings-page-layout', '=', 'boxed' ),
			),
			array(
				'id'             => 'layout-settings-boxed-layout-padding-top-bottom',
				'type'           => 'spacing',
				'mode'           => 'padding',
				'all'            => false,
				// Have one field that applies to all
				'top'            => true,     // Disable the top
				'right'          => false,     // Disable the right
				'bottom'         => true,     // Disable the bottom
				'left'           => false,     // Disable the left
				'units'          => 'px',
				'units_extended' => 'true',
				'display_units'  => true,   // Set to false to hide the units if the units are specified
				'title'          => esc_html__( 'Padding Top & Bottom(px)', 'ereco-wp' ),
				'subtitle'       => esc_html__( 'Top and bottom padding in px for boxed layout.', 'ereco-wp' ),
				'desc'           => esc_html__( 'Controls the top and bottom padding of the boxed layout. Ex: 40px, 40px. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'ereco-wp' ),
				'default'            => array(
					'padding-top'     => '40', 
					'padding-bottom'  => '40', 
					'units'          => 'px', 
				)
			),
			array(
				'id'       => 'layout-settings-boxed-layout-container-shadow',
				'type'     => 'switch',
				'title'    => esc_html__( 'Container Shadow?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Add shadow around the container.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'On',
				'off'      => 'Off',
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type',
				'type'     => 'radio',
				'title'    => esc_html__( 'Background Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can use patterns, image or solid color as a background.', 'ereco-wp' ),
				'options'	=> array(
					'bg-color'     => esc_html__( 'Solid Color', 'ereco-wp' ),
					'bg-patter'    => esc_html__( 'Patterns from Theme Library', 'ereco-wp' ),
					'bg-image'     => esc_html__( 'Upload Own Image', 'ereco-wp' ),
				),
				'default'  => 'bg-color',
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Solid Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom color for background (default: #444).', 'ereco-wp' ),
				'default'  => '#444',
				'transparent' => true,
				'required' => array( 'layout-settings-boxed-layout-bg-type', '=', 'bg-color' ),
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type-pattern',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Patterns from Theme Library', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select a patterns by clicking on it.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> $sample_patterns,
				'default'  => key($sample_patterns),
				'required' => array( 'layout-settings-boxed-layout-bg-type', '=', 'bg-patter' ),
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type-bgimg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background Image', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Body background image.', 'ereco-wp' ),
				'background-color' => false,
				'required' => array( 'layout-settings-boxed-layout-bg-type', '=', 'bg-image' ),
			),
			array(
				'id'       => 'layout-settings-boxed-layout-ends',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START Header
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header', 'ereco-wp' ),
		'id'     => 'header',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
	) );


	// -> START Header Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header', 'ereco-wp' ),
		'id'     => 'header-layout',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'header-settings-choose-header-visibility',
				'type'     => 'switch',
				'title'    => esc_html__( 'Header Visibility', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Show or hide header globally', 'ereco-wp' ),
				'default'  => 1,
				'on'       => 'Show',
				'off'      => 'Hide',
			),



			array(
				'id'        => 'header-settings-choose-header-top-cpt-elementor-info',
				'type'      => 'info',
				'title'     => esc_html__( 'Elementor Headers', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'header-settings-choose-header-top-cpt-elementor',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Header (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('You can create your own Header from <a href="%s" target="_blank">Dashboard > Parts - Header Top</a>', 'ereco-wp'), admin_url('edit.php?post_type=header-top')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'header-top' ),
				),
			),
			array(
				'id'       => 'header-settings-choose-header-top-cpt-elementor-transparent',
				'type'     => 'select',
				'title'    => esc_html__( 'Header - Transparent (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('You can create your own Header from <a href="%s" target="_blank">Dashboard > Parts - Header Top</a>', 'ereco-wp'), admin_url('edit.php?post_type=header-top')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'header-top' ),
				),
			),
			array(
				'id'       => 'header-settings-choose-header-top-cpt-elementor-sticky',
				'type'     => 'select',
				'title'    => esc_html__( 'Header - Sticky (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('It will be shown when you scroll down. You can create your own Header from <a href="%s" target="_blank">Dashboard > Parts - Header Top</a>', 'ereco-wp'), admin_url('edit.php?post_type=header-top')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'header-top' ),
				),
			),
			array(
				'id'       => 'header-settings-choose-header-top-cpt-elementor-mobile',
				'type'     => 'select',
				'title'    => esc_html__( 'Header - Mobile/Tab (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('It will be visible on Tab & Mobile devices only. You can create your own Header from <a href="%s" target="_blank">Dashboard > Parts - Header Top</a>', 'ereco-wp'), admin_url('edit.php?post_type=header-top')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'header-top' ),
				),
			),
		)
	) );


	// -> START Header Navigation Row
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Default Header Navigation Row', 'ereco-wp' ),
		'id'     => 'header-navigation-layout',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-navigation-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'ereco-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),



			
			array(
				'id'       => 'header-settings-navigation-show-header-nav-row',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Header Navigation Row', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enabling/Disabling this option will show/hide Whole Header Navigation Row section.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),































































			array(
				'id'       => 'header-settings-header-layout-type-container',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Header Nav Row Container', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Put Header nav content boxed or stretched fullwidth.', 'ereco-wp' ),
				'options'	=> array(
					'container' => esc_html__( 'Container', 'ereco-wp' ),
					'container-fluid' => esc_html__( 'Container Fluid', 'ereco-wp' )
				),
				'default' => 'container',
			),


			array(
				'id'       => 'header-settings-header-layout-floating-bg-shadow',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Header Background Shadow (Header Floating)', 'ereco-wp' ),
				'options'	=> array(
					'header-bg-no-shadow'		=> esc_html__( 'No Shadow', 'ereco-wp' ),
					'header-bg-dark-shadow'		=> esc_html__( 'Dark Background Shadow', 'ereco-wp' ),
					'header-bg-light-shadow'	=> esc_html__( 'Light Background Shadow', 'ereco-wp' ),
				),
				'default' => 'header-bg-no-shadow',
				'required' => array( 
					array( 'header-settings-choose-header-layout-type', 'contains', 'header-floating' )
				)
			),


			array(
				'id'       => 'header-settings-header-layout-floating-text-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Text Color (Header Floating)', 'ereco-wp' ),
				'options'	=> array(
					'header-floating-bg-dark-text-white'	=> esc_html__( 'White Text', 'ereco-wp' ),
					'header-floating-bg-white-text-dark'		=> esc_html__( 'Dark Text', 'ereco-wp' ),
				),
				'default' => 'header-floating-bg-dark-text-white',
				'required' => array( 
					array( 'header-settings-choose-header-layout-type', 'contains', 'header-floating' )
				)
			),

			array(
				'id'       => 'header-settings-header-layout-floating-bg-color-sticky',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Color (on Header Floating + Sticky)', 'ereco-wp' ),
				'options'	=> array(
					'header-floating-sticky-bg-white'	=> esc_html__( 'White BG', 'ereco-wp' ),
					'header-floating-sticky-bg-dark'		=> esc_html__( 'Dark BG', 'ereco-wp' ),
				),
				'default' => 'header-floating-sticky-bg-dark',
				'required' => array( 
					array( 'header-settings-choose-header-layout-type', 'contains', 'header-floating' )
				)
			),

			array(
				'id'       => 'header-settings-choose-header-layout-type',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Header Layout Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the type of header you would like to use', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'header-default' => array(
						'alt' => 'Header Default',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-default.jpg'
					),
					'header-default2' => array(
						'alt' => 'Header Default 2 - Left Logo Left Nav',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-default2.jpg'
					),
					'header-default3' => array(
						'alt' => 'Header Default 3 - No logo',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-default3.jpg'
					),

					'header-floating-left-logo' => array(
						'alt' => 'Floating Header - With Logo',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-floating-left-logo.jpg'
					),
					'header-floating-left-logo-left-nav' => array(
						'alt' => 'Floating Header - Left Logo Left Nav',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-floating-left-logo-left-nav.jpg'
					),
					'header-floating-no-logo' => array(
						'alt' => 'Floating Header (No Logo)',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-floating-no-logo.jpg'
					),


					'header-nav-hanging' => array(
						'alt' => 'Hanging Nav',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-nav-hanging.jpg'
					),

					'header-mobile-nav' => array(
						'alt' => 'Mobile Nav',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-mobile-nav.jpg'
					),
					'header-mobile-nav-floating' => array(
						'alt' => 'Mobile Nav - Floating',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-mobile-nav.jpg'
					),
					'header-side-panel-nav' => array(
						'alt' => 'Side Push Panel Nav',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-side-panel-nav.jpg'
					),
					'header-vertical-nav' => array(
						'alt' => 'Vertical Nav',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-vertical-nav.jpg'
					),
				),
				'default'  => 'header-default',
			),































			array(
				'id'       => 'header-settings-navigation-show-header-nav-bar-fixed-on-scroll',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Navigation Bar Fixed/Sticky on Scroll?', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-header-nav-bar-always-visible-on-scroll',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Navigation Bar Always Visible(Fixed at the top) on Sticky?', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'header-settings-navigation-show-header-nav-bar-fixed-on-scroll', '=', '1' ),
			),

			array(
				'id'       => 'header-settings-navigation-bgcolor-use-themecolor',
				'type'     => 'select',
				'title'    => esc_html__( 'Use Theme Color in Background?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Use theme color or custom bg color in Header Navigation Row', 'ereco-wp' ),
				'desc'     => '',
				'options'  => ereco_mascot_theme_color_list(),
				'default'  => '',
			),
			array(
				'id'       => 'header-settings-navigation-custom-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Background Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom background color for Header Navigation Row.', 'ereco-wp' ),
				'transparent' => true,
				'required' => array( 'header-settings-navigation-bgcolor-use-themecolor', '=', '' ),
			),



			array(
				'id'        => 'header-settings-navigation-custom-navigation-link-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Cart/Search/Side Push Icons', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'header-settings-navigation-custom-navigation-link-n-icon-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Navigation Link and Cart/Search/Side Push Icon Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Pick a custom color for link and icons on Header Navigation Row.', 'ereco-wp' ),
				'transparent' => true,
			),
			array(
				'id'       => 'header-settings-navigation-show-menu-cart-icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Cart Icon', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Add Cart Icon on the right hand side of the menu. WooCommerce plugin needs to be installed.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
			),
			array(
				'id'       => 'header-settings-navigation-show-menu-cart-icon-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Cart Icon in Mobile Device', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-menu-cart-icon', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-menu-cart-icon-code',
				'type'     => 'text',
				'title'    => esc_html__( 'Cart Icon', 'ereco-wp' ),
				'subtitle' => sprintf( esc_html__( 'You can change the search icon from here. See full list of icons from %1$shere%2$s', 'ereco-wp' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
				'desc'     => '',
				'default'  => 'fa fa-shopping-cart',
				'required' => array( 'header-settings-navigation-show-menu-cart-icon', '=', '1' ),
			),


			array(
				'id'       => 'header-settings-navigation-show-menu-search-icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Search Icon', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Add Search Icon on the right hand side of the menu.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
			),
			array(
				'id'       => 'header-settings-navigation-show-menu-search-icon-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Search Icon in Mobile Device', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-menu-search-icon', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-menu-search-icon-code',
				'type'     => 'text',
				'title'    => esc_html__( 'Search Icon', 'ereco-wp' ),
				'subtitle' => sprintf( esc_html__( 'You can change the search icon from here. See full list of icons from %1$shere%2$s', 'ereco-wp' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
				'desc'     => '',
				'default'  => 'fa fa-search',
				'required' => array( 'header-settings-navigation-show-menu-search-icon', '=', '1' ),
			),


			array(
				'id'       => 'header-settings-navigation-show-side-push-panel',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Side Push Panel', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Add Side Push Icon on the right hand side of the menu to Enable/Disable Side Push Panel section. You can easily add your widgets to this section from Appearance > Widgets (Side Push Panel Sidebar)', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
			),
			array(
				'id'       => 'header-settings-navigation-show-side-push-panel-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Side Push Panel Icon in Mobile Device', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-side-push-panel', '=', '1' ),
			),


			//Header Nav - Custom Button
			array(
				'id'        => 'header-settings-navigation-custom-button-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Custom Button', 'ereco-wp' ),
				'subtitle'  => esc_html__( 'Add Custom Button on the right hand side of the Header Navigation Row', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'header-settings-navigation-show-custom-button',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Custom Button', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Add Custom Button on the right hand side of the Header Navigation Row.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
			),
			array(
				'id'       => 'header-settings-navigation-show-custom-button-reflect-other-pages',
				'type'     => 'switch',
				'title'    => esc_html__( 'Reflect This Settings in Other Pages too?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you enable it then this button will be shown on other header styles chose from Page Settings.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-info',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Custom Button Info', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enter your custom button info.', 'ereco-wp' ),
				'desc'     => esc_html__( 'Show a custom button in the Header Navigation Row.', 'ereco-wp' ),
				'label'    => true,
				'options'	=> array(
					'title'  => '',
					'link'   => '',
				),
				'default' => array(
					'title'  => esc_html__( 'Custom Button', 'ereco-wp' ),
					'link'   => '#',
				),
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-design-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Design Style', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array_flip( ereco_mascot_get_btn_design_style() ),
				'default'  => 'btn-gray',
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Size', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array_flip( ereco_mascot_get_button_size() ),
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-flat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Flat', 'ereco-wp' ),
				'default'  => 0,
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-outlined',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Outlined', 'ereco-wp' ),
				'default'  => 0,
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-round',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Round', 'ereco-wp' ),
				'default'  => 0,
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-link-open-in-window',
				'type'     => 'select',
				'title'    => esc_html__( 'Open Link in', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'_blank' => esc_html__( 'New Tab', 'ereco-wp' ),
					'_self'  => esc_html__( 'Same Tab', 'ereco-wp' ),
				),
				'default'  => '_blank',
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-show-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Button in Mobile Device', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'ereco-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-custom-button', '=', '1' ),
			),


			array(
				'id'        => 'header-settings-navigation-color-scheme-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Navigation Color Scheme', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-color-scheme',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Color Scheme', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the color scheme of main menu', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'default' => array(
						'alt' => esc_html__( 'Default', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/default.jpg '
					),
					'blue' => array(
						'alt' => esc_html__( 'Blue', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/blue.jpg '
					),
					'green' => array(
						'alt' => esc_html__( 'Green', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/green.jpg '
					),
					'orange' => array(
						'alt' => esc_html__( 'Orange', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/orange.jpg '
					),
					'pink' => array(
						'alt' => esc_html__( 'Pink', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/pink.jpg '
					),
					'purple' => array(
						'alt' => esc_html__( 'Purple', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/purple.jpg '
					),
					'red' => array(
						'alt' => esc_html__( 'Red', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/red.jpg '
					),
					'yellow' => array(
						'alt' => esc_html__( 'Yellow', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/yellow.jpg '
					)
				),
				'default'  => 'default',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

			array(
				'id'       => 'header-settings-navigation-primary-effect',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Primary Effect', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'fade'  => esc_html__( 'Fade', 'ereco-wp' ),
					'slide' => esc_html__( 'Slide', 'ereco-wp' )
				),
				'default'  => 'slide',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-css3-animation',
				'type'     => 'button_set',
				'title'    => esc_html__( 'CSS3 Animation', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'none'      => esc_html__( 'None', 'ereco-wp' ),
					'zoom-in'   => esc_html__( 'Zoom In', 'ereco-wp' ),
					'zoom-out'  => esc_html__( 'Zoom Out', 'ereco-wp' ),
					'drop-up'   => esc_html__( 'Drop Up', 'ereco-wp' ),
					'drop-left' => esc_html__( 'Drop Left', 'ereco-wp' ),
					'swing'     => esc_html__( 'Swing', 'ereco-wp' ),
					'flip'      => esc_html__( 'Flip', 'ereco-wp' ),
					'roll-in'   => esc_html__( 'Roll In', 'ereco-wp' ),
					'stretch'   => esc_html__( 'Stretch', 'ereco-wp' ),
				),
				'default'  => 'none',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

			
			array(
				'id'       => 'header-settings-navigation-skin',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Navigation Skin', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the skin of main menu you would like to use', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'default' => array(
						'alt' => 'default',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/default.jpg'
					),
					'bottom-trace' => array(
						'alt' => 'bottom-trace',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/bottom-trace.jpg'
					),
					'rounded-boxed' => array(
						'alt' => 'rounded-boxed',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/rounded-boxed.jpg'
					),
					'boxed' => array(
						'alt' => 'boxed',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/boxed.jpg'
					),
					'border-boxed' => array(
						'alt' => 'border-boxed',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-boxed.jpg'
					),
					'top-bottom-boxed-border' => array(
						'alt' => 'top-bottom-boxed-border',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/top-bottom-boxed-border.jpg'
					),
					'border-left' => array(
						'alt' => 'border-left',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-left.jpg'
					),
					'border-top' => array(
						'alt' => 'border-top',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-top.jpg'
					),
					'border-bottom' => array(
						'alt' => 'border-bottom',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-bottom.jpg'
					),
					'border-top-bottom' => array(
						'alt' => 'border-top-bottom',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-top-bottom.jpg'
					),
				),
				'default'  => 'default',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

			
		)
	) );


	// -> START Header Navigation Skin Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Nav Typography', 'ereco-wp' ),
		'id'     => 'header-header-navigation-skin-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(


			//Header Nav - Navigation Skin
			array(
				'id'        => 'header-settings-navigation-skin-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Navigation Skin', 'ereco-wp' ),
				'subtitle'  => esc_html__( 'Select the skin of main menu you would like to use', 'ereco-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'            => 'header-settings-navigation-item-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Main Nav Items Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-item-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Main Nav Items Hover/Active Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'            => 'header-settings-navigation-item-dropdown-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Main Nav Dropdown Items Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-item-dropdown-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Dropdown Items Hover/Active Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),


			array(
				'id'            => 'header-settings-navigation-skin-dropdown-menu-width',
				'type'          => 'slider',
				'title'         => esc_html__( 'Dropdown Menu Width(px)', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Enter width of dropdown menu in px.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 260,
				'min'           => 150,
				'step'          => 1,
				'max'           => 400,
				'display_value' => 'text',
			),


			
			array(
				'id'            => 'header-settings-navigation-item-megamenu-dropdown-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Main Nav Megamenu Items Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-item-megamenu-dropdown-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Megamenu Items Hover/Active Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'            => 'header-settings-navigation-item-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Main Nav Items Padding(px) Around it', 'ereco-wp' ),
			),
		)
	) );



	// -> START Header Vertical Nav
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Vertical Nav', 'ereco-wp' ),
		'id'     => 'header-vertical-nav-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-vertical-nav-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'ereco-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-vertical-nav-info-field-only-visible-vertical-nav',
				'type'      => 'info',
				'title'     => esc_html__( 'Important! Features Availability.', 'ereco-wp' ),
				'subtitle'  => esc_html__( 'Header Vertical Nav features are only available for "Header Layout Type - Vertical Nav"! So please choose it from Header Layout tab.', 'ereco-wp' ),
				'notice'    => false,
			),

			array(
				'id'       		=> 'header-settings-navigation-vertical-navbar-width',
				'type'          => 'slider',
				'title'    		=> esc_html__( 'Vertical Nav Bar Width', 'ereco-wp' ),
				'subtitle' 		=> esc_html__( 'Default: 300px', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 300,
				'min'           => 100,
				'step'          => 1,
				'max'           => 600,
				'display_value' => 'text',
			),
			array(
				'id'       		=> 'header-settings-navigation-vertical-nav-container-width',
				'type'          => 'slider',
				'title'    		=> esc_html__( 'Vertical Nav Main Content Container Width', 'ereco-wp' ),
				'subtitle' 		=> esc_html__( 'Default: 1100px', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 1300,
				'min'           => 500,
				'step'          => 1,
				'max'           => 1600,
				'display_value' => 'text',
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-bgimg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background for Vertical Nav', 'ereco-wp' ),
				'subtitle' => sprintf( esc_html__( 'Set background image for Header Layout Type %1$sVertical Nav%2$s.', 'ereco-wp' ), '<strong>', '</strong>'),
				'default'  => array(
					'background-repeat'     => 'no-repeat',
					'background-size'       => 'cover',
					'background-attachment' => '',
					'background-position'   => 'left top',
					'background-image'      => ERECO_MASCOT_ASSETS_URI . '/images/vertical-nav/bg1.png',
				),
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Vertical Nav Background Overlay', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image on Page Title.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
				'required' => array( 
					array( 'header-settings-navigation-vertical-nav-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'ereco-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'ereco-wp' ),
					'dark'          => esc_html__( 'Dark', 'ereco-wp' ),
					'white'         => esc_html__( 'White', 'ereco-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'ereco-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'ereco-wp' ),
					'theme-colored3' => esc_html__( 'Primary Theme Color3', 'ereco-wp' ),
					'theme-colored4' => esc_html__( 'Primary Theme Color4', 'ereco-wp' )
				),
				'default' => 'white',
				'required' => array( 
					array( 'header-settings-navigation-vertical-nav-layer-overlay-status', '=', '1' )
				)
			),
			

			array(
				'id'       => 'header-settings-navigation-vertical-nav-shadow',
				'type'     => 'switch',
				'title'    => esc_html__( 'Shadow?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make shadow around the vertical nav area.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

			array(
				'id'       => 'header-settings-navigation-vertical-nav-border',
				'type'     => 'switch',
				'title'    => esc_html__( 'Vertical Area Border', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make Border around the vertical nav area.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

			array(
				'id'       => 'header-settings-navigation-vertical-nav-center-content',
				'type'     => 'switch',
				'title'    => esc_html__( 'Center Content', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Center the content of vertical nav area.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),



			array(
				'id'        => 'header-settings-navigation-vertical-nav-field-widget-typography',
				'type'      => 'info',
				'title'     => esc_html__( 'Widget Typography', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'            => 'header-settings-navigation-vertical-nav-widget-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Title Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'            => 'header-settings-navigation-vertical-nav-widget-text-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Text Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'            => 'header-settings-navigation-vertical-nav-widget-link-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Link Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-widget-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Widget Link Hover/Active Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),

		)
	) );



	// -> START Header Menu Megamenu
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Megamenu', 'ereco-wp' ),
		'id'     => 'header-menu-megamenu',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-menu',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'header-menu-megamenu-enable-megamenu',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Mega Menu', 'ereco-wp' ),
				'subtitle' => sprintf( esc_html__( 'Turn on to enable mega menu. After enabling mega menu, you will get a lot of options for mega menu at %1$sAppearance > Menus%2$s', 'ereco-wp' ), '<strong>', '</strong>'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
		)
	) );




	// -> START Page Title Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Page Title', 'ereco-wp' ),
		'id'     => 'page-title-settings',
		'desc'   => esc_html__( 'Enable/Disable Page Title Area for posts and pages.', 'ereco-wp' ),
		'icon'   => 'dashicons-before dashicons-archive',
		'fields' => array(
			array(
				'id'       => 'page-title-settings-enable-page-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Page Title', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-title-settings-choose-page-title-cpt-widget-area',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Page Title (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('It will be shown at the top of the page under header. You can create your own one from <a href="%s" target="_blank">Dashboard > Parts - Page Title</a>', 'ereco-wp'), admin_url('edit.php?post_type=page-title')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'page-title' ),
				),
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-enable-default-page-title-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Or Enable Default Page Title', 'ereco-wp' ),
				'indent'   => true,
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-enable-default-page-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Default Page Title', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Page Title Layout', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'standard' => array(
						'alt' => 'standard',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/footer/f11.jpg'
					),
					'split' => array(
						'alt' => 'split',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/footer/f7.jpg'
					),
				),
				'default'  => 'standard',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-container',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Title Area Container', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Put Page Title content into boxed or stretched fullwidth.', 'ereco-wp' ),
				'options'	=> array(
					'container' => esc_html__( 'Container', 'ereco-wp' ),
					'container-fluid' => esc_html__( 'Container Fluid', 'ereco-wp' )
				),
				'default' => 'container',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-enable-custom-padding-top-bottom',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Custom Padding Top & Bottom into Page Title Area', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'             => 'page-title-settings-container-padding-top-bottom',
				'type'           => 'spacing',
				'mode'           => 'padding',
				'all'            => false,
				// Have one field that applies to all
				'top'            => true,     // Disable the top
				'right'          => false,     // Disable the right
				'bottom'         => true,     // Disable the bottom
				'left'           => false,     // Disable the left
				'units'          => 'px',
				'units_extended' => 'true',
				'display_units'  => true,   // Set to false to hide the units if the units are specified
				'title'          => esc_html__( 'Padding Top & Bottom(px)', 'ereco-wp' ),
				'subtitle'       => esc_html__( 'Top and bottom padding in px of page title container.', 'ereco-wp' ),
				'desc'           => esc_html__( 'Controls the top and bottom padding of page title. Ex: 80px, 80px. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'ereco-wp' ),
				'default'            => array(
					'padding-top'     => '80', 
					'padding-bottom'  => '80', 
					'units'          => 'px', 
				),
				'required' => array( 'page-title-settings-enable-custom-padding-top-bottom', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-show-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Title', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable title on Page Title Area. It is possible to disable them individually using page meta settings.', 'ereco-wp' ),
				'default'  => true,
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-show-subtitle',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Subtitle', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable Sub title on Page Title Area. It is possible to disable them individually using page meta settings.', 'ereco-wp' ),
				'default'  => true,
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-show-breadcrumbs',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Breadcrumbs', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable breadcrumbs on Page Title. It is possible to disable them individually using page meta settings.', 'ereco-wp' ),
				'default'  => true,
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-height',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Area Height', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'select2' => array( array( 'minimumResultsForSearch' => 'Infinity' ) ),
				'options'	=> array(
					'padding-default'       => esc_html__( 'Default', 'ereco-wp' ),
					'padding-extra-small'   => esc_html__( 'Extra Small', 'ereco-wp' ),
					'padding-small'         => esc_html__( 'Small', 'ereco-wp' ),
					'padding-medium'        => esc_html__( 'Medium', 'ereco-wp' ),
					'padding-large'         => esc_html__( 'Large', 'ereco-wp' ),
					'padding-extra-large'   => esc_html__( 'Extra Large', 'ereco-wp' ),
				),
				'default'  => 'padding-large',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-text-color',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Default Text Color', 'ereco-wp' ),
				'desc'     => '',
				'subtitle' => esc_html__( 'Select default text color. Inverted will turn font color to black. Inverted is suitable for white background.', 'ereco-wp' ),
				'options'	=> array(
					'text-default'   => esc_html__( 'Default (Text White)', 'ereco-wp' ),
					'text-inverted'  => esc_html__( 'Inverted (Text Black)', 'ereco-wp' )
				),
				'default' => 'text-default',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Text Alignment', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Text Alignment of Page Title', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> ereco_mascot_redux_text_alignment_list(),
				'default'  => 'text-center',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-top-border-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Title Area Top Border Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-bottom-border-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Title Area Bottom Border Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),


			//Page Title background
			array(
				'id'       => 'page-title-settings-bg-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Page Title Background', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg',
				'type'     => 'background',
				'title'    => esc_html__( 'Page Title Background', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose background image or color.', 'ereco-wp' ),
				'default'  => array(
					'background-repeat'     => 'no-repeat',
					'background-size'       => 'cover',
					'background-attachment' => '',
					'background-position'   => 'center center',
					'background-image'      => ERECO_MASCOT_ASSETS_URI . '/images/bg/bg1.jpg',
				),
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Page Title Background Overlay', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image on Page Title.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'ereco-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'ereco-wp' ),
					'dark'          => esc_html__( 'Dark', 'ereco-wp' ),
					'white'         => esc_html__( 'White', 'ereco-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'ereco-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'ereco-wp' ),
					'theme-colored3' => esc_html__( 'Primary Theme Color3', 'ereco-wp' ),
					'theme-colored4' => esc_html__( 'Primary Theme Color4', 'ereco-wp' )
				),
				'default' => 'dark',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-layer-overlay-status', '=', '1' )
				)
			),

			//background video
			array(
				'id'       => 'page-title-settings-bg-video-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Background Video', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-type',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Video Type', 'ereco-wp' ),
				'subtitle' => '',
				'options' => array(
					'youtube' => esc_html__( 'Youtube', 'ereco-wp' ),
					'self-hosted' => esc_html__( 'Self Hosted Video', 'ereco-wp' )
				),
				'default' => 'youtube',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-youtube-id',
				'type'     => 'text',
				'title'    => esc_html__( 'Youtube Video ID', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Only put video ID not the whole URL.', 'ereco-wp' ),
				'desc'     => '',
				'placeholder'    => esc_html__( 'Example: E5ln4uR4TwQ', 'ereco-wp' ),
				'default' => '',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'youtube' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-video-poster',
				'type'     => 'media',
				'title'    => esc_html__( 'Video Poster', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-mp4-video-url',
				'type'     => 'media',
				'title'    => esc_html__( 'MP4 Video URL', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => 'mp4', // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-webm-video-url',
				'type'     => 'media',
				'title'    => esc_html__( 'WEBM Video URL', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => 'webm', // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-ogv-video-url',
				'type'     => 'media',
				'title'    => esc_html__( 'OGV Video URL', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => 'false', // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' ),
				)
			),



			//animation
			array(
				'id'       => 'page-title-settings-title-animation-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Animation Effect', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-title-animation-effect',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Animation Effect', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_animate_css_animation_list(),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-animation-duration',
				'type'     => 'text',
				'title'    => esc_html__( 'Title Animation Duration', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Change the animation duration. Example: 1500ms or 1.5s or 0.5s etc. Default 0.5s.', 'ereco-wp' ),
				'placeholder' => esc_html__( '1.5s', 'ereco-wp' ),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-subtitle-animation-effect',
				'type'     => 'select',
				'title'    => esc_html__( 'Sub Title Animation Effect', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_animate_css_animation_list(),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-subtitle-animation-duration',
				'type'     => 'text',
				'title'    => esc_html__( 'Sub Title Animation Duration', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Change the animation duration. Example: 1500ms or 1.5s or 0.5s etc. Default 0.5s.', 'ereco-wp' ),
				'placeholder' => esc_html__( '1.5s', 'ereco-wp' ),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-animation-ends',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-default-page-title', '=', '1' )
				)
			),



			//section Typography Starts
			array(
				'id'       => 'page-title-settings-title-typography-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for Title.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 'page-title-settings-enable-default-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose title element tag', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> ereco_mascot_heading_tag_list_all(),
				'default'  => 'h1',
			),
			array(
				'id'            => 'page-title-settings-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Title Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'page-title-settings-title-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Title Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => 'page-title-settings-subtitle-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Subtitle Tag', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose subtitle element tag', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> ereco_mascot_heading_tag_list_all(),
				'default'  => 'h6',
			),
			array(
				'id'            => 'page-title-settings-subtitle-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Sub Title Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'page-title-settings-subtitle-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Sub Title Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'            => 'page-title-settings-breadcrumbs-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Breadcrumbs Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'page-title-settings-breadcrumbs-last-child-text-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Breadcrumbs Last Child Text Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'page-title-settings-breadcrumbs-seperator-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Breadcrumbs Seperator Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'page-title-settings-breadcrumbs-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Breadcrumbs Link Hover/Active Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'page-title-settings-title-typography-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START Footer
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Footer', 'ereco-wp' ),
		'id'     => 'footer',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-down-alt',
	) );

	// -> START Footer Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Footer Settings', 'ereco-wp' ),
		'id'     => 'footer-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-down-alt2',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'footer-settings-footer-visibility',
				'type'     => 'switch',
				'title'    => esc_html__( 'Footer Visibility', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Show or hide footer globally', 'ereco-wp' ),
				'default'  => 1,
				'on'       => 'Show',
				'off'      => 'Hide',
			),
			array(
				'id'       => 'footer-settings-choose-footer-widget-area',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Footer (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('You can create your own footer from <a href="%s" target="_blank">Dashboard > Parts - Footer</a>', 'ereco-wp'), admin_url('edit.php?post_type=footer')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'footer' ),
				),
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-fixed-footer-bottom',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fixed Footer Bottom Effect', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will make Footer gradually appear on scroll. This is popular for OnePage Websites.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-footer-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Footer Background Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of Footer.', 'ereco-wp' ),
				'transparent' => false,
			),





			array(
				'id'        => 'footer-settings-footer-top-typography',
				'type'      => 'info',
				'title'     => esc_html__( 'Typography', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'            => 'footer-settings-footer-top-widget-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Title Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),

			
			array(
				'id'       => 'footer-settings-footer-widget-title-show-line-bottom',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Line Bottom Under Widget Title', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you enable it then a thin line will be visible below the widget title.', 'ereco-wp' ),
				'desc'     => '',
				'default'  => '0',
			),
			array(
				'id'       => 'footer-settings-footer-widget-title-line-bottom-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Line Bottom Theme Colored?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'To make the Line Bottom theme colored, please check it.', 'ereco-wp' ),
				'desc'     => '',
				'options'  => ereco_mascot_theme_color_list(),
				'default'  => '1',
				'required' => array( 'footer-settings-footer-widget-title-show-line-bottom', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-footer-widget-title-line-bottom-custom-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Line Bottom Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'footer-settings-footer-widget-title-line-bottom-theme-colored', '=', '' ),
			),


			array(
				'id'            => 'footer-settings-footer-top-widget-text-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Text Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'            => 'footer-settings-footer-top-widget-link-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Link Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-footer-top-widget-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Widget Link Hover/Active Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			
		)
	) );



	// -> START Side Push Panel Sidebar
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Side Push Panel Sidebar', 'ereco-wp' ),
		'id'     => 'header-side-push-panel-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-menu-alt2',
		'fields' => array(


			array(
				'id'       => 'header-settings-choose-side-push-panel-cpt-widget-area',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Pre Made Side Push Panel Area (Built with Elementor)', 'ereco-wp' ),
				'subtitle' => sprintf(__('You can create your own one from <a href="%s" target="_blank">Dashboard > Parts - Side Push Panel</a>', 'ereco-wp'), admin_url('edit.php?post_type=side-push-panel')),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'side-push-panel' ),
				),
			),

			array(
				'id'       		=> 'header-settings-navigation-side-push-panel-width',
				'type'          => 'slider',
				'title'    		=> esc_html__( 'Side Push Panel Width', 'ereco-wp' ),
				'subtitle' 		=> esc_html__( 'Default: 380px', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 380,
				'min'           => 100,
				'step'          => 1,
				'max'           => 1000,
				'display_value' => 'text',
			),
			array(
				'id'       => 'header-settings-navigation-side-push-panel-bgimg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background of Side Push Panel', 'ereco-wp' ),
				'default'  => array(
					'background-repeat'     => 'no-repeat',
					'background-size'       => 'cover',
					'background-attachment' => '',
					'background-position'   => 'left bottom',
					'background-image'      => '',
				),
			),

			array(
				'id'       => 'header-settings-navigation-side-push-panel-center-content',
				'type'     => 'switch',
				'title'    => esc_html__( 'Center Content', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Center the content of Side Push Panel area.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

			array(
				'id'       => 'header-settings-navigation-side-push-panel-widget-title-show-line-bottom',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Line Bottom Under Widget Title', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you enable it then a thin line will be visible below the widget title.', 'ereco-wp' ),
				'desc'     => '',
				'default'  => '0',
			),
			array(
				'id'       => 'header-settings-navigation-side-push-panel-widget-title-line-bottom-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Line Bottom Theme Colored?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'To make the Line Bottom theme colored, please check it.', 'ereco-wp' ),
				'desc'     => '',
				'options'  => ereco_mascot_theme_color_list(),
				'default'  => '1',
				'required' => array( 'header-settings-navigation-side-push-panel-widget-title-show-line-bottom', '=', '1' ),
			),


			array(
				'id'       => 'header-settings-navigation-side-push-panel-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Background Overlay', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'header-settings-navigation-side-push-panel-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
				'required' => array( 
					array( 'header-settings-navigation-side-push-panel-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-side-push-panel-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'ereco-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'ereco-wp' ),
					'dark'          => esc_html__( 'Dark', 'ereco-wp' ),
					'white'         => esc_html__( 'White', 'ereco-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'ereco-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'ereco-wp' ),
					'theme-colored3' => esc_html__( 'Primary Theme Color3', 'ereco-wp' ),
					'theme-colored4' => esc_html__( 'Primary Theme Color4', 'ereco-wp' )
				),
				'default' => 'white',
			),


			
		)
	) );



	// -> START Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Typography', 'ereco-wp' ),
		'id'     => 'typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
	) );

	// -> START Body Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Body Typography', 'ereco-wp' ),
		'id'     => 'primary-body-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			array(
				'id'            => 'typography-primary-body',
				'type'          => 'typography',
				'title'         => esc_html__( 'Primary Body Font', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Specify the body font properties.', 'ereco-wp' ),
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'            => 'typography-primary-body-link-color',
				'type'          => 'color',
				'title'         => esc_html__( 'Primary Link Color', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Specify link color throughout the body.', 'ereco-wp' ),
				'transparent'   => false,
			),
		)
		
	) );

	// -> START Headings Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Headings Typography', 'ereco-wp' ),
		'id'     => 'headings-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			//section H1 Starts
			array(
				'id'       => 'typography-h1-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H1', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H1.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h1',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h1-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h1-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H2 Starts
			array(
				'id'       => 'typography-h2-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H2', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H2.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h2',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h2-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h2-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H3 Starts
			array(
				'id'       => 'typography-h3-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H3', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H3.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h3',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h3-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h3-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H4 Starts
			array(
				'id'       => 'typography-h4-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H4', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H4.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h4',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h4-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h4-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H5 Starts
			array(
				'id'       => 'typography-h5-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H5', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H5.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h5',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h5-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h5-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H6 Starts
			array(
				'id'       => 'typography-h6-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H6', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H6.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h6',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h6-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h6-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),



		)
	) );

	// -> START Button Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Button Typography', 'ereco-wp' ),
		'id'     => 'primary-button-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			array(
				'id'            => 'button-typography-btn-default',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Default', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-default-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Default', 'ereco-wp' ),
			),
			array(
				'id'            => 'button-typography-btn-lg',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Large', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-lg-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Large', 'ereco-wp' ),
			),
			array(
				'id'            => 'button-typography-btn-sm',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Small', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-sm-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Small', 'ereco-wp' ),
			),
			array(
				'id'            => 'button-typography-btn-xs',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Extra Small', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-xs-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Extra Small', 'ereco-wp' ),
			),
		)
		
	) );

	// -> START Link Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Post/Page Content Link Typography', 'ereco-wp' ),
		'id'     => 'content-link-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			array(
				'id'            => 'link-typography-link',
				'type'          => 'typography',
				'title'         => esc_html__( 'Link Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'	   => 'link-typography-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Link Hover Color', 'ereco-wp' ),
				'transparent' => false,
			),
		)
	) );



	// -> START Page Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Page', 'ereco-wp' ),
		'id'     => 'page-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-media-default',
		'fields' => array(
			array(
				'id'       => 'page-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Sidebar Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for pages', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'ereco-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'ereco-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'ereco-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'ereco-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'ereco-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'ereco-wp' ),

				),
				'default'  => 'no-sidebar',
			),
			array(
				'id'       => 'page-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on pages.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar',
				'required' => array( 'page-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'page-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Sidebar 2', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar-two',
				'required' => array( 'page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'page-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Page Sidebar 2 - Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'ereco-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'ereco-wp' ),
					'right'     => esc_html__( 'Right', 'ereco-wp' )
				),
				'default'  => 'right',
				'required' => array( 'page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'page-settings-show-comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Page Comments', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable comments on all pages except the post pages. It is possible to disable them individually using page meta settings.', 'ereco-wp' ),
				'default'  => true,
			),
			array(
				'id'       => 'page-settings-show-share',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Share', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide share options on your page.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
		)
	) );



	// -> START Preloader Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Preloader', 'ereco-wp' ),
		'id'     => 'preloader-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-clock',
		'fields' => array(
			array(
				'id'       => 'general-settings-enable-page-preloader-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Page Preloader Settings', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable Page Preloader.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'general-settings-enable-page-preloader',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Page Preloader', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will show page preloader.', 'ereco-wp' ),
				'default'  => false,
			),
			array(
				'id'        => 'general-settings-page-preloader-type',
				'type'      => 'button_set',
				'compiler'  => true,
				'title'     => esc_html__( 'Page Preloader Type', 'ereco-wp' ),
				'subtitle'  => esc_html__( 'Select preloader type', 'ereco-wp' ),
				'options'   => array(
					'css-preloader'    => esc_html__( 'CSS Preloader', 'ereco-wp' ),
					'gif-preloader'    => esc_html__( 'Gif Icon Preloader', 'ereco-wp' )
				),
				'default'   => 'css-preloader',
				'required' => array( 'general-settings-enable-page-preloader', '=', '1' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-type-css',
				'type'     => 'select',
				'title'    => esc_html__( 'CSS Preloader', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose Predefined CSS Preloader.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'preloader-bubblingG'           => esc_html__( 'Bubbling', 'ereco-wp' ),
					'preloader-circle-loading-wrapper' => esc_html__( 'Circle Loading', 'ereco-wp' ),
					'preloader-coffee'              => esc_html__( 'Coffee', 'ereco-wp' ),
					'preloader-battery'             => esc_html__( 'Battery', 'ereco-wp' ),
					'preloader-dot-circle-rotator'  => esc_html__( 'Dot Circle Rotator', 'ereco-wp' ),
					'preloader-dot-loading'         => esc_html__( 'Dot Loading', 'ereco-wp' ),
					'preloader-double-torus'        => esc_html__( 'Double Torus', 'ereco-wp' ),
					'preloader-equalizer'           => esc_html__( 'Equalizer', 'ereco-wp' ),
					'preloader-floating-circles'    => esc_html__( 'Floating Circles', 'ereco-wp' ),
					'preloader-fountainTextG'       => esc_html__( 'Fountain Text', 'ereco-wp' ),
					'preloader-jackhammer'          => esc_html__( 'Jackhammer', 'ereco-wp' ),
					'preloader-loading-wrapper'     => esc_html__( 'Loading', 'ereco-wp' ),
					'preloader-orbit-loading'       => esc_html__( 'Orbit Loading', 'ereco-wp' ),
					'preloader-speeding-wheel'      => esc_html__( 'Speeding Wheel', 'ereco-wp' ),
					'preloader-square-swapping'     => esc_html__( 'Square Swapping', 'ereco-wp' ),
					'preloader-tube-tunnel'         => esc_html__( 'Tube Tunnel', 'ereco-wp' ),
					'preloader-whirlpool'           => esc_html__( 'Whirlpool', 'ereco-wp' ),
				),
				'default'  => 'preloader-dot-loading',
				'required' => array( 'general-settings-page-preloader-type', '=', 'css-preloader' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-type-gif',
				'type'     => 'select',
				'title'    => esc_html__( 'Gif Icon Preloader', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose Predefined Gif Icon Preloader.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/1.gif'  =>  'preloader-1',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/2.gif'  =>  'preloader-2',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/3.gif'  =>  'preloader-3',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/4.gif'  =>  'preloader-4',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/5.gif'  =>  'preloader-5',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/6.gif'  =>  'preloader-6',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/7.gif'  =>  'preloader-7',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/8.gif'  =>  'preloader-8',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/9.gif'  =>  'preloader-9',
					ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/10.gif' =>  'preloader-10',
				),
				'default'  => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/1.gif',
				'required' => array( 'general-settings-page-preloader-type', '=', 'gif-preloader' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-show-disable-button',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Disable Preloader Button', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Show Disable Preloader Button at the corner of the screen.', 'ereco-wp' ),
				'desc'     => '',
				'default'  => '1',
				'required' => array( 'general-settings-enable-page-preloader', '=', '1' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-show-disable-button-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Disable Preloader Button Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared into the Disable Preloader Button.', 'ereco-wp' ),
				'desc'     => '',
				'default'    => esc_html__( 'Disable Preloader', 'ereco-wp' ),
				'required' => array( 'general-settings-page-preloader-show-disable-button', '=', '1' ),
			),
			array(
				'id'       => 'general-settings-enable-page-preloader-ends',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );




	// -> START Blog Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Blog', 'ereco-wp' ),
		'id'     => 'blog-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-media-document',
	) );



	// -> START Blog Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Blog Archive Page', 'ereco-wp' ),
		'id'     => 'blog-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'blog-settings-archive-page-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Blog Post Layout for Archive Pages', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a default layout for archive pages', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'standard-1-col' => 'Standard 1 Column Default',
					'standard-1-col-classic' => 'Standard 1 Column Classic',
					'standard-2-col' => 'Standard 2 Columns',
					'standard-3-col' => 'Standard 3 Columns',
					'standard-4-col' => 'Standard 4 Columns',
					'masonry-2-col'  => 'Masonry 2 Columns',
					'masonry-3-col'  => 'Masonry 3 Columns',
					'masonry-4-col'  => 'Masonry 4 Columns',
				),
				'default'  => 'masonry-3-col',
			),
			array(
				'id'       => 'blog-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for pages', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'ereco-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'ereco-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'ereco-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'ereco-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'ereco-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'ereco-wp' ),
				),
				'default'  => 'no-sidebar',
			),


			array(
				'id'       => 'blog-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on blog archive pages.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'default-sidebar',
				'required' => array( 'blog-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'blog-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Sidebar 2', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on blog archive pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'blog-secondary-sidebar',
				'required' => array( 'blog-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'blog-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Blog Sidebar 2 - Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'ereco-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'ereco-wp' ),
					'right'     => esc_html__( 'Right', 'ereco-wp' )
				),
				'default'  => 'right',
				'required' => array( 'blog-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),


			array(
				'id'       => 'blog-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fullwidth?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make the page fullwidth or not.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'            => 'blog-settings-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 22,
				'min'           => 0,
				'step'          => 1,
				'max'           => 500,
				'display_value' => 'text',
			),
			array(
				'id'       => 'blog-settings-show-post-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Featured Image in blog page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-settings-post-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Featured image size in blog page.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'ereco_mascot_featured_image',
				'required' => array( 'blog-settings-show-post-featured-image', '=', '1' ),
			),
			array(
				'id'       => 'blog-settings-post-meta',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Post Meta', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide each Post Meta on your page.', 'ereco-wp' ),
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-post-by-author'       => esc_html__( 'Show By Author', 'ereco-wp' ),
					'show-post-date'            => esc_html__( 'Show Date', 'ereco-wp' ),
					'show-post-date-split'      => esc_html__( 'Show Date Split', 'ereco-wp' ),
					'show-post-category'        => esc_html__( 'Show Category', 'ereco-wp' ),
					'show-post-comments-count'  => esc_html__( 'Show Comments Count', 'ereco-wp' ),
					'show-post-tag'             => esc_html__( 'Show Tag', 'ereco-wp' ),
					'show-post-like-button'     => esc_html__( 'Show Like Button', 'ereco-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-post-by-author' => '1',
					'show-post-date' => '1',
					'show-post-date-split' => '0',
					'show-post-category' => '1',
					'show-post-comments-count' => '0',
					'show-post-tag' => '0',
					'show-post-like-button' => '0'
				)
			),
			array(
				'id'       => 'blog-settings-show-pagination',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Pagination', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will show comments on your page.', 'ereco-wp' ),
				'default'  => true,
			),
		)
	) );



	// -> START Single Post Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Single Post', 'ereco-wp' ),
		'id'     => 'blog-single-post-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'blog-single-post-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fullwidth?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make the page fullwidth or not.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for pages', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'ereco-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'ereco-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'ereco-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'ereco-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'ereco-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'ereco-wp' ),
				),
				'default'  => 'sidebar-right-33',
			),



			array(
				'id'       => 'blog-single-post-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on blog single pages.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'default-sidebar',
				'required' => array( 'blog-single-post-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'blog-single-post-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar 2', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on blog single pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'blog-secondary-sidebar',
				'required' => array( 'blog-single-post-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'blog-single-post-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar 2 - Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'ereco-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'ereco-wp' ),
					'right'     => esc_html__( 'Right', 'ereco-wp' )
				),
				'default'  => 'right',
				'required' => array( 'blog-single-post-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),


			
			array(
				'id'       => 'blog-single-post-settings-show-post-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Featured Image in blog page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'            => 'blog-single-post-settings-featured-image-height',
				'type'          => 'slider',
				'title'         => esc_html__( 'Featured Image Height(px)', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Set height for featured image displayed on your blog single page.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 600,
				'min'           => 0,
				'step'          => 1,
				'max'           => 1200,
				'display_value' => 'text',
			),
			array(
				'id'       => 'blog-single-post-settings-enable-drop-caps',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Drop Caps', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling Drop Caps for the first letter of post content.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-post-meta',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Post Meta', 'ereco-wp' ),
				'subtitle'     => esc_html__( 'Enable/Disabling this option will show/hide each Post Meta on your page.', 'ereco-wp' ),
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-post-by-author'       => esc_html__( 'Show By Author', 'ereco-wp' ),
					'show-post-date'            => esc_html__( 'Show Date', 'ereco-wp' ),
					'show-post-date-split'      => esc_html__( 'Show Date Split', 'ereco-wp' ),
					'show-post-category'        => esc_html__( 'Show Category', 'ereco-wp' ),
					'show-post-comments-count'  => esc_html__( 'Show Comments Count', 'ereco-wp' ),
					'show-post-like-button'     => esc_html__( 'Show Like Button', 'ereco-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-post-by-author' => '1',
					'show-post-date' => '1',
					'show-post-date-split' => '0',
					'show-post-category' => '1',
					'show-post-comments-count' => '1',
					'show-post-like-button' => '0'
				)
			),
			array(
				'id'       => 'blog-single-post-settings-show-tags',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Tags', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide tags on your page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-share',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Share', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide share options on your page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),


			//section Next/Previous Navigation Link Starts
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Next/Previous Navigation Link', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Next/Previous Single Post Navigation Link', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link for Next & Previous Posts.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link-within-same-cat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Navigation Link Within Same Category', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link to the next/previous post within the same category as the current post.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'blog-single-post-settings-show-next-pre-post-link', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section Author Info Box
			array(
				'id'       => 'blog-single-post-settings-author-info-box-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Author Info Box', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Author Info Box', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Author Info Box on your page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box-show-social-icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Icons', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'blog-single-post-settings-author-info-box', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box-show-author-email',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Author Email', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'blog-single-post-settings-author-info-box', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),




			//section Related Posts Starts
			array(
				'id'       => 'blog-single-post-settings-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Related Posts', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Posts List/Carousel on your page.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-show-related-posts',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Posts', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-related-posts-carousel',
				'type'     => 'switch',
				'title'    => esc_html__( 'Carousel?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make it carousel or grid', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'blog-single-post-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-related-posts-count',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Posts', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Enter number of posts to display. Default 3', 'ereco-wp' ),
				'default'  => '3',
				'required' => array( 'blog-single-post-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-related-posts-show-excerpt',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Excerpt', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'blog-single-post-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'            => 'blog-single-post-settings-show-related-posts-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 20,
				'min'           => 0,
				'step'          => 1,
				'max'           => 200,
				'display_value' => 'text',
				'required' => array( 'blog-single-post-settings-show-related-posts-excerpt', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-related-posts-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),



			//section Show Comments Starts
			array(
				'id'       => 'blog-single-post-settings-comments-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Comments', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Comments on your page.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-show-comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Comments', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-comments-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),

		)
	) );



	// -> START Single Post Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Other Settings', 'ereco-wp' ),
		'id'     => 'blog-other-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'blog-other-settings-show-blog-title-description',
				'type'     => 'switch',
				'title'    => esc_html__( 'Custom Blog Title & Description', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Add title and description in title section of blog page', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'blog-other-settings-blog-title-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Blog Title Text', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'News', 'ereco-wp' ),
				'required' => array( 'blog-other-settings-show-blog-title-description', '=', '1' ),
			),
			array(
				'id'       => 'blog-other-settings-blog-description-text',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Blog Description Text', 'ereco-wp' ),
				'desc'     => '',
				'default'  => '',
				'required' => array( 'blog-other-settings-show-blog-title-description', '=', '1' ),
			)
		)
	) );



	// -> START Portfolio Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio', 'ereco-wp' ),
		'id'     => 'portfolio-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-format-gallery',
	) );



	// -> START Portfolio Layout Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio Archive Layout', 'ereco-wp' ),
		'id'     => 'portfolio-layout-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'portfolio-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Sidebar Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for portfolio pages', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'ereco-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'ereco-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'ereco-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'ereco-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'ereco-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'ereco-wp' ),

				),
				'default'  => 'no-sidebar',
			),
			array(
				'id'       => 'portfolio-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on portfolio pages.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar',
				'required' => array( 'portfolio-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'portfolio-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Sidebar 2', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on portfolio pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar-two',
				'required' => array( 'portfolio-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'portfolio-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Portfolio Sidebar 2 - Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'ereco-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'ereco-wp' ),
					'right'     => esc_html__( 'Right', 'ereco-wp' )
				),
				'default'  => 'right',
				'required' => array( 'portfolio-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),




			array(
				'id'       => 'portfolio-layout-settings-select-portfolio-design-style',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Portfolio Design Style', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the type of portfolio you would like to display.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'portfolio-style2-simple' => array(
						'alt' => 'Default',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/default.png'
					),
				),
				'default'  => 'portfolio-style2-simple'
			),

			array(
				'id'       => 'portfolio-layout-settings-select-portfolio-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Portfolio Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),


			array(
				'id'       => 'portfolio-layout-settings-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Portfolio Items Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your portfolio items.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '3',
			),
			array(
				'id'            => 'portfolio-layout-settings-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Portfolio Items Per Page', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on portfolio archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 10,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'portfolio-layout-settings-gutter-size',
				'type'     => 'select',
				'title'         => esc_html__( 'Portfolio Column Spacing (Gutter Size) px', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on portfolio archive pages.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> ereco_mascot_isotope_gutter_list_redux(),
				'default'  => 'gutter-15',
			),
			array(
				'id'       => 'portfolio-layout-settings-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Featured image size in Portfolio Archive page.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'ereco_mascot_square',
			),
			array(
				'id'       => 'portfolio-layout-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Fullwidth?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make the portfolio page fullwidth or not.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
		)
	) );



	// -> START Portfolio Single Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio Single', 'ereco-wp' ),
		'id'     => 'portfolio-single-page-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'portfolio-single-page-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fullwidth?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make the page fullwidth or not.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for portfolio details pages', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'ereco-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'ereco-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'ereco-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'ereco-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'ereco-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'ereco-wp' ),
				),
				'default'  => 'no-sidebar',
			),



			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on portfolio single pages.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar',
				'required' => array( 'portfolio-single-page-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar 2', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on portfolio single pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar-two',
				'required' => array( 'portfolio-single-page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar 2 - Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'ereco-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'ereco-wp' ),
					'right'     => esc_html__( 'Right', 'ereco-wp' )
				),
				'default'  => 'right',
				'required' => array( 'portfolio-single-page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),


			array(
				'id'       => 'portfolio-single-page-settings-select-portfolio-details-type',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Portfolio Details Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the type of portfolio details you would like to display.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'small-image' => array(
						'alt' => esc_html__( 'Small Image', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/small-image.png'
					),
					'small-image-slider' => array(
						'alt' => esc_html__( 'Small Image Slider', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/small-image-slider.png'
					),
					'small-image-gallery' => array(
						'alt' => esc_html__( 'Small Image Gallery', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/small-image-gallery.png'
					),
					'big-image' => array(
						'alt' => esc_html__( 'Big Image', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/big-image.png'
					),
					'big-image-slider' => array(
						'alt' => esc_html__( 'Big Image Slider', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/big-image-slider.png'
					),
					'big-image-gallery' => array(
						'alt' => esc_html__( 'Big Image Gallery', 'ereco-wp' ),
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/big-image-gallery.png'
					),
				),
				'default'  => 'small-image'
			),


			//Small Image
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Small Image Settings', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-description-placement',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Placement', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose placement of item description.', 'ereco-wp' ),
				'options'	=> array(
					'left'   => esc_html__( 'Left Side', 'ereco-wp' ),
					'right'  => esc_html__( 'Right Side', 'ereco-wp' )
				),
				'default' => 'left',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-description-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Width', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose width of item description.', 'ereco-wp' ),
				'options'	=> array(
					'6'     => esc_html__( 'Half (1/2)', 'ereco-wp' ),
					'4'     => esc_html__( 'One Third (1/3)', 'ereco-wp' ),
					'3'     => esc_html__( 'One Fourth (1/4)', 'ereco-wp' )
				),
				'default' => '6',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-description-sticky',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Description Sticky', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make description container sticky when scrolling down the page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' )
				)
			),




			//Small Image Slider
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Small Image Slider Settings', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-placement',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Placement', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose placement of item description.', 'ereco-wp' ),
				'options'	=> array(
					'left'   => esc_html__( 'Left Side', 'ereco-wp' ),
					'right'  => esc_html__( 'Right Side', 'ereco-wp' )
				),
				'default' => 'left',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Width', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose width of item description.', 'ereco-wp' ),
				'options'	=> array(
					'6'     => esc_html__( 'Half (1/2)', 'ereco-wp' ),
					'4'     => esc_html__( 'One Third (1/3)', 'ereco-wp' ),
					'3'     => esc_html__( 'One Fourth (1/4)', 'ereco-wp' )
				),
				'default' => '6',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-sticky',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Description Sticky', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make description container sticky when scrolling down the page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' )
				)
			),




			//Small Image Gallery
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Small Image Gallery Settings', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-description-placement',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Placement', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose placement of item description.', 'ereco-wp' ),
				'options'	=> array(
					'left'   => esc_html__( 'Left Side', 'ereco-wp' ),
					'right'  => esc_html__( 'Right Side', 'ereco-wp' )
				),
				'default' => 'left',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-description-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Width', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose width of item description.', 'ereco-wp' ),
				'options'	=> array(
					'6'     => esc_html__( 'Half (1/2)', 'ereco-wp' ),
					'4'     => esc_html__( 'One Third (1/3)', 'ereco-wp' ),
					'3'     => esc_html__( 'One Fourth (1/4)', 'ereco-wp' )
				),
				'default' => '6',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-description-sticky',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Description Sticky', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make description container sticky when scrolling down the page.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'       => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Gallery Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-isotope-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Images Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your gallery items.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '3',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),




			//Big Image
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Big Image Settings', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-description-placement',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Placement', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose placement of item description.', 'ereco-wp' ),
				'options'	=> array(
					'over'   => esc_html__( 'Over the Images', 'ereco-wp' ),
					'under'  => esc_html__( 'Under the Images', 'ereco-wp' )
				),
				'default' => 'over',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image' )
				)
			),




			//Big Image Slider
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-slider-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Big Image Slider Settings', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-slider' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-slider-description-placement',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Placement', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose placement of item description.', 'ereco-wp' ),
				'options'	=> array(
					'over'   => esc_html__( 'Over the Images', 'ereco-wp' ),
					'under'  => esc_html__( 'Under the Images', 'ereco-wp' )
				),
				'default' => 'over',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-slider' )
				)
			),




			//Big Image Gallery
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-gallery-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Big Image Gallery Settings', 'ereco-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-gallery-description-placement',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Placement', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose placement of item description.', 'ereco-wp' ),
				'options'	=> array(
					'over'   => esc_html__( 'Over the Images', 'ereco-wp' ),
					'under'  => esc_html__( 'Under the Images', 'ereco-wp' )
				),
				'default' => 'over',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' )
				)
			),
			array(
				'id'       => 'portfolio-single-page-settings-portfolio-type-big-image-gallery-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Gallery Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-isotope-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Images Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your gallery items.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '3',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' )
				)
			),






			array(
				'id'        => 'portfolio-single-page-settings-other-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Other Settings', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-portfolio-meta',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Portfolio Meta', 'ereco-wp' ),
				'subtitle'     => esc_html__( 'Enable/Disabling this option will show/hide each Portfolio Meta on your Portfolio Details Page.', 'ereco-wp' ),
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-post-by-author'       => esc_html__( 'Show By Author', 'ereco-wp' ),
					'show-post-date'            => esc_html__( 'Show Date', 'ereco-wp' ),
					'show-post-date-split'      => esc_html__( 'Show Date Split', 'ereco-wp' ),
					'show-post-category'        => esc_html__( 'Show Category', 'ereco-wp' ),
					'show-post-tag'             => esc_html__( 'Show Tag', 'ereco-wp' ),
					'show-post-checklist-custom-fields'   => esc_html__( 'Show Checklist Custom Fields', 'ereco-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-post-by-author' => '0',
					'show-post-date' => '1',
					'show-post-date-split' => '0',
					'show-post-category' => '1',
					'show-post-tag' => '1',
					'show-post-checklist-custom-fields' => '1',
				)
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-share',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Share', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide share options on your page.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),


			//section Next/Previous Navigation Link Starts
			array(
				'id'       => 'portfolio-single-page-settings-show-next-pre-post-link-section-starts',
				'type'     => 'info',
				'title'    => esc_html__( 'Next/Previous Navigation Link', 'ereco-wp' ),
				'notice'   => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-next-pre-post-link',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Next/Previous Single Post Navigation Link', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link for Next & Previous Posts.', 'ereco-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-next-pre-post-link-within-same-cat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Navigation Link Within Same Category', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link to the next/previous post within the same category as the current post.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'portfolio-single-page-settings-show-next-pre-post-link', '=', '1' ),
			),




			//section Related Posts Starts
			array(
				'id'       => 'portfolio-single-page-settings-related-posts-section-starts',
				'type'     => 'info',
				'title'    => esc_html__( 'Related Posts', 'ereco-wp' ),
				'notice'   => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-related-posts',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Portfolio Items', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Posts List/Carousel on your page.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-related-posts-carousel',
				'type'     => 'switch',
				'title'    => esc_html__( 'Carousel?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make it carousel or grid', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'portfolio-single-page-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-related-posts-count',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Posts', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Enter number of posts to display. Default 3', 'ereco-wp' ),
				'default'  => '3',
				'required' => array( 'portfolio-single-page-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'            => 'portfolio-single-page-settings-show-related-posts-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 20,
				'min'           => 0,
				'step'          => 1,
				'max'           => 200,
				'display_value' => 'text',
				'required' => array( 'portfolio-single-page-settings-show-related-posts', '=', '1' ),
			),



			//section Related Posts Starts
			array(
				'id'       => 'portfolio-single-page-settings-comments-section-starts',
				'type'     => 'info',
				'title'    => esc_html__( 'Comments', 'ereco-wp' ),
				'notice'   => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Comments', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Comments on your page.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

		)
	) );





	// -> START Page Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Flaticon & Font Icon Packs', 'ereco-wp' ),
		'id'     => 'font-flat-icons-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-star-empty',
		'fields' => array(
			array(
				'id'       => 'page-settings-use-icomoon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Icomoon Icon Pack', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'ereco-wp'), '<a target="_blank" href="' . esc_url( 'https://icomoon.io/preview-free.html' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-elegant-icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Elegant Icon Pack', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'ereco-wp'), '<a target="_blank" href="' . esc_url( 'https://www.elegantthemes.com/blog/resources/elegant-icon-font' ) . '">', '</a>' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-pe-icon-7-stroke',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use 7 Stroke Icon Pack', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'ereco-wp'), '<a target="_blank" href="' . esc_url( 'http://themes-pixeden.com/font-demos/7-stroke/' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-ion-icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use ion Icon Pack', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'ereco-wp'), '<a target="_blank" href="' . esc_url( 'http://ionicons.com/' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-simple-line',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Simple Line Icon Fonts', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'ereco-wp'), '<a target="_blank" href="' . esc_url( 'http://simplelineicons.com/' ) . '">', '</a>' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-flaticon-current-theme',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Flaticon Pack (For Current Theme)', 'ereco-wp' ),
				'subtitle'  => esc_html__('You will get all icons into the download zip pakcage(into "flaticon-fonts" folder) of this theme. If you enable this option then this icon pack will become availalbe to use throughout the site.', 'ereco-wp'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-flaticon-contact',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Flaticon Contact Pack', 'ereco-wp' ),
				'subtitle'  => esc_html__('You will get all icons into the download zip pakcage(into "flaticon-fonts" folder) of this theme. If you enable this option then this icon pack will become availalbe to use throughout the site.', 'ereco-wp'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'page-settings-use-flaticon-shop',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Flaticon Shop', 'ereco-wp' ),
				'subtitle'  => esc_html__('You will get all icons into the download zip pakcage(into "flaticon-fonts" folder) of this theme. If you enable this option then this icon pack will become availalbe to use throughout the site.', 'ereco-wp'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
		)
	) );



	/* Check for LearnPress */
	if ( class_exists( 'LearnPress' ) ) {

	// -> START Footer
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'LearnPress', 'ereco-wp' ),
		'id'     => 'learnpress',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-book',
	) );


	// -> START Charitable Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Courses Archive', 'ereco-wp' ),
		'id'     => 'lp-courses-archive-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-book-alt',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'lp-courses-archive-settings-page-layout',
				'type'      => 'button_set',
				'title'    => esc_html__( 'Layout Mode', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a default layout mode for archive page', 'ereco-wp' ),
				'options'   => array(
					'standard'   => esc_html__( 'Standard', 'ereco-wp' ),
					'masonry'    => esc_html__( 'Masonry', 'ereco-wp' )
				),
				'default'   => 'standard',
			),
			array(
				'id'       => 'lp-courses-archive-settings-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Items Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select number of items to show per row.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
				),
				'default'=> '3',
			),
			array(
				'id'       => 'lp-courses-archive-settings-use-sidebar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Sidebar', 'ereco-wp' ),
				'subtitle'  => esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site.', 'ereco-wp'),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'lp-courses-archive-settings-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'default-sidebar',
				'required' => array( 'lp-donation-settings-use-sidebar', '=', '1' ),
			),

			
			array(
				'id'       => 'lp-courses-archive-settings-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_heading_tag_list_all(),
				'default'  => 'h5',
			),
		)
	) );

	
	}



	/* Check for Give */
	if ( class_exists( 'Give' ) ) {
	// -> START Give Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Give - Donation', 'ereco-wp' ),
		'id'     => 'give-donation-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-heart',
		'fields' => array(
			array(
				'id'       => 'give-donation-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Give Donation Page Sidebar Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for Donation Page', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'ereco-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'ereco-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'ereco-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'ereco-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'ereco-wp' ),

				),
				'default'  => 'sidebar-right-25',
			),
			array(
				'id'       => 'give-donation-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Donation Page Default Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on Donation Page.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'give-forms-sidebar',
				'required' => array( 'give-donation-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),



			array(
				'id'       => 'give-donation-settings-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Other Settings', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'give-donation-settings-campaign-creation-date',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Creation Date', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign creation date on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'give-donation-settings-campaign-creator',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Creator', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign donation count on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'give-donation-settings-campaign-categories',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Categories', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign categories on or off.', 'ereco-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'give-donation-settings-campaign-tags',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Tags', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign tags on or off.', 'ereco-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'give-donation-settings-campaign-progress-bar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Progress Bar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign campaign progress bar on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'give-donation-settings-campaign-raised-goal',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Stats', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign raised goal on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
		)
	) );
	}






	// -> START Custom Post Types Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Custom Post Types', 'ereco-wp' ),
		'id'     => 'cpt-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-carrot',
	) );



	// -> START Custom Post Types Clients Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Clients', 'ereco-wp' ),
		'id'     => 'cpt-settings-clients',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-clients-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Clients Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the clients custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-clients-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Clients Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Clients',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-clients-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Clients Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'  => 'dashicons-mascot',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-clients-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'clients',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-clients-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'clients-category',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types FAQ Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - FAQ', 'ereco-wp' ),
		'id'     => 'cpt-settings-faq',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-faq-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'FAQ Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the faq custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-faq-label',
				'type'     => 'text',
				'title'    => esc_html__( 'FAQ Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'FAQ',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-faq-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'FAQ Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-faq-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'faq',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-faq-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'faq-category',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),




			//section Related Posts Starts
			array(
				'id'       => 'cpt-settings-faq-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Related Posts', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Posts List/Carousel on your page. The full settings will be found at "Blog > Single Post" Theme Options', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'cpt-settings-faq-show-related-posts',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Posts', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'cpt-settings-faq-show-related-posts-count',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Posts', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Enter number of posts to display. Default 3', 'ereco-wp' ),
				'default'  => '3',
				'required' => array( 'cpt-settings-faq-show-related-posts', '=', '1' ),
			),



		)
	) );


	// -> START Custom Post Types Gallery Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Gallery', 'ereco-wp' ),
		'id'     => 'cpt-settings-gallery',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-gallery-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Gallery Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the gallery custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-gallery-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Gallery Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Gallery',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-gallery-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Gallery Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-gallery-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Gallery Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Gallery Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'gallery',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-gallery-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Gallery Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Gallery Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'gallery-category',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Portfolio Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Portfolio', 'ereco-wp' ),
		'id'     => 'cpt-settings-portfolio',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-portfolio-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Portfolio Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the portfolio custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-portfolio-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Portfolio',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Portfolio Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'portfolio',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Portfolio Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'portfolio-category',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-tag-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Tag Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Tag of Portfolio Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'portfolio-tag',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Projects Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Projects', 'ereco-wp' ),
		'id'     => 'cpt-settings-projects',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-projects-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Projects Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the projects custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-projects-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Projects Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Projects',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-projects-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Projects Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-projects-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Projects Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Projects Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'projects',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-projects-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Projects Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Projects Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'projects-category',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Services Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Services', 'ereco-wp' ),
		'id'     => 'cpt-settings-services',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-services-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Services Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the services custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-services-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Services Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Services',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-services-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Services Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-services-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Services Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Services Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'services',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-services-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Services Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Services Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'services-category',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),



			array(
				'id'        => 'cpt-settings-services-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Services Archive Page Settings', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-services-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Service Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/services/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/services/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-services-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Services Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your Services.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '4',
			),
			array(
				'id'            => 'cpt-settings-services-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Services Per Page', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on services archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-services-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Services Column Spacing (Gutter Size) px', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on services archive pages.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
		)
	) );


	// -> START Custom Post Types Staff Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Staff', 'ereco-wp' ),
		'id'     => 'cpt-settings-staff',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-staff-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Staff Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the staff custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Staff Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Staff',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Staff Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Staff Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Staff Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'staff',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Staff Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Staff Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'staff-category',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),






			array(
				'id'        => 'cpt-settings-staff-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Staff Archive Page Settings', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Staff Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/staff/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/staff/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-staff-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Staffs Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your Staffs.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '3',
			),
			array(
				'id'            => 'cpt-settings-staff-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Staffs Per Page', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on staff archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-staff-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Staffs Column Spacing (Gutter Size) px', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on staff archive pages.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),


			array(
				'id'       => 'cpt-settings-staff-archive-show-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Featured image size in blog page.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'ereco_mascot_featured_image',
				'required' => array( 'cpt-settings-staff-archive-show-featured-image', '=', '1' ),
			),


			array(
				'id'       => 'cpt-settings-staff-archive-show-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Title', 'ereco-wp' ),
				'default'  => 1,
			),

			array(
				'id'       => 'cpt-settings-staff-archive-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_heading_tag_list_all(),
				'default'  => 'h4',
				'required' => array( 'cpt-settings-staff-archive-show-title', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-speciality',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Speciality', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-bio',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Bio', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-social',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Links', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-working-hours',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Working Hours', 'ereco-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-btn',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Details Button', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-btn-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Details Button Text', 'ereco-wp' ),
				'default'  => esc_html__( 'View Details', 'ereco-wp' ),
				'required' => array( 'cpt-settings-staff-archive-show-btn', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Testimonials Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Testimonials', 'ereco-wp' ),
		'id'     => 'cpt-settings-testimonials',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-testimonials-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Testimonials Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the testimonials custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-testimonials-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Testimonials Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Testimonials',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-testimonials-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Testimonials Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-testimonials-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'testimonials',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-testimonials-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'testimonials-category',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Vacancies Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Vacancies', 'ereco-wp' ),
		'id'     => 'cpt-settings-vacancies',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-vacancies-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Vacancies Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the vacancies custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-vacancies-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Vacancies Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Vacancies',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-vacancies-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Vacancies Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-vacancies-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Vacancies Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Vacancies Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'vacancies',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-vacancies-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Vacancies Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Vacancies Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'vacancies-category',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Works Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Works', 'ereco-wp' ),
		'id'     => 'cpt-settings-works',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-works-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Works Post Type', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Toggle the works custom post type on or off.', 'ereco-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-works-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Works Label', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'ereco-wp' ),
				'default'  => 'Works',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-works-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Works Admin Dashboard Icon', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-works-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Works Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Works Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'works',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-works-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Works Category Slug', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Works Post Type. ', 'ereco-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'ereco-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'works-category',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),

			array(
				'id'        => 'cpt-settings-works-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Works Archive Page Settings', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-works-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Works Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/works/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/works/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-works-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of works Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your works.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '2',
			),
			array(
				'id'            => 'cpt-settings-works-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of works Per Page', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on works archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-works-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'works Column Spacing (Gutter Size) px', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on works archive pages.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
		)
	) );




	// -> START Shop Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Woocommerce Shop', 'ereco-wp' ),
		'id'     => 'shop-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-cart',
	) );



	// -> START Shop Archive Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Shop Archive/Category Layout', 'ereco-wp' ),
		'id'     => 'shop-archive-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'shop-archive-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Fullwidth?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make the shop page fullwidth or not.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'shop-archive-settings-sidebar-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the position of shop sidebar.', 'ereco-wp' ),
				'options'	=> array(
					'left'          => esc_html__( 'Left', 'ereco-wp' ),
					'right'         => esc_html__( 'Right', 'ereco-wp' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'ereco-wp' )
				),
				'default'  => 'no-sidebar',
			),
			array(
				'id'       => 'shop-archive-settings-sidebar-choose',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar that will be displayed on shop page.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'shop_sidebar',
				'required' => array( 'shop-archive-settings-sidebar-position', '!=', 'no-sidebar' ),
			),




			array(
				'id'       => 'shop-layout-settings-select-shop-catalog-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Shop Catalog Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the type of layout you would like to display.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'default' => array(
						'alt' => 'Default',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/type/default.png'
					),
					'classic' => array(
						'alt' => 'Classic',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/type/classic.png'
					),
				),
				'default'  => 'default'
			),

			array(
				'id'       => 'shop-layout-settings-select-shop-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Shop Layout Mode (FitRows Or Masonry)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),


			array(
				'id'       => 'shop-archive-settings-products-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Products Per Row', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your shop items.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '4',
			),
			array(
				'id'            => 'shop-archive-settings-products-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Products Per Page', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on shop archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 10,
				'min'           => -1,
				'step'          => 1,
				'max'           => 100,
				'display_value' => 'text',
			),
			array(
				'id'            => 'shop-archive-settings-products-per-page-dropdown-options',
				'type'          => 'text',
				'title'         => esc_html__( 'WooCommerce Products Per Page Dropdown', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'List of options products per page to show into the select dropdown menu.', 'ereco-wp' ),
				'desc'         => esc_html__( 'Seperated by spaces', 'ereco-wp' ),
				'default'       => '8 16 32 64',
			),
			array(
				'id'            => 'shop-archive-settings-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Shop Column Spacing (Gutter Size) px', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on shop archive pages.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 20,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
			array(
				'id'       => 'shop-archive-settings-products-thumb-type',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Thumbnail Type', 'ereco-wp' ),
				'subtitle'    => esc_html__( 'Select your preferred style for your WooCommmerce product thumbnail.', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'image-featured'  => 'Featured Image',
					'image-swap'  => 'Image Swap',
					'image-gallery'  => 'Gallery Images',
				),
				'default'  => 'image-swap',
			),
		)
	) );



	// -> START Shop Single Product Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Shop Single Product', 'ereco-wp' ),
		'id'     => 'shop-single-product-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'shop-single-product-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Fullwidth?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Make the single product page fullwidth or not.', 'ereco-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'shop-single-product-settings-sidebar-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar Position', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the sidebar position of shop single product page.', 'ereco-wp' ),
				'options'	=> array(
					'left'          => esc_html__( 'Left', 'ereco-wp' ),
					'right'         => esc_html__( 'Right', 'ereco-wp' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'ereco-wp' )
				),
				'default'  => 'no-sidebar',
			),
			array(
				'id'       => 'shop-single-product-settings-sidebar-choose',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Sidebar', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar that will be displayed on shop page.', 'ereco-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'shop_sidebar',
				'required' => array( 'shop-archive-settings-sidebar-position', '!=', 'no-sidebar' ),
			),



			array(
				'id'       => 'shop-single-product-settings-select-single-catalog-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Product Details Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select the type of layout you would like to display.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'image-with-thumb' => array(
						'alt' => 'image-with-thumb',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/single-layout/image-with-thumb.png'
					),
					'plain-image' => array(
						'alt' => 'plain-image',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/single-layout/plain-image.png'
					),
					'sticky-side-text' => array(
						'alt' => 'sticky-side-text',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/shop/single-layout/sticky-side-text.png'
					),
				),
				'default'  => 'image-with-thumb'
			),



			array(
				'id'       => 'shop-single-product-settings-product-images-column-width',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Images Column Width', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'4'     => esc_html__( 'Small - 4/12', 'ereco-wp' ),
					'5'     => esc_html__( 'Medium - 5/12', 'ereco-wp' ),
					'6'     => esc_html__( 'Large - 6/12', 'ereco-wp' ),
					'8'     => esc_html__( 'Extra Large - 8/12', 'ereco-wp' ),
				),
				'default'  => '6',
			),
			array(
				'id'       => 'shop-single-product-settings-product-images-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Images Alignment', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'left'     => esc_html__( 'Left', 'ereco-wp' ),
					'right'    => esc_html__( 'Right', 'ereco-wp' ),
				),
				'default'  => 'left',
			),

			array(
				'id'       => 'shop-single-product-settings-enable-gallery-slider',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Image Gallery Slider Feature', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 'shop-single-product-settings-select-single-catalog-layout', '=', 'image-with-thumb' ),
			),
			array(
				'id'       => 'shop-single-product-settings-enable-gallery-lightbox',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Image Gallery Lightbox Feature', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'shop-single-product-settings-enable-gallery-zoom',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Image Gallery Zoom Feature', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),




			array(
				'id'       => 'shop-single-product-settings-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Single Product Title Tag', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> ereco_mascot_heading_tag_list_all(),
				'default'  => 'h3',
			),
			array(
				'id'       => 'shop-single-product-settings-enable-product-meta',
				'type'     => 'switch',
				'title'    => esc_html__( 'Product Meta', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => 'shop-single-product-settings-enable-sharing',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Sharing', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

			
			//section Related Posts Starts
			array(
				'id'       => 'shop-single-product-settings-related-products-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Related Products', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Products List/Carousel on your page.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'shop-single-product-settings-related-products-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Related Products Columns', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Set number of columns for related and upsells products only', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '4',
			),
			array(
				'id'            => 'shop-single-product-settings-related-products-count',
				'type'          => 'text',
				'title'         => esc_html__( 'Related Products Count', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Number of related products shown on single product page. Enter "0" to disable.', 'ereco-wp' ),
				'default'       => '4',
			),

			array(
				'id'       => 'shop-single-product-settings-related-products-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START WooCommerce Styling Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'WooCommerce Styling', 'ereco-wp' ),
		'id'     => 'woocommerce-styling-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'woocommerce-styling-product-price-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Product Price Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select your custom color for product price.', 'ereco-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'woocommerce-styling-product-on-sale-tag-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'On Sale Tag Background Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select your custom background color for on-sale tag.', 'ereco-wp' ),
				'transparent' => true,
			),
		)
	) );



	// -> START Sidebar Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Sidebar Widgets', 'ereco-wp' ),
		'id'     => 'sidebar-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-align-left',
		'fields' => array(
			array(
				'id'       => 'sidebar-settings-sidebar-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Sidebar Padding(px)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the sidebar padding. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'ereco-wp' ),
			),
			array(
				'id'       => 'sidebar-settings-sidebar-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Sidebar Background Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of sidebar.', 'ereco-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'sidebar-settings-sidebar-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Text Alignment', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'left'     => esc_html__( 'Left', 'ereco-wp' ),
					'center'   => esc_html__( 'Center', 'ereco-wp' ),
					'right'    => esc_html__( 'Right', 'ereco-wp' ),
				),
				'default'  => '',
			),

			
			//section Related Items Starts
			array(
				'id'       => 'sidebar-settings-sidebar-title-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Sidebar Widget Title', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Widget Title Padding(px)', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the sidebar widget title padding. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'ereco-wp' ),
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of sidebar widget title box', 'ereco-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-text-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Text Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of sidebar widget title box', 'ereco-wp' ),
				'transparent' => false,
			),
			array(
				'id'            => 'sidebar-settings-sidebar-title-font-size',
				'type'          => 'text',
				'title'         => esc_html__( 'Font Size(px)', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'ereco-wp' ),
				'desc'          => '',
			),

			
			array(
				'id'       => 'sidebar-settings-sidebar-title-show-line-bottom',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Line Bottom', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you enable it then a thin line will be visible below the widget title.', 'ereco-wp' ),
				'desc'     => '',
				'default'  => '1',
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-line-bottom-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Line Bottom Theme Colored?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'To make the Line Bottom theme colored, please check it.', 'ereco-wp' ),
				'desc'     => '',
				'options'  => ereco_mascot_theme_color_list(),
				'default'  => '1',
				'required' => array( 'sidebar-settings-sidebar-title-show-line-bottom', '=', '1' ),
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-line-bottom-custom-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Line Bottom Color', 'ereco-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'sidebar-settings-sidebar-title-line-bottom-theme-colored', '=', '' ),
			),


			array(
				'id'     => 'sidebar-settings-sidebar-title-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START 404 Page Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( '404 Page', 'ereco-wp' ),
		'id'     => '404-page-settings',
		'desc'   => esc_html__( 'Title, content and background settings for 404 Error Page', 'ereco-wp' ),
		'icon'   => 'dashicons-before dashicons-editor-help',
		'fields' => array(
			array(
				'id'       => '404-page-settings-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Layout', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose one among different layouts.', 'ereco-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'simple' => array(
						'alt' => 'Simple',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/404/simple.jpg'
					),
					'split' => array(
						'alt' => 'Split',
						'img' => ERECO_MASCOT_ADMIN_ASSETS_URI . '/images/404/split.jpg'
					),
				),
				'default'  => 'split',
			),
			array(
				'id'       => '404-page-settings-show-header',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Header', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => '404-page-settings-show-footer',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Footer', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			
			array(
				'id'       => '404-page-settings-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Text Alignment', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Text Alignment of this page', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> ereco_mascot_redux_text_alignment_list(),
				'default'  => 'text-center',
			),
			array(
				'id'       => '404-page-settings-show-back-to-home-button',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Back to Home Button', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => '404-page-settings-back-to-home-button-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Back to Home Button Label', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Default: "Back to Home"', 'ereco-wp' ),
				'default'  => esc_html__( 'Back to Home', 'ereco-wp' ),
				'required' => array( 
					array( '404-page-settings-show-back-to-home-button', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-show-social-links',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Links', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),





			//section custom background
			array(
				'id'       => '404-page-settings-custom-background-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Custom Background', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define background for 404 page.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-custom-background-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Custom Background', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => '404-page-settings-bg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Choose background image or color.', 'ereco-wp' ),
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-bg-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Background Overlay', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-bg-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'ereco-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image on footer.', 'ereco-wp' ),
				'desc'          => '',
				'default'       => 7,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' ),
					array( '404-page-settings-bg-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-bg-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'ereco-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'ereco-wp' ),
					'dark'          => esc_html__( 'Dark', 'ereco-wp' ),
					'white'         => esc_html__( 'White', 'ereco-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'ereco-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'ereco-wp' ),
					'theme-colored3' => esc_html__( 'Primary Theme Color3', 'ereco-wp' ),
					'theme-colored4' => esc_html__( 'Primary Theme Color4', 'ereco-wp' )
				),
				'default' => 'dark',
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' ),
					array( '404-page-settings-bg-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-custom-background-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' )
				)
			),





			//section Title Starts
			array(
				'id'       => '404-page-settings-title-typography-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Title', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for Title.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-title',
				'type'     => 'text',
				'title'    => esc_html__( 'Title Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Set page title to show', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( '404', 'ereco-wp' ),
			),
			array(
				'id'       => '404-page-settings-subtitle',
				'type'     => 'text',
				'title'    => esc_html__( 'Sub Title Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Set page sub title to show', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Oops! Page Not Found!', 'ereco-wp' ),
			),
			array(
				'id'            => '404-page-settings-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Title Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => '404-page-settings-title-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => '404-page-settings-title-typography-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),





			//section Content Starts
			array(
				'id'       => '404-page-settings-content-typography-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Content', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for Content.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-content',
				'type'     => 'editor',
				'title'    => esc_html__( 'Content Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Enter the content for 404 page which will be showed below title.', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'The page you are looking for does not exist. It might have been moved or deleted.', 'ereco-wp' ),
			),
			array(
				'id'            => '404-page-settings-content-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Content Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => '404-page-settings-content-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => '404-page-settings-content-typography-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),




			//section Helpful Links Starts
			array(
				'id'       => '404-page-settings-helpful-links-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Helpful Links', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for helpful links.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-show-helpful-links',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Helpful Links', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => sprintf( esc_html__( 'Please create a new menu from %1$sAppearance > Menus%2$s and set Theme Location %1$s"Page 404 Helpful Links"%2$s', 'ereco-wp' ), '<strong>', '</strong>', '<br>'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => '404-page-settings-helpful-links-heading',
				'type'     => 'text',
				'title'    => esc_html__( 'Heading Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Set heading text to show', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Helpful Links', 'ereco-wp' ),
				'required' => array( 
					array( '404-page-settings-show-helpful-links', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-helpful-links-heading-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Heading Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-helpful-links', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-helpful-links-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Links Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-helpful-links', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-helpful-links-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),




			//section Search Box Starts
			array(
				'id'       => '404-page-settings-search-box-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Search Box', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for search box.', 'ereco-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-show-search-box',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Search Box', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),
			array(
				'id'       => '404-page-settings-search-box-heading',
				'type'     => 'text',
				'title'    => esc_html__( 'Heading Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Set heading text to show', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Search Website', 'ereco-wp' ),
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-search-box-paragraph',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Paragraph Text', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Set paragraph text to show', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Please use the search box to find what you are looking for. Perhaps searching can help.', 'ereco-wp' ),
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-search-box-heading-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Heading Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-search-box-paragraph-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Paragraph Typography', 'ereco-wp' ),
				'subtitle'      => '',
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-search-box-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );


	if( ereco_mascot_core_plugin_installed() && function_exists( 'mascot_core_ereco_redux_opt_maintenance_section' ) ) {
		Redux::setSection( $opt_name, mascot_core_ereco_redux_opt_maintenance_section() );
	}


	// -> START Social Links Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Social Links', 'ereco-wp' ),
		'id'     => 'social-links',
		'desc'   => esc_html__( 'This is your official social links. Set the order of social links to be appeared in the header/footer section.', 'ereco-wp' ),
		'icon'   => 'dashicons-before dashicons-facebook-alt',
		'fields' => $redux_config_social_links_arraylist
	) );



	// -> START Sharing Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Sharing Settings', 'ereco-wp' ),
		'id'     => 'sharing-settings',
		'desc'   => esc_html__( 'Enable/Disable social sharing buttons for posts, pages and portfolio single pages', 'ereco-wp' ),
		'icon'   => 'dashicons-before dashicons-share',
		'fields' => array(
			array(
				'id'       => 'sharing-settings-enable-sharing',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Sharing', 'ereco-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'ereco-wp' ),
				'off'      => esc_html__( 'No', 'ereco-wp' ),
			),

			array(
				'id'       => 'sharing-settings-heading',
				'type'     => 'text',
				'title'    => esc_html__( 'Sharing Heading', 'ereco-wp' ),
				'subtitle' => esc_html__( 'Your custom text for the social sharing heading.', 'ereco-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Share On:', 'ereco-wp' ),
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),
			array(
				'id'       => 'sharing-settings-icon-type',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Icon Type', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'text'          => 'Text',
					'icon'          => 'Flat Icon',
					'icon-brand'    => 'Icon with Brand Color',
				),
				'default'  => 'icon-brand',
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),

			//Buttons Type Icon
			array(
				'id'       => 'sharing-settings-social-links-color',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Links - Background Color', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-gray'     => esc_html__( 'Gray', 'ereco-wp' ),
					'icon-dark'     => esc_html__( 'Dark', 'ereco-wp' ),
					'icon-white'    => esc_html__( 'White', 'ereco-wp' ),
					''              => esc_html__( 'Default', 'ereco-wp' ),
				),
				'default'  => 'icon-gray',
				'required' => array( 
					array( 'sharing-settings-icon-type', '=', 'icon' ),
				)
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Icons Style', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-rounded'   => esc_html__( 'Rounded', 'ereco-wp' ),
					'icon-default'	 => esc_html__( 'Default', 'ereco-wp' ),
					'icon-circled'   => esc_html__( 'Circled', 'ereco-wp' ),
				),
				'default'  => 'icon-circled',
				'required' => array( 'sharing-settings-icon-type', '!=', 'text' ),
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-size',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Icons Size', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					''          => esc_html__( 'Default', 'ereco-wp' ),
					'icon-xs'   => esc_html__( 'Extra Small', 'ereco-wp' ),
					'icon-sm'	=> esc_html__( 'Small', 'ereco-wp' ),
					'icon-md'   => esc_html__( 'Medium', 'ereco-wp' ),
					'icon-lg'   => esc_html__( 'Large', 'ereco-wp' ),
					'icon-xl'   => esc_html__( 'Extra Large', 'ereco-wp' ),
				),
				'default'  => 'icon-md',
				'required' => array( 'sharing-settings-icon-type', '!=', 'text' ),
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-animation-effect',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Icons Animation Effect', 'ereco-wp' ),
				'desc'     => '',
				'options'	=> array(
					'styled-icons-effect-rollover'   => esc_html__( 'Roll Over', 'ereco-wp' ),
					''                               => esc_html__( 'Default', 'ereco-wp' ),
					'styled-icons-effect-rotate'     => esc_html__( 'Rotate', 'ereco-wp' ),
				),
				'default'  => '',
				'required' => array( 'sharing-settings-icon-type', '!=', 'text' ),
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-border-style',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Make Sharing Icon Area Bordered?', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => '0',
				'required' => array( 
					array( 'sharing-settings-social-links-color', '!=', 'brand-color' ),
				)
			),
			array(
				'id'       => 'sharing-settings-social-links-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Sharing Icons Theme Colored?', 'ereco-wp' ),
				'subtitle' => esc_html__( 'To make the sharing icons theme colored, please check it.', 'ereco-wp' ),
				'desc'     => '',
				'options'  => ereco_mascot_theme_color_list(),
				'default'  => '',
				'required' => array( 
					array( 'sharing-settings-social-links-color', '!=', 'brand-color' ),
				)
			),





			array(
				'id'       => 'sharing-settings-show-social-share-on',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Social Share On', 'ereco-wp' ),
				'subtitle'     => '',
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-on-posts'     => esc_html__( 'Posts', 'ereco-wp' ),
					'show-on-pages'     => esc_html__( 'Pages', 'ereco-wp' ),
					'show-on-tribe-events'     => esc_html__( 'Tribe Events', 'ereco-wp' ),
					'show-on-portfolio' => esc_html__( 'Portfolio', 'ereco-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-on-posts' => '1',
					'show-on-pages' => '1',
					'show-on-tribe-events' => '1',
					'show-on-portfolio' => '1',
				),
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),
			array(
				'id'       => 'sharing-settings-networks',
				'type'     => 'sorter',
				'title'    => esc_html__( 'Seleted Social Networks', 'ereco-wp' ),
				'desc'     => '',
				'compiler' => 'true',
				'options'	=> array(
					'Enabled' => array(
						'twitter'    => 'Twitter',
						'facebook'   => 'Facebook',
						'linkedin'   => 'Linkedin',
						'email'      => 'Email',
					),
					'Disabled'  => array(
						'tumblr'     => 'Tumblr',
						'pinterest'  => 'Pinterest',
						'vk'        => 'VK',
						'reddit'    => 'Reddit',
						'print'     => 'Print',
					),
				),
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),

			//section Social Network URLs Starts
			array(
				'id'       => 'sharing-settings-icon-tooltip-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Sharing Icon Tooltip', 'ereco-wp' ),
				'subtitle' => '',
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),

			array(
				'id'       => 'sharing-settings-tooltip-directions',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Tooltip Text Directions', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'top'    => 'Top',
					'right'  => 'Right',
					'bottom' => 'Bottom',
					'left'   => 'Left',
					'none'   => 'None',
				),
				'default'  => 'top',
			),
			array(
				'id'       => 'sharing-settings-tooltip-twitter',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Twitter', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Twitter', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-facebook',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Facebook', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Facebook', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-linkedin',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for LinkedIn', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on LinkedIn', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-tumblr',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Tumblr', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Tumblr', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-email',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Email', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Email', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-vk',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for VKontakte', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on VKontakte', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-pinterest',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Pinterest', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Pinterest', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-reddit',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Reddit', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Reddit', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-print',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Print', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Print This Page', 'ereco-wp' ),
			),
			array(
				'id'       => 'sharing-settings-icon-tooltip-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),

		)
	) );



	// -> START Twitter API Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'API Settings', 'ereco-wp' ),
		'id'     => 'theme-api-settings',
		'desc'  => esc_html__( 'Fill the following fields if you want to use these features', 'ereco-wp' ),
		'icon'   => 'dashicons-before dashicons-admin-network',
		'fields' => array(
			array(
				'id'        => 'theme-api-settings-gmaps',
				'type'      => 'info',
				'title'     => esc_html__( 'Google Maps API Settings', 'ereco-wp' ),
				'subtitle'  => esc_html__( 'Fill the following field if you want to use Google Maps', 'ereco-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'theme-api-settings-gmaps-api-key',
				'type'     => 'text',
				'title'    => esc_html__( 'Google Maps API Key', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),


			array(
				'id'        => 'theme-api-settings-twitter',
				'type'      => 'info',
				'title'     => esc_html__( 'Twitter API Settings', 'ereco-wp' ),
				'subtitle'  => sprintf( esc_html__('Fill the following fields if you want to use Twitter Feed Widget. You can collect those keys by creating your own Twitter API from here %s%s', 'ereco-wp'), '<a target="_blank" class="text-white" href="' . esc_url( 'https://dev.twitter.com/apps' ) . '">', '</a>' ),
				'notice'    => false,
			),

			array(
				'id'       => 'theme-api-settings-twitter-api-key',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter API Key', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => 'theme-api-settings-twitter-api-secret',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter API Secret', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),

			array(
				'id'       => 'theme-api-settings-twitter-api-access-token',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter Access Token', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => 'theme-api-settings-twitter-api-access-token-secret',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter Access Token Secret', 'ereco-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
		)
	) );



	// -> START Custom HTML/JS Codes
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Custom HTML/JS Codes', 'ereco-wp' ),
		'id'     => 'custom-codes',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-code',
		'fields' => array(
			array(
				'id'       => 'custom-codes-custom-html-script-header',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Custom HTML/JS Code - in Header before &lt;/head&gt; tag', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you have any custom HTML or JS Code you would like to add in the header before &lt;/head&gt; tag of the site then please enter it here. Only accepts javascript code wrapped with &lt;script&gt; tags and valid HTML markup.', 'ereco-wp' ),
				'mode'     => 'javascript',
				'theme'    => 'chrome',
				'desc'     => '',
				'default'     => '',
			),
			array(
				'id'       => 'custom-codes-custom-html-script-footer',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Custom HTML/JS Code - in Footer before &lt;/body&gt; tag', 'ereco-wp' ),
				'subtitle' => esc_html__( 'If you have any custom HTML or JS Code you would like to add in the footer before &lt;/body&gt; tag of the site then please enter it here. Only accepts javascript code wrapped with &lt;script&gt; tags and valid HTML markup.', 'ereco-wp' ),
				'mode'     => 'javascript',
				'theme'    => 'chrome',
				'desc'     => '',
				'default'     => '',
			)
		)
	) );
	
	
	/*
	 * <--- END SECTIONS
	 */

