<?php
namespace Elementor;

function tm_shortcode_templates_insert_elementor($atts){

	// Enable support for WPML & Polylang
	$language_support = apply_filters('ae_multilingual_support', false);

    if(!class_exists('Elementor\Plugin')){
        return '';
    }
    if(!isset($atts['id']) || empty($atts['id'])){
        return '';
    }

    $post_id = $atts['id'];

    if($language_support){
	    $post_id = apply_filters( 'wpml_object_id', $post_id, 'ae_global_templates' );
    }



    $response = Plugin::instance()->frontend->get_builder_content_for_display($post_id);
    return $response;
}
add_shortcode('tm_shortcode_templates','Elementor\tm_shortcode_templates_insert_elementor');


/**
 *  Enable the use of shortcodes in text widgets.
 */
add_filter( 'widget_text', 'do_shortcode' );

