<?php
  $random_number = wp_rand( 111111, 999999 );
?>

<?php if ( $the_query->have_posts() ) : ?>

  <!-- Portfolio Gallery Grid -->
  <div id="widget-grid-<?php echo esc_attr( $random_number.'-'.get_the_ID() );?>" class="tm-widget tm-widget-gallery isotope-layout grid-<?php echo esc_attr( $grid );?> gutter-<?php echo esc_attr( $gutter );?> <?php echo esc_attr( $custom_css_class );?> lightgallery-lightbox clearfix">
	<!-- the loop -->
	<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
	<?php
		$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
		$full_image_url = $full_image_url[0];

		$gallery_images = ereco_mascot_get_rwmb_group_advanced( 'ereco_mascot_' . "gallery_mb_settings",  "gallery_images", null, false, 'all' );
		//if has no post thumbnail
		if( !has_post_thumbnail( get_the_ID() ) ) {
			if ( !empty( $gallery_images ) ) {
				$first_image_key = key($gallery_images);
				$full_image_url = $gallery_images[$first_image_key]['url'];
			}
		}

		//thumb image
		$thumbnail_image_size = apply_filters( 'ereco_widget_gallery_thumbnail_image_size', 'medium' );
		$thumb_url = wp_get_attachment_image_src( get_post_thumbnail_id(), $thumbnail_image_size );
		$thumb_url = $thumb_url[0];

		// if has no post thubnail or gallery images then add placeholder image
		if( empty( $thumb_url ) ) {
			$thumb_url = array();
			$full_image_url = $thumb_url['url'] = "//placehold.it/250x250?text=Image Not Found!";
		}
	?>
	<!-- Portfolio Item Start -->
	<div class="isotope-item box-hover-effect">
		<div class="effect-wrapper">
			<div class="thumb">
				<img src="<?php echo esc_url( $thumb_url );?>" alt="<?php the_title_attribute(); ?>">
			</div>
			<div class="overlay-shade"></div>
			<a class="lightgallery-trigger hover-link" data-exthumbimage="<?php echo esc_url( $full_image_url );?>" data-src="<?php echo esc_url( $full_image_url );?>" title="<?php the_title_attribute(); ?>" href="<?php echo esc_url( $full_image_url );?>"></a>
		</div>
	</div>
	<!-- Portfolio Item End -->
	<?php endwhile; ?>
	<!-- end of the loop -->
  </div>
  <!-- End Portfolio Gallery Grid -->
  <?php wp_reset_postdata(); ?>

<?php else : ?>
  <?php ereco_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>