<?php

class Mascot_Core_Ereco_Elementor_Column_Handler {
	private static $instance;
	public $sections = array();
	
	public function __construct() {
		add_action( 'elementor/element/column/_section_responsive/after_section_end', array( $this, 'render_parallax_options' ), 10, 2 );
		add_action( 'elementor/frontend/column/before_render', array( $this, 'section_before_render' ) );
		add_action( 'elementor/frontend/element/before_render', array( $this, 'section_before_render' ) );
	}
	
	public static function get_instance() {
		if ( self::$instance === null ) {
			return new self();
		}
		
		return self::$instance;
	}
	
	public function render_parallax_options( $section, $args ) {
		$section->start_controls_section(
			'tm_core_options',
			[
				'label' => TM_ELEMENTOR_WIDGET_BADGE . esc_html__( 'Mascot - Core Options', 'mascot-core-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
        $section->add_responsive_control(
            'tm_section_bg_theme_colored',
            [
                'label' => esc_html__( "Background Theme Colored", 'mascot-core-elementor' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => ereco_mascot_theme_color_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => '',
				'selectors' => [
					'{{WRAPPER}}' => 'background-color: var(--theme-color{{VALUE}});'
				],
            ]
        );
		$section->end_controls_section();





		//Stretched BG
		$section->start_controls_section(
			'stretched_bg',
			[
				'label' => TM_ELEMENTOR_WIDGET_BADGE . esc_html__( 'Mascot - Stretched BG', 'mascot-core-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		$section->add_control(
			'stretched_bg_direction',
			[
				'label'        => esc_html__( 'Stretched Background Direction', 'mascot-core-elementor'),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options' => [
					'no'    => esc_html__( 'No', 'mascot-core-elementor' ),
					'tm-stretched-bg-both'  => esc_html__( 'Both', 'mascot-core-elementor' ),
					'tm-stretched-bg-left'  => esc_html__( 'Left', 'mascot-core-elementor' ),
					'tm-stretched-bg-right' => esc_html__( 'Right', 'mascot-core-elementor' )
				],
			]
		);
		$section->add_control(
			'stretched_bg_image',
			[
				'label' => esc_html__( "Stretched Background Image", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'stretched_bg_direction' => array('tm-stretched-bg-both', 'tm-stretched-bg-left', 'tm-stretched-bg-right')
				]
			]
		);
        $section->add_responsive_control(
            'stretched_bg_theme_color',
            [
                'label' => esc_html__( "Background Theme Colored", 'mascot-core-elementor' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => ereco_mascot_theme_color_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => '',
				'condition' => [
					'stretched_bg_direction' => array('tm-stretched-bg-both', 'tm-stretched-bg-left', 'tm-stretched-bg-right')
				],
				'selectors' => [
					'{{WRAPPER}} .tm-stretched-bg' => 'background-color: var(--theme-color{{VALUE}});',
					'[data-col-id="elementor-element-{{ID}}"].tm-stretched-bg' => 'background-color: var(--theme-color{{VALUE}});',
					'.elementor-edit-area-active .elementor-element-{{ID}}' => 'background-color: var(--theme-color{{VALUE}});',
				],
            ]
        );
		$section->add_control(
			'stretched_bg_color',
			[
				'label' => esc_html__( "Custom Background Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'stretched_bg_direction' => array('tm-stretched-bg-both', 'tm-stretched-bg-left', 'tm-stretched-bg-right')
				]
			]
		);
		$section->add_control(
			'stretched_bg_custom_css_class',
			[
				'label' => esc_html__( "Stretched Background Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'stretched_bg_direction' => array('tm-stretched-bg-both', 'tm-stretched-bg-left', 'tm-stretched-bg-right')
				]
			]
		);
		$section->add_control(
			'stretched_bg_style',
			[
				'label' => esc_html__( "Stretched Background Custom Inline CSS", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Example: background-color: #f1f1f1;", 'mascot-core-elementor' ),
				'condition' => [
					'stretched_bg_direction' => array('tm-stretched-bg-both', 'tm-stretched-bg-left', 'tm-stretched-bg-right')
				]
			]
		);
		$section->end_controls_section();
	}
	
	public function section_before_render( $widget ) {
		$data     = $widget->get_data();
		$type     = isset( $data['elType'] ) ? $data['elType'] : 'section';
		$settings = $data['settings'];
		//print_r($data); echo "string";
		
		if ( 'column' === $type ) {
			if ( isset( $settings['tm_section_bg_theme_colored'] ) && $settings['tm_section_bg_theme_colored'] != '' ) {
				//$widget->add_render_attribute( '_wrapper', 'class', 'bg-theme-colored'.$settings['tm_section_bg_theme_colored'] );
			}




			//Stretched BG
			if ( isset( $settings['stretched_bg_direction'] ) ) {
				$output= '';
				if ( $settings['stretched_bg_direction'] != 'no' ) {
					$stretched_bg_classes = array();
					$stretched_bg_classes[] = $settings['stretched_bg_direction'];
					if( empty($settings['stretched_bg_custom_css_class']) ) {
						$settings['stretched_bg_custom_css_class'] = '';
					}
					$stretched_bg_classes[] = $settings['stretched_bg_custom_css_class'];
					//$stretched_bg_classes[] = 'bg-theme-colored' . $settings['stretched_bg_theme_color'];
					$stretched_bg_inline_css = '';
					if( isset( $settings['stretched_bg_image'] ) && !empty( $settings['stretched_bg_image'] ) ) {
						$stretched_bg_image_url = wp_get_attachment_image_src( $settings['stretched_bg_image'], 'full');
						$stretched_bg_inline_css .= 'background-image: url('.$stretched_bg_image_url[0].') !important;';
					}
					if( isset( $settings['stretched_bg_color'] ) && !empty( $settings['stretched_bg_color'] ) ) {;
						$stretched_bg_inline_css .= 'background-color: '.$settings['stretched_bg_color'].' !important;';
					}
					if( isset( $settings['stretched_bg_style'] ) && !empty( $settings['stretched_bg_style'] ) ) {;
						$stretched_bg_inline_css .= $settings['stretched_bg_style'];
					}
					$output .= '<div data-col-id="elementor-element-'. esc_attr($data['id']).'" class="tm-stretched-bg '. esc_attr(implode(' ', $stretched_bg_classes)).'" style="'. esc_attr($stretched_bg_inline_css).'"></div>';
				}
				echo $output;
			}
		}
	}
}

if ( ! function_exists( 'mascot_core_ereco_elementor_init_column_handler' ) ) {
	function mascot_core_ereco_elementor_init_column_handler() {
		Mascot_Core_Ereco_Elementor_Column_Handler::get_instance();
	}
	
	add_action( 'init', 'mascot_core_ereco_elementor_init_column_handler', 1 );
} 