<?php

if(!function_exists('mascot_core_ereco_elementor_get_cpt_shortcode_template_part')) {
	/**
	 * Load a cpt shortcode template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function mascot_core_ereco_elementor_get_cpt_shortcode_template_part( $slug, $name = null, $folder, $params = array(), $shortcode_ob_start ) {

		$template_path = 'cpt/' . $folder . '/' . $slug;

		return mascot_core_ereco_elementor_get_template_part( $template_path, $name, $params, $shortcode_ob_start );

	}
}

if(!function_exists('mascot_core_ereco_elementor_get_shortcode_template_part')) {
	/**
	 * Load a shortcode template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function mascot_core_ereco_elementor_get_shortcode_template_part( $slug, $name = null, $folder, $params = array(), $shortcode_ob_start ) {

		$template_path = 'widgets/' . $folder . '/' . $slug;

		return mascot_core_ereco_elementor_get_template_part( $template_path, $name, $params, $shortcode_ob_start );

	}
}

if(!function_exists('mascot_core_ereco_elementor_get_shortcode_current_theme_template_part')) {
	/**
	 * Load a shortcode template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function mascot_core_ereco_elementor_get_shortcode_current_theme_template_part( $slug, $name = null, $folder, $params = array(), $shortcode_ob_start ) {

		$template_path = 'widgets-current-theme/' . $folder . '/' . $slug;

		return mascot_core_ereco_elementor_get_template_part( $template_path, $name, $params, $shortcode_ob_start );

	}
}

if(!function_exists('mascot_core_ereco_elementor_get_shortcode_shop_template_part')) {
	/**
	 * Load a shortcode template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function mascot_core_ereco_elementor_get_shortcode_shop_template_part( $slug, $name = null, $folder, $params = array(), $shortcode_ob_start ) {

		$template_path = 'widgets-shop/' . $folder . '/' . $slug;

		return mascot_core_ereco_elementor_get_template_part( $template_path, $name, $params, $shortcode_ob_start );

	}
}


if(!function_exists('mascot_core_ereco_elementor_get_template_part')) {
	/**
	 * Load a template part into a template
	 *
	 * @param string $template_path path of the specialised template.
	 * @param string $name The name of the specialised template.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function mascot_core_ereco_elementor_get_template_part( $template_path, $name = null, $params = array(), $shortcode_ob_start = false ) {

		$output_html = '';

		if( is_array($params) && count($params) ) {
			extract($params);
		}

		$templates = array();
		$name = (string) $name;
		if ( '' !== $name )
			$templates[] = "{$template_path}-{$name}.php";

		$templates[] = "{$template_path}.php";

		$located = mascot_core_ereco_elementor_locate_template($templates);

		if($located) {
			if( $shortcode_ob_start ) {
				ob_start();
				include($located);
				$output_html = ob_get_clean();
			} else {
				include($located);
			}
		}

		return $output_html;
	}
}

if(!function_exists('mascot_core_ereco_elementor_locate_template')) {
	/**
	 * Retrieve the name of the highest priority template file that exists.
	 *
	 * Searches in the MASCOT_STYLESHEET_DIR before MASCOT_TEMPLATE_DIR
	 * so that themes which inherit from a parent theme can just overload one file.
	 *
	 * @param string|array $template_names Template file(s) to search for, in order.
	 * @return string The template filename if one is located.
	 */
	function mascot_core_ereco_elementor_locate_template($template_names) {
		$located = '';
		foreach ( (array) $template_names as $template_name ) {
			if ( !$template_name ) {
				continue;
			}
			if ( file_exists(MASCOT_CORE_ERECO_ELEMENTOR_ABS_PATH . '/' . $template_name)) {
				$located = MASCOT_CORE_ERECO_ELEMENTOR_ABS_PATH . '/' . $template_name;
				break;
			}
		}
		return $located;
	}
}


if ( ! function_exists('mascot_core_ereco_elementor_get_yes_no_select_array') ) {
	/**
	 * Returns array of yes no
	 * @return array
	 */
	function mascot_core_ereco_elementor_get_yes_no_select_array($enable_default = true, $set_yes_to_be_first = false ) {
		$select_options = array();

		if ( $enable_default ) {
			$select_options[''] = esc_html__( 'Default', 'mascot-core-elementor' );
		}

		if ( $set_yes_to_be_first ) {
			$select_options['yes'] = esc_html__( 'Yes', 'mascot-core-elementor' );
			$select_options['no']  = esc_html__( 'No', 'mascot-core-elementor' );
		} else {
			$select_options['no']  = esc_html__( 'No', 'mascot-core-elementor' );
			$select_options['yes'] = esc_html__( 'Yes', 'mascot-core-elementor' );
		}

		return $select_options;
	}
}
if( ! function_exists('mascot_core_ereco_elementor_add_elementor_widget_categories') ) {
		function mascot_core_ereco_elementor_add_elementor_widget_categories($elements_manager) {

			$elements_manager->add_category(
				'tm',
				[
					'title' => esc_html__('Mascot', 'mascot-core-elementor'),
					'icon' => 'fa fa-plug',
				]
			);

		}

		add_action('elementor/elements/categories_registered', 'mascot_core_ereco_elementor_add_elementor_widget_categories');
};



if(!function_exists('mascot_core_ereco_elementor_get_button_arraylist')) {
	/**
	 * Return Button Array List
	 */
	function mascot_core_ereco_elementor_get_button_arraylist( $control_object, $serial, $prefix = '', $btn_condition = false ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_design_style", [
							'label' => esc_html__( "Button Design Style", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => mascot_core_ereco_elementor_get_btn_design_style(),
							'default' => 'btn-theme-colored1',
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_design_style", [
							'label' => esc_html__( "Button Design Style", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => mascot_core_ereco_elementor_get_btn_design_style(),
							'default' => 'btn-theme-colored1',
						]
					);
				}
				break;

			case '2':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "button_size", [
							'label' => esc_html__( "Button Size", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => mascot_core_ereco_elementor_get_button_size(),
							'default' => '',
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "button_size", [
							'label' => esc_html__( "Button Size", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => mascot_core_ereco_elementor_get_button_size(),
							'default' => '',
						]
					);
				}
				break;

			case '3':
				if( $btn_condition ) {
					$control_object->add_responsive_control(
						$prefix . "button_alignment", [
							'label' => esc_html__( "Button Alignment", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => ereco_mascot_redux_text_alignment_elementor(),
							'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .btn-view-details' => 'text-align: {{VALUE}};'
							],
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_responsive_control(
						$prefix . "button_alignment", [
							'label' => esc_html__( "Button Alignment", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => ereco_mascot_redux_text_alignment_elementor(),
							'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .btn-view-details' => 'text-align: {{VALUE}};'
							],
						]
					);
				}
				break;

			case '4':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "button_hover_animation_effect", [
							'label' => esc_html__( "Animation Effect", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => array(
								''	=> 	esc_html__( 'None', 'mascot-core-elementor' ),
								'hvr-sweep-to-right'	=> 	esc_html__( 'Sweep To Right', 'mascot-core-elementor' ),
								'hvr-bounce-to-right'	=> 	esc_html__( 'Bounce To Right', 'mascot-core-elementor' ),
								'hvr-shutter-out-horizontal'	=> 	esc_html__( 'Shutter Out Horizontal', 'mascot-core-elementor' ),
								'btn-arrow-hover-animation'	=> 	esc_html__( 'Arrow Hover Animation', 'mascot-core-elementor' ),
							),
							'default' => '',
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "button_hover_animation_effect", [
							'label' => esc_html__( "Animation Effect", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => array(
								''	=> 	esc_html__( 'None', 'mascot-core-elementor' ),
								'hvr-sweep-to-right'	=> 	esc_html__( 'Sweep To Right', 'mascot-core-elementor' ),
								'hvr-bounce-to-right'	=> 	esc_html__( 'Bounce To Right', 'mascot-core-elementor' ),
								'hvr-shutter-out-horizontal'	=> 	esc_html__( 'Shutter Out Horizontal', 'mascot-core-elementor' ),
								'btn-arrow-hover-animation'	=> 	esc_html__( 'Arrow Hover Animation', 'mascot-core-elementor' ),
							),
							'default' => '',
						]
					);
				}
				break;

			case '5':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_class", [
							'label' => esc_html__( "Custom CSS Class", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::TEXT,
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_class", [
							'label' => esc_html__( "Custom CSS Class", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::TEXT,
						]
					);
				}
				break;

			case '6':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_outlined", [
							'label' => esc_html__( "Make Button Outlined", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_outlined", [
							'label' => esc_html__( "Make Button Outlined", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
						]
					);
				}
				break;

			case '7':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_round", [
							'label' => esc_html__( "Make Button Round", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_round", [
							'label' => esc_html__( "Make Button Round", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
						]
					);
				}
				break;

			case '8':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_flat", [
							'label' => esc_html__( "Make Button Flat", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_flat", [
							'label' => esc_html__( "Make Button Flat", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
						]
					);
				}
				break;

			case '9':
				if( $btn_condition ) {
					$control_object->add_responsive_control(
						$prefix . "btn_block", [
							'label' => esc_html__( "Button Fullwidth (Block Level Button)", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}} .btn-view-details' => 'display:grid;'
							],
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_responsive_control(
						$prefix . "btn_block", [
							'label' => esc_html__( "Button Fullwidth (Block Level Button)", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}} .btn-view-details' => 'display:grid;'
							],
						]
					);
				}
				break;

			case '10':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_threed_effect", [
							'label' => esc_html__( "3D Effect", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_threed_effect", [
							'label' => esc_html__( "3D Effect", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
						]
					);
				}
				break;

			case '11':
				if( $btn_condition ) {
					$control_object->add_control(
						$prefix . "btn_gradient_effect", [
							'label' => esc_html__( "Gradient Effect", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_control(
						$prefix . "btn_gradient_effect", [
							'label' => esc_html__( "Gradient Effect", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
						]
					);
				}
				break;

			case '12':
				if( $btn_condition ) {
					$control_object->add_responsive_control(
						$prefix . "btn_link_color", [
							'label' => esc_html__( "Link Color", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}} .btn-view-details a' => 'color: {{VALUE}};'
							],
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_responsive_control(
						$prefix . "btn_link_color", [
							'label' => esc_html__( "Link Color", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}} .btn-view-details a' => 'color: {{VALUE}};'
							],
						]
					);
				}
				break;

			case '13':
				if( $btn_condition ) {
					$control_object->add_responsive_control(
						$prefix . "btn_link_color_hover", [
							'label' => esc_html__( "Link Color on Hover", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}}:hover .btn-view-details a' => 'color: {{VALUE}};'
							],
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_responsive_control(
						$prefix . "btn_link_color_hover", [
							'label' => esc_html__( "Link Color on Hover", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}}:hover .btn-view-details a' => 'color: {{VALUE}};'
							],
						]
					);
				}
				break;

			case '14':
				if( $btn_condition ) {
					$control_object->add_responsive_control(
						$prefix . "btn_bg_color", [
							'label' => esc_html__( "Link Background Color", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}} .btn-view-details a' => 'background-color: {{VALUE}};'
							],
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_responsive_control(
						$prefix . "btn_bg_color", [
							'label' => esc_html__( "Link Background Color", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}} .btn-view-details a' => 'background-color: {{VALUE}};'
							],
						]
					);
				}
				break;

			case '15':
				if( $btn_condition ) {
					$control_object->add_responsive_control(
						$prefix . "btn_bg_color_hover", [
							'label' => esc_html__( "Link Background Color on Hover", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}}:hover .btn-view-details a' => 'background-color: {{VALUE}};'
							],
							'condition' => [
								$prefix . 'show_view_details_button' => array('yes')
							]
						]
					);
				} else {
					$control_object->add_responsive_control(
						$prefix . "btn_bg_color_hover", [
							'label' => esc_html__( "Link Background Color on Hover", 'mascot-core-elementor' ),
							'type' => \Elementor\Controls_Manager::COLOR,
                			'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'selectors' => [
								'{{WRAPPER}}:hover .btn-view-details a' => 'background-color: {{VALUE}};'
							],
						]
					);
				}
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}




if(!function_exists('mascot_core_ereco_elementor_get_button_text_color_typo_arraylist')) {
	/**
	 * Return Button Text Colro Typo Array List
	 */
	function mascot_core_ereco_elementor_get_button_text_color_typo_arraylist( $control_object, $serial) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					'button_bg_custom_color_options',
					[
						'label' => esc_html__( 'Background Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				$control_object->add_responsive_control(
					'button_bg_custom_color', [
						'label' => esc_html__( "Background Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn' => 'background-color: {{VALUE}};'
						]
					]
				);
				$control_object->add_responsive_control(
					'button_bg_color_hover', [
						'label' => esc_html__( "Background Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn:hover:before,{{WRAPPER}} .btn:focus:before' => 'background-color: {{VALUE}};'
						]
					]
				);
				$control_object->add_responsive_control(
					'button_bg_theme_colored', [
						'label' => esc_html__( "Background Theme Colored", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .btn' => 'background-color: var(--theme-color{{VALUE}});'
						],
					]
				);
				$control_object->add_responsive_control(
					'button_bg_theme_colored_hover', [
						'label' => esc_html__( "Background Theme Colored (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .btn:hover:before, {{WRAPPER}} .btn:hover:before' => 'background-color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;
			case '2':
				$control_object->add_control(
					'button_text_color_options',
					[
						'label' => esc_html__( 'Text Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				$control_object->add_responsive_control(
					'button_text_color', [
						'label' => esc_html__( "Button Text Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn' => 'color: {{VALUE}};'
						]
					]
				);
				$control_object->add_responsive_control(
					'button_text_color_hover', [
						'label' => esc_html__( "Button Text Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn:hover' => 'color: {{VALUE}};',
							'{{WRAPPER}} .btn:focus' => 'color: {{VALUE}};',
						]
					]
				);
				break;
			case '3':
				$control_object->add_responsive_control(
					'button_text_theme_colored', [
						'label' => esc_html__( "Button Text Theme Colored", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .btn' => 'color: var(--theme-color{{VALUE}});'
						],
					]
				);
				$control_object->add_responsive_control(
					'button_text_theme_colored_hover', [
						'label' => esc_html__( "Button Text Theme Colored (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .btn:hover' => 'color: var(--theme-color{{VALUE}});',
							'{{WRAPPER}} .btn:focus' => 'color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;
			case '4':
				$control_object->add_group_control(
					\Elementor\Group_Control_Typography::get_type(), [
						'name' => 'button_text_typography',
						'label' => esc_html__( 'Button Text Typography', 'mascot-core-elementor' ),
						'selector' => '{{WRAPPER}} .btn',
					]
				);
				break;
			case '5':
				$control_object->add_control(
					'btn_border_options',
					[
						'label' => esc_html__( 'Border Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				$control_object->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'btn_border',
						'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
						'selector' => '{{WRAPPER}} .btn',
					]
				);
				$control_object->add_responsive_control(
					'btn_border_radius',
					[
						'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn' => 'border-radius: {{VALUE}};'
						]
					]
				);
				$control_object->add_group_control(
					\Elementor\Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'btn_boxshadow',
						'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
						'selector' => '{{WRAPPER}} .btn',
					]
				);
				$control_object->add_group_control(
					\Elementor\Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'btn_boxshadow_hover',
						'label' => esc_html__( 'Box Shadow(Hover)', 'mascot-core-elementor' ),
						'selector' => '{{WRAPPER}} .btn:hover',
					]
				);
				$control_object->add_control(
					'btn_padding_options',
					[
						'label' => esc_html__( 'Padding Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				$control_object->add_responsive_control(
					'btn_padding',
					[
						'label' => esc_html__( 'Button Padding', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				break;
			case '6':
				$control_object->add_control(
					'button_icon_color_options',
					[
						'label' => esc_html__( 'Icon Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				$control_object->add_responsive_control(
					'button_icon_color', [
						'label' => esc_html__( "Button Icon Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn:after, {{WRAPPER}} .btn:before' => 'color: {{VALUE}};'
						]
					]
				);
				break;
			case '7':
				$control_object->add_responsive_control(
					'button_icon_color_hover', [
						'label' => esc_html__( "Button Icon Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .btn:hover:after, {{WRAPPER}} .btn:hover:before' => 'color: {{VALUE}};'
						]
					]
				);
				break;
			case '8':
				$control_object->add_responsive_control(
					'button_icon_theme_colored', [
						'label' => esc_html__( "Button Icon Theme Colored", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .btn:after, {{WRAPPER}} .btn:before' => 'color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;
			case '9':
				$control_object->add_responsive_control(
					'button_icon_theme_colored_hover', [
						'label' => esc_html__( "Button Icon Theme Colored (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
                		'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'default' => '',
						'selectors' => [
							'{{WRAPPER}} .btn:hover:after, {{WRAPPER}} .btn:hover:before' => 'color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}

if(!function_exists('mascot_core_ereco_elementor_get_viewdetails_button_arraylist')) {
	/**
	 * Return Button Show Array List
	 */
	function mascot_core_ereco_elementor_get_viewdetails_button_arraylist( $control_object, $serial, $btn_text = '', $prefix = '', $std = 'true' ) {
		$array = array();
		if( $btn_text == '' ) $btn_text = esc_html__( 'View Details', 'mascot-core-elementor' );

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					$prefix . "show_view_details_button", [
						'label' => sprintf( esc_html__( "Show %s Button", 'mascot-core-elementor' ), $btn_text ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
					]
				);
				break;

			case '2':
				$control_object->add_control(
					$prefix . "view_details_button_text", [
						'label' => sprintf( esc_html__( "%s Button Text", 'mascot-core-elementor' ), $btn_text ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html( $btn_text ),
						'condition' => [
							$prefix . 'show_view_details_button' => array('yes')
						]
					]
				);
				break;

			default:
				# code...
				break;
		}
	}
}

if(!function_exists('mascot_core_ereco_elementor_font_style_list')) {
	/**
	 * Font Style List
	 */
	function mascot_core_ereco_elementor_font_style_list() {
		$font_style_list = array(
			''	=>	esc_html__( 'Normal', 'mascot-core-elementor'),
			'italic'	=>	esc_html__( 'Italic', 'mascot-core-elementor')
		);
		return $font_style_list;
	}
}

if(!function_exists('mascot_core_ereco_elementor_font_weight_list')) {
	/**
	 * Font weight List
	 */
	function mascot_core_ereco_elementor_font_weight_list() {
		$font_weight_list = array(
			''			=>	esc_html__( 'Default', 'mascot-core-elementor'),
			'100'   => '100',
			'200'   => '200',
			'300'   => '300',
			'400'   => '400',
			'500'   => '500',
			'600'   => '600',
			'700'   => '700',
			'800'   => '800',
		);
		return $font_weight_list;
	}
}

if(!function_exists('mascot_core_ereco_elementor_text_transform_list')) {
	/**
	 * Text Transform List
	 */
	function mascot_core_ereco_elementor_text_transform_list() {
		$text_transform_list = array(
			''	=>	esc_html__( 'Default', 'mascot-core-elementor'),
			'none'	=>	esc_html__( 'None', 'mascot-core-elementor'),
			'capitalize'	=>	esc_html__( 'Capitalize', 'mascot-core-elementor'),
			'uppercase'	=>	esc_html__( 'Uppercase', 'mascot-core-elementor'),
			'lowercase'	=>	esc_html__( 'Lowercase', 'mascot-core-elementor'),
			'initial'	=>	esc_html__( 'Initial', 'mascot-core-elementor'),
			'inherit'	=>	esc_html__( 'Inherit', 'mascot-core-elementor')
		);
		return $text_transform_list;
	}
}

if(!function_exists('mascot_core_ereco_elementor_get_btn_design_style')) {
	/**
	 * Return Design Style
	 */
	function mascot_core_ereco_elementor_get_btn_design_style() {
		$array = array(
			'btn-plain-text'	=>	esc_html__( 'Plain Text', 'mascot-core-elementor'),
			'btn-plain-text-with-arrow'	=>	esc_html__( 'Plain Text + Arrow Left', 'mascot-core-elementor'),
			'btn-plain-text-with-arrow-right'	=>	esc_html__( 'Plain Text + Arrow Right', 'mascot-core-elementor'),
			'btn-modern-white'	=>	esc_html__( 'Button Modern White', 'mascot-core-elementor'),
			'btn-modern-theme-colored'	=>	esc_html__( 'Button Modern Theme Colored', 'mascot-core-elementor'),
			'btn-primary'	=>	esc_html__( 'Button Primary', 'mascot-core-elementor'),
			'btn-secondary'	=>	esc_html__( 'Button Secondary', 'mascot-core-elementor'),
			'btn-success'	=>	esc_html__( 'Button Success', 'mascot-core-elementor'),
			'btn-danger'	=>	esc_html__( 'Button Danger', 'mascot-core-elementor'),
			'btn-warning'	=>	esc_html__( 'Button Warning', 'mascot-core-elementor'),
			'btn-info'	=>	esc_html__( 'Button Info', 'mascot-core-elementor'),
			'btn-light'	=>	esc_html__( 'Button Light', 'mascot-core-elementor'),
			'btn-dark'	=>	esc_html__( 'Button Dark', 'mascot-core-elementor'),
			'btn-gray'	=>	esc_html__( 'Button Gray', 'mascot-core-elementor'),
		);

		$array_theme_color = array();
		for ($i=1; $i <= ereco_mascot_number_of_theme_colors(); $i++) {
			$array_theme_color[ 'btn-theme-colored' . $i ] = esc_html__( 'Button Theme Colored', 'mascot-core-elementor') . ' ' . $i;
		}

		$array = array_merge($array_theme_color, $array);
		return $array;
	}
}

if(!function_exists('mascot_core_ereco_elementor_get_button_size')) {
	/**
	 * Return Button Size
	 */
	function mascot_core_ereco_elementor_get_button_size() {
		$array = array(
			''	=>	esc_html__( 'Default', 'mascot-core-elementor'),
			'btn-lg'	=>	esc_html__( 'Large', 'mascot-core-elementor'),
			'btn-sm'	=>	esc_html__( 'Small', 'mascot-core-elementor'),
			'btn-xs'	=>	esc_html__( 'Extra Small', 'mascot-core-elementor')
		);
		return $array;
	}
}


if ( ! function_exists( 'mascot_core_ereco_elementor_get_available_image_sizes' ) ) {
	/**
	 * Get information about available image sizes
	 */
	function mascot_core_ereco_elementor_get_available_image_sizes() {
		$size = array();
		$available_image_sizes = ereco_mascot_get_available_image_sizes();

		// Create the full array with sizes and crop info
		foreach( $available_image_sizes as $key => $value ) {
			$sizes[ $key ]	=	$key . ( ($value['crop'] == 1) ? ' - cropped' : '') . ' - (' .$value['width'] . 'x' . $value['height'] . ')';
		}
		return $sizes;
	}
}




if(!function_exists('mascot_core_ereco_elementor_get_owl_carousel_arraylist')) {
	/**
	 * Return Owl Carousel Array List
	 */
	function mascot_core_ereco_elementor_get_owl_carousel_arraylist( $control_object, $serial, $prefix = '', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					$prefix . "carousel_autoplay",[
						'label' => esc_html__( "Autoplay", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'yes',
						'condition' => $dependency
					]
				);
				break;

			case '2':
				$control_object->add_control(
					$prefix . "carousel_loop", [
						'label' => esc_html__( "Loop", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'yes',
						'condition' => $dependency
					]
				);
				break;

			case '3':
				$control_object->add_control(
					$prefix . "animation_speed", [
						'label' => esc_html__( "Autoplay Interval Timeout", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						"description" => esc_html__( "Autoplay interval timeout in milliseconds. Default value is 6000", 'mascot-core-elementor' ),
						'default' => '6000',
						'condition' => $dependency
					]
				);
				break;

			case '4':
				$control_object->add_control(
					$prefix . "smart_speed", [
						'label' => esc_html__( "Smart Speed", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						"description" => esc_html__( "Autoplay Smart Speed in milliseconds. Default value is 300", 'mascot-core-elementor' ),
						'default' => '300',
						'condition' => $dependency
					]
				);
				break;

			case '5':
				$control_object->add_control(
					$prefix . "margin", [
						'label' => esc_html__( "Margin", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						"description" => esc_html__( "Margin between two slides. Default 30", 'mascot-core-elementor' ),
						'default' => '30',
						'condition' => $dependency
					]
				);
				break;

			case '6':
				$control_object->add_control(
					$prefix . "stagepadding", [
						'label' => esc_html__( "Stage Padding", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						"description" => esc_html__( "Stage padding option adds left and right padding style onto stage-wrapper. Example: 50", 'mascot-core-elementor' ),
						'condition' => $dependency
					]
				);
				break;

			case '7':
				$control_object->add_control(
					$prefix . "laptop", [
						'label' => esc_html__( "Responsive Slider Columns in Laptop / Small Desktop", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						"description" => esc_html__( "Number of Visible Sliding Items in Laptop or Small Desktop", 'mascot-core-elementor' ),
						'condition' => $dependency
					]
				);
				break;

			case '8':
				$control_object->add_control(
					$prefix . "tablet", [
						'label' => esc_html__( "Responsive Slider Columns in Tablet", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'condition' => $dependency
					]
				);
				break;

			case '9':
				$control_object->add_control(
					$prefix . "center", [
						'label' => esc_html__( "Carousel Center Feature?", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						"description" => esc_html__( "This feature adds a class called 'center' into the middle image. Keep in mind that dots are not working here like a pagination", 'mascot-core-elementor' ),
						'condition' => $dependency
					]
				);
				break;

			case '10':
				$control_object->add_control(
					$prefix . "focused-center-image", [
						'label' => esc_html__( "Focused Center Image?", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						"description" => esc_html__( "Focus Center Image and Blur Other Images", 'mascot-core-elementor' ),
						'condition' => [
							'center' => array('yes')
						]
					]
				);
				break;

			case '11':
				$control_object->add_control(
					$prefix . "zoomin-center-image", [
						'label' => esc_html__( "ZoomIn Center Image?", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						'condition' => [
							'center' => array('yes')
						]
					]
				);
				break;

			case '12':
				$control_object->add_control(
					$prefix . "owl-stage-outer-overflow-visible", [
						'label' => esc_html__( "Owl Outer Stage Overflow Visible?", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						'selectors' => [
							'{{WRAPPER}} .owl-stage-outer' => 'overflow:visible',
						]
					]
				);
				break;

			case '13':
				$control_object->add_control(
					$prefix . "owl-stage-parent-wrapper-overflow-hidden", [
						'label' => esc_html__( "Make Parent Wrapper Overflow Hidden?", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						'selectors' => [
							'{{WRAPPER}} .elementor-widget-container' => 'overflow:hidden',
						]
					]
				);
				break;

			case '14':
				$control_object->add_responsive_control(
					$prefix . 'carousel_item_margin',
					[
						'label' => esc_html__( 'Carousel Item Margin', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-item > div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
						'condition' => $dependency
					]
				);
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}




if(!function_exists('mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist')) {
	/**
	 * Return Owl Carousel Nav Array List
	 */
	function mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $control_object, $serial, $prefix = '', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					$prefix . "show_navigation", [
						'label' => esc_html__( "Show Arrow Navigation", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'yes',
						'condition' => $dependency
					]
				);
				break;

			case '2':
				$control_object->add_responsive_control(
					$prefix . 'arrow_display_visibility',
					[
						'label' => esc_html__( "Visibility Responsive (Show/Hide)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => [
							'block' =>  esc_html__( 'Show', 'mascot-core-elementor' ),
							'none'  =>  esc_html__( 'Hide', 'mascot-core-elementor' ),
						],
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'display: {{VALUE}};'
						]
					]
				);
				break;

			case '3':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_options',
					[
						'label' => esc_html__( 'Arrow Position', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_navigation' => array('yes')
						],
					]
				);
				break;

			case '4':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_pos_top',
					[
						'label' => esc_html__( "Position - Top (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'top: {{VALUE}};'
						],
					]
				);
				break;

			case '5':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_pos_right',
					[
						'label' => esc_html__( "Position - Right (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'right: {{VALUE}};'
						],
					]
				);
				break;

			case '6':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_pos_bottom',
					[
						'label' => esc_html__( "Position - Bottom (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'bottom: {{VALUE}};'
						],
					]
				);
				break;

			case '7':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_pos_left',
					[
						'label' => esc_html__( "Position - Left (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'left: {{VALUE}};'
						],
					]
				);
				break;

			case '8':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_pos_center', [
						'label' => esc_html__( "Arrow Position Horizontal Center", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'left: 50% !important; right: auto !important; transform: translate(-50%, -50%);'
						],
					]
				);
				break;

			case '9':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_separated_arrow', [
						'label' => esc_html__( "Make Arrow Separated in Left Right", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav' => 'position:initial;',
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'top:50%;position:absolute;transform:translateY(-50%);',
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-prev' => 'left:0;',
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-next' => 'left:auto;right:0;',
						],
					]
				);
				break;

			case '10':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_separated_arrow_left',
					[
						'label' => esc_html__( "Arrow Left Position", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-prev' => 'left: {{VALUE}};'
						],
						'condition' => [
							$prefix . 'carousel_arrow_nav_separated_arrow' => array('yes')
						],
					]
				);
				break;

			case '11':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_separated_arrow_right',
					[
						'label' => esc_html__( "Arrow Right Position", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav .owl-next' => 'right: {{VALUE}};'
						],
						'condition' => [
							$prefix . 'carousel_arrow_nav_separated_arrow' => array('yes')
						],
					]
				);
				break;

			case '12':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_bg_options',
					[
						'label' => esc_html__( 'Arrow BG Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_navigation' => array('yes')
						],
					]
				);
				break;

			case '13':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_bg_color',
					[
						'label' => esc_html__( "Arrow BG Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'background-color: {{VALUE}};'
						],
					]
				);
				break;

			case '14':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_bg_color_hover',
					[
						'label' => esc_html__( "Arrow BG Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button:hover' => 'background-color: {{VALUE}};'
						],
					]
				);
				break;

			case '15':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_bg_theme_color',
					[
						'label' => esc_html__( "Arrow BG Theme Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'background-color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			case '16':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_bg_theme_color_hover',
					[
						'label' => esc_html__( "Arrow BG Theme Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button:hover' => 'background-color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			case '17':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_text_options',
					[
						'label' => esc_html__( 'Arrow Text Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_navigation' => array('yes')
						],
					]
				);
				break;

			case '18':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_text_color',
					[
						'label' => esc_html__( "Arrow Text Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'color: {{VALUE}};'
						],
					]
				);
				break;

			case '19':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_text_color_hover',
					[
						'label' => esc_html__( "Arrow Text Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button:hover' => 'color: {{VALUE}};'
						],
					]
				);
				break;

			case '20':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_text_theme_color',
					[
						'label' => esc_html__( "Arrow Text Theme Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			case '21':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_text_theme_color_hover',
					[
						'label' => esc_html__( "Arrow Text Theme Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button:hover' => 'color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			case '22':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_size_options',
					[
						'label' => esc_html__( 'Arrow Size & Border', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_navigation' => array('yes')
						],
					]
				);
				break;

			case '23':
				$control_object->add_responsive_control(
					'carousel_arrow_nav_widthheight',
					[
						'label' => esc_html__( "Dimension (Width and Height)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'width: {{VALUE}}; height: {{VALUE}};',
						]
					]
				);
				break;

			case '24':
				$control_object->add_responsive_control(
					'carousel_arrow_nav_border_radius',
					[
						'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'border-radius: {{VALUE}};'
						]
					]
				);
				break;

			case '25':
				$control_object->add_group_control(
					\Elementor\Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'carousel_arrow_nav_box_shadow',
						'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selector' => '{{WRAPPER}} .owl-carousel .owl-nav button',
					]
				);
				break;

			case '26':
				$control_object->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'icon_typography',
						'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selector' => '{{WRAPPER}} .owl-carousel .owl-nav button',
					]
				);
				break;

			case '27':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_opacity_options',
					[
						'label' => esc_html__( 'Arrow Opacity', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_navigation' => array('yes')
						],
					]
				);
				break;

			case '28':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_opacity',
					[
						'label' => esc_html__( 'Opacity', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'Value should be any floating value between 0 to 1. Example: 0.7', 'mascot-core-elementor' ),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button' => 'opacity: {{VALUE}};'
						]
					]
				);
				break;

			case '29':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_nav_opacity_hover',
					[
						'label' => esc_html__( 'Opacity (hover)', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'Value should be any floating value between 0 to 1. Example: 0.7', 'mascot-core-elementor' ),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_navigation' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-nav button:hover' => 'opacity: {{VALUE}};'
						]
					]
				);
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}




if(!function_exists('mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist')) {
	/**
	 * Return Owl Carousel Nav Array List
	 */
	function mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $control_object, $serial, $prefix = '', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_xl_options',
					[
						'label' => esc_html__( 'Arrow Position - Breakpoints XL (1200px -> 1399.98px)', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				break;

			case '2':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_xl_top',
					[
						'label' => esc_html__( "Position - Top", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width: 1200px) and (max-width: 1399.98px){ {{WRAPPER}} .owl-carousel .owl-nav' => 'top: {{VALUE}}}'
						],
					]
				);
				break;

			case '3':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_xl_right',
					[
						'label' => esc_html__( "Position - Right", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width: 1200px) and (max-width: 1399.98px){  {{WRAPPER}} .owl-carousel .owl-nav' => 'right: {{VALUE}}}'
						],
					]
				);
				break;

			case '4':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_xl_bottom',
					[
						'label' => esc_html__( "Position - Bottom", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width: 1200px) and (max-width: 1399.98px) {  {{WRAPPER}} .owl-carousel .owl-nav' => 'bottom: {{VALUE}}}'
						],
					]
				);
				break;

			case '5':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_xl_left',
					[
						'label' => esc_html__( "Position - Left", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width:1200px) and (max-width: 1399.98px) {  {{WRAPPER}} .owl-carousel .owl-nav' => 'left: {{VALUE}}}'
						],
					]
				);
				break;

				
			case '6':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_md_options',
					[
						'label' => esc_html__( 'Arrow Position - Breakpoints MD (992px -> 1199.98px)', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
					]
				);
				break;

			case '7':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_md_top',
					[
						'label' => esc_html__( "Position - Top", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width: 992px) and (max-width: 1199.98px){ {{WRAPPER}} .owl-carousel .owl-nav' => 'top: {{VALUE}}}'
						],
					]
				);
				break;

			case '8':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_md_right',
					[
						'label' => esc_html__( "Position - Right", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width: 992px) and (max-width: 1199.98px){  {{WRAPPER}} .owl-carousel .owl-nav' => 'right: {{VALUE}}}'
						],
					]
				);
				break;

			case '9':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_md_bottom',
					[
						'label' => esc_html__( "Position - Bottom", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width: 992px) and (max-width: 1199.98px) {  {{WRAPPER}} .owl-carousel .owl-nav' => 'bottom: {{VALUE}}}'
						],
					]
				);
				break;

			case '10':
				$control_object->add_control(
					$prefix . 'carousel_arrow_nav_pos_md_left',
					[
						'label' => esc_html__( "Position - Left", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'selectors' => [
							'@media (min-width:992px) and (max-width: 1199.98px) {  {{WRAPPER}} .owl-carousel .owl-nav' => 'left: {{VALUE}}}'
						],
					]
				);
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}




if(!function_exists('mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist')) {
	/**
	 * Return Owl Carousel Bullets/Dots List
	 */
	function mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $control_object, $serial, $prefix = '', $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					$prefix . "show_bullets",[
						'label' => esc_html__( "Show Bullets/Dots Navigation", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						'condition' => $dependency
					]
				);
				break;

			case '2':
				$control_object->add_responsive_control(
					$prefix . 'dots_display_visibility',
					[
						'label' => esc_html__( "Visibility Responsive (Show/Hide)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => [
							'block' =>  esc_html__( 'Show', 'mascot-core-elementor' ),
							'none'  =>  esc_html__( 'Hide', 'mascot-core-elementor' ),
						],
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots' => 'display: {{VALUE}};'
						]
					]
				);
				break;

			case '3':
				$control_object->add_control(
					$prefix . 'carousel_arrow_dots_pos_options',
					[
						'label' => esc_html__( 'Bullets/Dots Position', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_bullets' => array('yes')
						],
					]
				);
				break;

			case '4':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_pos_top',
					[
						'label' => esc_html__( "Position - Top (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots' => 'top: {{VALUE}};'
						],
					]
				);
				break;

			case '5':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_pos_right',
					[
						'label' => esc_html__( "Position - Right (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots' => 'right: {{VALUE}};'
						],
					]
				);
				break;

			case '6':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_pos_bottom',
					[
						'label' => esc_html__( "Position - Bottom (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots' => 'bottom: {{VALUE}};'
						],
					]
				);
				break;

			case '7':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_pos_left',
					[
						'label' => esc_html__( "Position - Left (px)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots' => 'left: {{VALUE}};'
						],
					]
				);
				break;

			case '8':
				$control_object->add_control(
					$prefix . 'carousel_arrow_dots_pos_center', [
						'label' => esc_html__( "Dots Position Horizontal Center", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots' => 'left: 50%; transform: translate(-50%, -50%);'
						],
					]
				);
				break;

			case '9':
				$control_object->add_control(
					$prefix . 'carousel_arrow_dots_bg_options',
					[
						'label' => esc_html__( 'Bullets/Dots BG Options', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_bullets' => array('yes')
						],
					]
				);
				break;

			case '10':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_bg_color',
					[
						'label' => esc_html__( "BG Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'background-color: {{VALUE}};'
						],
					]
				);
				break;

			case '11':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_bg_color_hover',
					[
						'label' => esc_html__( "BG Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span' => 'background-color: {{VALUE}};',
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}};'
						],
					]
				);
				break;

			case '12':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_bg_theme_color',
					[
						'label' => esc_html__( "BG Theme Color", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'background-color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			case '13':
				$control_object->add_responsive_control(
					$prefix . 'carousel_arrow_dots_bg_theme_color_hover',
					[
						'label' => esc_html__( "BG Theme Color (Hover)", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => ereco_mascot_theme_color_list(),
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span' => 'background-color: var(--theme-color{{VALUE}});',
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span' => 'background-color: var(--theme-color{{VALUE}});'
						],
					]
				);
				break;

			case '14':
				$control_object->add_control(
					$prefix . 'carousel_arrow_dots_size_options',
					[
						'label' => esc_html__( 'Arrow Size & Border', 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::HEADING,
						'condition' => [
							'show_bullets' => array('yes')
						],
					]
				);
				break;

			case '15':
				$control_object->add_responsive_control(
					'carousel_arrow_dots_width',
					[
						'label' => esc_html__( "Width", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'width: {{VALUE}};',
						]
					]
				);
				break;

			case '16':
				$control_object->add_responsive_control(
					'carousel_arrow_dots_height',
					[
						'label' => esc_html__( "Height", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'height: {{VALUE}};',
						]
					]
				);
				break;

			case '17':
				$control_object->add_responsive_control(
					'carousel_arrow_dots_border_radius',
					[
						'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::TEXT,
						'devices' => [ 'desktop', 'tablet', 'mobile' ],
						'condition' => [
							'show_bullets' => array('yes')
						],
						'selectors' => [
							'{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span' => 'border-radius: {{VALUE}};'
						]
					]
				);
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}



if(!function_exists('mascot_core_ereco_elementor_get_cat_filter_arraylist')) {
	/**
	 * Return Category Filter Array List
	 */
	function mascot_core_ereco_elementor_get_cat_filter_arraylist( $control_object, $serial, $dependency = array() ) {
		$array = array();

		switch ( $serial ) {
			case '1':
				$control_object->add_control(
					"show_cat_filter", [
						'label' => esc_html__( "Show Category Filter?", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'no',
						'condition' => $dependency
					]
				);
				break;

			case '2':
				$control_object->add_control(
					'cat_filter_style', [
						'label' => esc_html__( "Filter Style", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => [
							'filter-style-1'	=>	esc_html__( 'Style 1', 'mascot-core-elementor' ),
							'filter-style-2'	=>	esc_html__( 'Style 2', 'mascot-core-elementor' ),
							'filter-style-3'	=>	esc_html__( 'Style 3', 'mascot-core-elementor' ),
							'filter-style-4'	=>	esc_html__( 'Style 4', 'mascot-core-elementor' ),
							'filter-style-5'	=>	esc_html__( 'Style 5', 'mascot-core-elementor' ),
							'filter-style-6'	=>	esc_html__( 'Style 6', 'mascot-core-elementor' ),
							'filter-style-7'	=>	esc_html__( 'Style 7', 'mascot-core-elementor' ),
							'filter-style-8'	=>	esc_html__( 'Style 8', 'mascot-core-elementor' ),
							'filter-style-9'	=>	esc_html__( 'Style 9', 'mascot-core-elementor' ),
							'filter-style-10'	=>	esc_html__( 'Style 10', 'mascot-core-elementor' ),
							'filter-style-11'	=>	esc_html__( 'Style 11', 'mascot-core-elementor' ),
							'filter-style-12'	=>	esc_html__( 'Style 12', 'mascot-core-elementor' ),
							'filter-style-13'	=>	esc_html__( 'Style 13', 'mascot-core-elementor' ),
							'filter-style-14'	=>	esc_html__( 'Style 14', 'mascot-core-elementor' ),
							'filter-style-15'	=>	esc_html__( 'Style 15', 'mascot-core-elementor' ),
							'filter-style-16'	=>	esc_html__( 'Style 16', 'mascot-core-elementor' ),
							'filter-style-flat'	=>	esc_html__( 'Style flat', 'mascot-core-elementor' )
						],
						'default' => 'filter-style-3',
						'condition' => [
							'show_cat_filter' => array('yes')
						]
					]
				);
				break;

			case '3':
				$control_object->add_control(
					'cat_filter_alignment', [
						'label' => esc_html__( "Filter Alignment", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => mascot_core_ereco_elementor_text_alignment_list(),
						'default' => 'filter-style-3',
						'condition' => [
							'show_cat_filter' => array('yes')
						]
					]
				);
				break;

			case '4':
				$control_object->add_control(
					'cat_filter_theme_colored', [
						'label' => esc_html__( "Filter Theme Colored", 'mascot-core-elementor' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => [
							'cat-filter-default'	=>	esc_html__( 'Default', 'mascot-core-elementor' ),
							'cat-filter-theme-colored1'	=>	esc_html__( 'Theme Color 1', 'mascot-core-elementor' ),
							'cat-filter-theme-colored2'	=>	esc_html__( 'Theme Color 2', 'mascot-core-elementor' )
						],
						'default' => 'cat-filter-default',
						'condition' => [
							'show_cat_filter' => array('yes')
						]
					]
				);
				break;

			default:
				# code...
				break;
		}

		return $array;
	}
}

if (!function_exists('mascot_core_ereco_elementor_shortcode_get_blog_post_format')) {
  /**
   * Return Shortcode Blog Post Format HTML
   */
  function mascot_core_ereco_elementor_shortcode_get_blog_post_format( $post_format = '', $params = array() ) {

    $format = $post_format ? : 'standard';
    $params['post_format'] = $format;

    //Produce HTML version by using the parameters (filename, variation, folder name, parameters)
    $html = mascot_core_ereco_elementor_get_shortcode_template_part( 'post-format', $format, 'blog/tpl/post-format', $params, true );
    return $html;
  }
}

if(!function_exists('mascot_core_ereco_elementor_get_animation_type')) {
	/**
	 * Return animation type
	 */
	function mascot_core_ereco_elementor_get_animation_type() {
		$array = array(
			''  =>  esc_html__( 'None', 'mascot-core-elementor' ),
			'tm-animation-floating'  =>  esc_html__( 'Floating Animation', 'mascot-core-elementor' ),
			'tm-animation-slide-horizontal'  =>  esc_html__( 'Horizontal Slide Animation', 'mascot-core-elementor' ),
			'tm-animation-scaling'  =>  esc_html__( 'Scaling Animation', 'mascot-core-elementor' ),
			'tm-animation-flicker'  =>  esc_html__( 'Flicker Animation', 'mascot-core-elementor' ),
			'tm-animation-spin'  =>  esc_html__( 'Spin Animation', 'mascot-core-elementor' ),

			'tm-animation-floating'	=>	esc_html__( 'Floating Animation', 'mascot-core-elementor' ),
			'tm-animation-slide-horizontal'	=>	esc_html__( 'Horizontal Slide Animation', 'mascot-core-elementor' ),
			'tm-animation-scaling'	=>	esc_html__( 'Scaling Animation', 'mascot-core-elementor' ),

			'tm-animation-flicker'	=>	esc_html__( 'Flicker Animation', 'mascot-core-elementor' ),
			'tm-animation-spin'	=>	esc_html__( 'Spin Animation', 'mascot-core-elementor' ),
			'tm-animation-rotated-half'	=>	esc_html__( 'Rotated Half Animation', 'mascot-core-elementor' ),
			'tm-animation-jump'	=>	esc_html__( 'Jump Animation', 'mascot-core-elementor' ),

			'tm-animation-run'	=>	esc_html__( 'Run Animation', 'mascot-core-elementor' ),
			'tm-animation-scale-right'	=>	esc_html__( 'Scale Right Animation', 'mascot-core-elementor' ),

			'tm-animation-random-animation1'	=>	esc_html__( 'Random Animation 1', 'mascot-core-elementor' ),
			'tm-animation-random-animation2'	=>	esc_html__( 'Random Animation 2', 'mascot-core-elementor' ),
			'tm-animation-random-animation3'	=>	esc_html__( 'Random Animation 3', 'mascot-core-elementor' ),
			'tm-animation-random-animation4'	=>	esc_html__( 'Random Animation 4', 'mascot-core-elementor' ),
			'tm-animation-random-animation5'	=>	esc_html__( 'Random Animation 5', 'mascot-core-elementor' )
		);
		return $array;
	}
}

if(!function_exists('mascot_core_ereco_elementor_text_alignment_list')) {
	/**
	 * Text Alignment List - Elementor
	 */
	function mascot_core_ereco_elementor_text_alignment_list() {
		$alignment_list = array(
			''	 	=> esc_html__( 'Default', 'mascot-core-elementor' ),
			'left'	 	=> esc_html__( 'Left', 'mascot-core-elementor' ),
			'center'   => esc_html__( 'Center', 'mascot-core-elementor' ),
			'right'	=> esc_html__( 'Right', 'mascot-core-elementor' ),
		);
		return $alignment_list;
	}
}




if(!function_exists('mascot_core_ereco_get_shortcode_snippet')) {
	function mascot_core_ereco_get_shortcode_snippet( $shortcode_object, $params ) {
		$atts = array();

		if ( empty( $shortcode_object ) || ! is_object( $shortcode_object ) ) {
			return '';
		}

		if ( ! empty( $params ) ) {
			foreach ( $params as $key => $value ) {
				if ( is_array( $value ) || 'shortcode_snippet' === $key ) {
					continue;
				}

				$atts[] = $key . '="' . esc_attr( $value ) . '"';
			}
		}

		return sprintf(
			'<textarea rows="3" readonly>[%s %s]</textarea>',
			$shortcode_object->get_name(),
			implode( ' ', $atts )
		);
	}
}




if(!function_exists('mascot_core_ereco_get_wpcf7_list')) {
    /**
     * Get Contact Form 7 [ if exists ]
     */
    function mascot_core_ereco_get_wpcf7_list()
    {
        $options = array();

        if (function_exists('wpcf7')) {
            $wpcf7_form_list = get_posts(array(
                'post_type' => 'wpcf7_contact_form',
                'showposts' => 999,
            ));
            $options[0] = esc_html__('Select a Contact Form', 'essential-addons-for-elementor-lite');
            if (!empty($wpcf7_form_list) && !is_wp_error($wpcf7_form_list)) {
                foreach ($wpcf7_form_list as $post) {
                    $options[$post->ID] = $post->post_title;
                }
            } else {
                $options[0] = esc_html__('Create a Form First', 'essential-addons-for-elementor-lite');
            }
        }
        return $options;
    }
}



if(!function_exists('mascot_core_ereco_isotope_gutter_list_elementor')) {
	/**
	 * Masorny Gutter list Elementor
	 */
	function mascot_core_ereco_isotope_gutter_list_elementor() {
		$gutter_list = array(
			'gutter' 		=>  esc_html__( 'Default', 'mascot-core-elementor' ),
			'gutter-0'		=>  '0',
			'gutter-2'  	=>  '2px',
			'gutter-5'  	=>  '5px',
			'gutter-10'  	=>  '10px',
			'gutter-15'  	=>  '15px',
			'gutter-20'  	=>  '20px',
			'gutter-30'  	=>  '30px',
			'gutter-40'  	=>  '40px',
			'gutter-50'  	=>  '50px',
			'gutter-60'  	=>  '60px',
		);
		return $gutter_list;
	}
}



if(!function_exists('mascot_core_ereco_disply_type_list_elementor')) {
	/**
	 * Display Property list Elementor
	 */
	function mascot_core_ereco_disply_type_list_elementor() {
		$list = array(
			'flex' => esc_html__('Flex', 'mascot-core-elementor'),
			'inline-flex' => esc_html__('Inline Flex', 'mascot-core-elementor'),
			'inherit' => esc_html__('Inherit', 'mascot-core-elementor'),
			'initial' => esc_html__('Initial', 'mascot-core-elementor'),
			'inline' => esc_html__('Inline', 'mascot-core-elementor'),
			'inline-block' => esc_html__('Inline Block', 'mascot-core-elementor'),
			'block' => esc_html__('Block', 'mascot-core-elementor'),
		);
		return $list;
	}
}



if(!function_exists('mascot_core_ereco_disply_flex_horizontal_align_elementor')) {
	/**
	 * Horizontal Align list Elementor
	 */
	function mascot_core_ereco_disply_flex_horizontal_align_elementor() {
		$list = array(
			'' => esc_html__( 'Default', 'mascot-core-elementor' ),
			'flex-start' => esc_html__( 'Start', 'mascot-core-elementor' ),
			'center' => esc_html__( 'Center', 'mascot-core-elementor' ),
			'flex-end' => esc_html__( 'End', 'mascot-core-elementor' ),
			'space-between' => esc_html__( 'Space Between', 'mascot-core-elementor' ),
			'space-around' => esc_html__( 'Space Around', 'mascot-core-elementor' ),
			'space-evenly' => esc_html__( 'Space Evenly', 'mascot-core-elementor' ),
		);
		return $list;
	}
}



if(!function_exists('mascot_core_ereco_disply_flex_vertical_align_elementor')) {
	/**
	 * Vertical Align list Elementor
	 */
	function mascot_core_ereco_disply_flex_vertical_align_elementor() {
		$list = array(
			'' => esc_html__( 'Default', 'mascot-core-elementor' ),
			'top' => esc_html__( 'Top', 'mascot-core-elementor' ),
			'center' => esc_html__( 'Middle', 'mascot-core-elementor' ),
			'bottom' => esc_html__( 'Bottom', 'mascot-core-elementor' ),
			'space-between' => esc_html__( 'Space Between', 'mascot-core-elementor' ),
			'space-around' => esc_html__( 'Space Around', 'mascot-core-elementor' ),
			'space-evenly' => esc_html__( 'Space Evenly', 'mascot-core-elementor' ),
		);
		return $list;
	}
}