<?php

if ( ! class_exists( 'MascotCoreElementorScriptsHandler' ) ) {
	/**
	 * Main theme class with configuration
	 */
	class MascotCoreElementorScriptsHandler {
		private static $instance;
		
		public function __construct() {
			
			// Include required files
			require_once( 'constants.php' );
			
			
			// Include theme's script and localize theme's main js script
			add_action( 'wp_enqueue_scripts', array( $this, 'include_js_scripts' ) );
			
			// Include theme's 3rd party plugins styles
			add_action( 'mascot_core_ereco_action_before_main_css', array( $this, 'include_plugins_styles' ) );

			// Include theme's 3rd party plugins scripts
			add_action( 'mascot_core_ereco_action_before_main_js', array( $this, 'include_plugins_scripts' ) );
			
		}
		
		public static function get_instance() {
			if ( ! ( self::$instance instanceof self ) ) {
				self::$instance = new self();
			}
			
			return self::$instance;
		}
		
		function include_js_scripts() {
			// JS dependency variable
			$main_js_dependency  = apply_filters( 'mascot_core_ereco_filter_main_js_dependency', array( 'jquery' ) );
			
			// Hook to include additional scripts before theme's main script
			do_action( 'mascot_core_ereco_action_before_main_js', $main_js_dependency );
			
			if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
				// Enqueue theme's main script
				wp_enqueue_script( 'ereco-custom-elementor', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/custom-elementor.js', $main_js_dependency, false, true );
			}
			
			// Hook to include additional scripts after theme's main script
			do_action( 'mascot_core_ereco_action_after_main_js' );
		}
		
		function include_plugins_styles() {
			
			// Enqueue 3rd party plugins style
			wp_enqueue_style( 'swiper', RIGHTCAUSE_ASSETS_ROOT . '/plugins/swiper/swiper.min.css' );
			wp_enqueue_style( 'magnific-popup', RIGHTCAUSE_ASSETS_ROOT . '/plugins/magnific-popup/magnific-popup.css' );
		}
		
		function include_plugins_scripts() {
			
			// JS dependency variables
			$js_3rd_party_dependency = apply_filters( 'mascot_core_ereco_filter_js_3rd_party_dependency', 'jquery' );
			
			// Enqueue 3rd party plugins script
			//wp_enqueue_script( 'swiper', RIGHTCAUSE_ASSETS_ROOT . '/plugins/swiper/swiper.min.js', array( $js_3rd_party_dependency ), false, true );
			wp_enqueue_script( 'menuzord', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/menuzord/js/menuzord.js', $js_3rd_party_dependency, false, true );
			wp_register_script( 'owl-carousel', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/owl.carousel.min.js', $js_3rd_party_dependency, false, true );
			wp_register_script( 'jquery-owl-filter', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/jquery.owl-filter.js', $js_3rd_party_dependency, false, true );
			wp_register_script( 'owl-carousel2-thumbs', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/owl.carousel2.thumbs.min.js', $js_3rd_party_dependency, false, true );
			wp_enqueue_style( 'owl-carousel', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/owl-carousel/assets/owl.carousel.min.css' );
			wp_enqueue_script( 'owl-carousel' );
			wp_enqueue_script( 'jquery-owl-filter' );
			wp_enqueue_script( 'owl-carousel2-thumbs' );


			
			wp_register_script( 'jquery-animatenumbers', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/jquery.animatenumbers.min.js', $js_3rd_party_dependency, false, true );
			wp_enqueue_script( 'jquery-animatenumbers' );
			wp_register_script( 'jquery-easypiechart', MASCOT_CORE_ERECO_ELEMENTOR_TEMPLATE_URI . '/assets/js/plugins/jquery.easypiechart.min.js', $js_3rd_party_dependency, false, true );
			wp_enqueue_script( 'jquery-easypiechart' );

		}
	}
	
	MascotCoreElementorScriptsHandler::get_instance();
}