<?php
namespace MascotCoreErecoElementor;

/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.2.0
 */
class Plugin {

	/**
	 * Instance
	 *
	 * @since 1.2.0
	 * @access private
	 * @static
	 *
	 * @var Plugin The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.2.0
	 * @access public
	 *
	 * @return Plugin An instance of the class.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * widget_scripts
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function widget_scripts() {
		wp_register_script( 'mascot-core-hellojs', plugins_url( '/assets/js/elementor-mascot.js', __FILE__ ), [ 'jquery' ], false, true );
	}

	public function widget_styles() {
		wp_enqueue_style( 'mascot-core-elementor-css', plugins_url( '/assets/css/elementor-mascot.css', __FILE__ ) );
	}

	/**
	 * Include Widgets files
	 *
	 * Load widgets files
	 *
	 * @since 1.2.0
	 * @access private
	 */
	private function include_widgets_files() {


		//cpt
		require_once( __DIR__ . '/cpt/clients/clients.php' );
		require_once( __DIR__ . '/cpt/gallery/gallery.php' );
		require_once( __DIR__ . '/cpt/projects/projects.php' );
		require_once( __DIR__ . '/cpt/services/services.php' );
		require_once( __DIR__ . '/cpt/staff/staff.php' );
		require_once( __DIR__ . '/cpt/testimonials/testimonials.php' );

		//Give Campaign
		if ( class_exists( 'Give' ) ) {
			require_once( __DIR__ . '/widgets/give-campaigns/give-campaigns.php' );
			require_once( __DIR__ . '/widgets/give-single-form-custom/give-single-form-custom.php' );
		}

		//header shortcodes
		require_once( __DIR__ . '/widgets/site-logo/site-logo.php' );
		require_once( __DIR__ . '/widgets/header-top-info/header-top-info.php' );
		require_once( __DIR__ . '/widgets/header-primary-nav/header-primary-nav.php' );
		require_once( __DIR__ . '/widgets/header-nav-side-icons/header-nav-side-icons.php' );

		//shortcodes
		require_once( __DIR__ . '/widgets/accordion/accordion.php' );
		require_once( __DIR__ . '/widgets/animated-layers/animated-layers.php' );
		require_once( __DIR__ . '/widgets/bg-angle-left-right/bg-angle-left-right.php' );
		require_once( __DIR__ . '/widgets/button/button.php' );
		require_once( __DIR__ . '/widgets/before-after-slider/before-after-slider.php' );
		require_once( __DIR__ . '/widgets/blog/blog.php' );
		require_once( __DIR__ . '/widgets/blog-list/blog-list.php' );
		require_once( __DIR__ . '/widgets/blockquote/blockquote.php' );
		require_once( __DIR__ . '/widgets/contact-form-7/contact-form-7.php' );
		require_once( __DIR__ . '/widgets/contact-list/contact-list.php' );
		require_once( __DIR__ . '/widgets/countdown-timer/countdown-timer.php' );
		require_once( __DIR__ . '/widgets/dropcaps/dropcaps.php' );
		require_once( __DIR__ . '/widgets/features-box/features-box.php' );
		require_once( __DIR__ . '/widgets/floating-objects/floating-objects.php' );
		require_once( __DIR__ . '/widgets/funfact-counter/funfact-counter.php' );
		require_once( __DIR__ . '/widgets/icon-box/icon-box.php' );
		require_once( __DIR__ . '/widgets/image-with-rotated-text/image-with-rotated-text.php' );
		require_once( __DIR__ . '/widgets/list/list.php' );
		require_once( __DIR__ . '/widgets/navigation-menu/navigation-menu.php' );
		require_once( __DIR__ . '/widgets/opening-hours/opening-hours.php' );
		require_once( __DIR__ . '/widgets/opening-hours-compressed/opening-hours-compressed.php' );
		require_once( __DIR__ . '/widgets/page-title/page-title.php' );
		require_once( __DIR__ . '/widgets/paroller-animation/paroller-animation.php' );
		require_once( __DIR__ . '/widgets/pie-chart/pie-chart.php' );
		require_once( __DIR__ . '/widgets/pricing-table/pricing-table.php' );
		require_once( __DIR__ . '/widgets/progress-bar/progress-bar.php' );
		require_once( __DIR__ . '/widgets/project-info/project-info.php' );
		require_once( __DIR__ . '/widgets/section-title/section-title.php' );
		require_once( __DIR__ . '/widgets/social-links/social-links.php' );
		require_once( __DIR__ . '/widgets/tabs/tabs.php' );
		require_once( __DIR__ . '/widgets/text-editor/text-editor.php' );
		require_once( __DIR__ . '/widgets/text-editor-advanced/text-editor-advanced.php' );
		require_once( __DIR__ . '/widgets/timeline/timeline.php' );
		if ( class_exists( 'Tribe__Events__Main' ) ) {
			require_once( __DIR__ . '/widgets/tribe-events/tribe-events.php' );
		}
		require_once( __DIR__ . '/widgets/unordered-list/unordered-list.php' );
		require_once( __DIR__ . '/widgets/video-popup/video-popup.php' );
		require_once( __DIR__ . '/widgets/working-steps/working-steps.php' );
		require_once( __DIR__ . '/widgets/wc-products/wc-products.php' );

		//slider widgets
		require_once( __DIR__ . '/widgets/slider-fullpage/slider-fullpage.php' );
		require_once( __DIR__ . '/widgets/slider-multiscroll/slider-multiscroll.php' );
		require_once( __DIR__ . '/widgets/slider-pagepiling/slider-pagepiling.php' );


		//current theme widgets
		require_once( __DIR__ . '/widgets-current-theme/block-header-nav-row/block-header-nav-row.php' );
		require_once( __DIR__ . '/widgets-current-theme/block-video/block-video.php' );
		require_once( __DIR__ . '/widgets-current-theme/block-features/block-features.php' );
		require_once( __DIR__ . '/widgets-current-theme/block-testimonial/block-testimonial.php' );


		//current theme widgets
		require_once( __DIR__ . '/widgets-shop/info-banner/info-banner.php' );
	}

	/**
	 * Register Widgets
	 *
	 * Register new Elementor widgets.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function register_widgets() {
		// Its is now safe to include Widgets files
		$this->include_widgets_files();

		//cpt
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Clients() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Gallery() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Projects() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Services() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Staff() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Testimonials() );

		//Give Campaign
		if ( class_exists( 'Give' ) ) {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Give_Campaigns() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Give_Single_Campaign() );
		}

		//header shortcodes
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Site_Logo() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Header_Top_Info() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Top_Primary_Nav() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Header_Nav_Side_Icons() );
		
		//shortcodes
		// Register Widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Accordion() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Animated_Layers() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Before_After_Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_BG_Aangle_Left_Right() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Blog() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Blog_List() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\BM_Elementor_blockquote() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Button() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Contact_Form_7() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Contact_List() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Countdown_Timer() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Dropcaps() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Features_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Floating_Objects() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Funfact_Counter() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Iconbox() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Image_With_Rotated_Text() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_List() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Navigation_Menu() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Opening_Hours() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Opening_Hours_Compressed() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Page_Title() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Paroller_Animation() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Pie_Chart() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Pricing_Table() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Progress_Bar() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_ProjectInfo() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Section_Title() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Social_Links() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Tabs() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_TextEditor() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_TextEditorAdvanced() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Timeline() );
		if ( class_exists( 'Tribe__Events__Main' ) ) {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Tribe_Events() );
		}
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Unordered_List() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Video_Popup() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Working_Steps() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_WP_Products() );
		
		//slider widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_FullPage() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_MultiScroll() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_PagePiling() );


		
		//current theme widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_Block_Header_Nav_Row() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_BlockVideo() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_BlockFeatures() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_BlockTestimonial() );



		//Shop Widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\TM_Elementor_InfoBanner() );
	}

	/**
	 *  Plugin class constructor
	 *
	 * Register plugin action hooks and filters
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function __construct() {

		// Register widget scripts
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'widget_scripts' ] );
		add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'widget_styles' ] );

		// Register widgets
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}
}

// Instantiate Plugin Class
Plugin::instance();

//elementor elements
require_once( __DIR__ . '/elementor-elements/loader.php' );