<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Block_Header_Nav_Row extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-block-header-nav-row';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Block - Header Nav Row Variation', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_css_class',
			[
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'design_style', [
				'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'current-theme1' => esc_html__( 'Current Theme Style1', 'mascot-core-elementor' ),
					'current-theme2' => esc_html__( 'Current Theme Style2', 'mascot-core-elementor' ),
					'current-theme3' => esc_html__( 'Current Theme Style3', 'mascot-core-elementor' ),
				],
				'default' => 'current-theme1'
			]
		);
		$this->end_controls_section();



		$this->start_controls_section(
			'logo_settings',
			[
				'label' => esc_html__( 'Logo Settings', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'logo',
			[
				'label' => esc_html__( "Upload Logo", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'logo_responsive',
			[
				'label' => esc_html__( "Upload Logo for Mobile", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'logo_width',
			[
				'label' => esc_html__( "Logo Width", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} .site-brand img' => 'width: {{VALUE}};',
					'header#header {{WRAPPER}} .site-brand img' => 'width: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'site_logo_alignment',
			[
				'label' => esc_html__( "Logo Alignment", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_text_alignment_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}} .menuzord-brand-parent' => 'text-align: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'logo_margin',
			[
				'label' => esc_html__( 'Logo Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .menuzord-brand, header#header {{WRAPPER}} .menuzord-brand' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'logo_padding',
			[
				'label' => esc_html__( 'Logo Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .menuzord-brand' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();







		$this->start_controls_section(
			'menu_settings',
			[
				'label' => esc_html__( 'Menu Settings', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'menu_item_vertical_padding',
			[
				'label' => esc_html__( 'Menu Item Vertical Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'@media (min-width: 1025px){ {{WRAPPER}} .menuzord-menu > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}}',
					'@media (min-width: 1025px){ header#header {{WRAPPER}} .menuzord-menu > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}}',
				],
			]
		);
		$this->add_responsive_control(
			'menu_item_leftright_padding',
			[
				'label' => esc_html__( 'Menu Item Left Right Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'@media (min-width: 1025px){ {{WRAPPER}} .menuzord-menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}}',
					'@media (min-width: 1025px){ header#header {{WRAPPER}} .menuzord-menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}}',
				],
			]
		);
		$this->add_control(
			'menu_item_color',
			[
				'label' => esc_html__( "Menu Item Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'@media (min-width: 1025px){ {{WRAPPER}} .menuzord-menu > li > a' => 'color: {{VALUE}}}',
					'@media (min-width: 1025px){ header#header {{WRAPPER}} .menuzord-menu > li > a' => 'color: {{VALUE}}}'
				]
			]
		);
		$this->add_control(
			'menu_item_color_hover',
			[
				'label' => esc_html__( "Menu Item Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'@media (min-width: 1025px){ {{WRAPPER}} .menuzord-menu > li:hover > a' => 'color: {{VALUE}} !important}',
					'@media (min-width: 1025px){ header#header {{WRAPPER}} .menuzord-menu > li:hover > a' => 'color: {{VALUE}} !important}'
				]
			]
		);
		$this->end_controls_section();











		$this->start_controls_section(
			'button_options', [
				'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( "Text", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "Read More", 'mascot-core-elementor' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( "Link URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'default' => [
					'url' => '',
				],
			]
		);

        $this->start_controls_tabs('tabs_fields_btn');
        $this->start_controls_tab(
            'tab_fields_btn_basic',
            [
                'label' => esc_html__('Basic', 'mascot-core-elementor'),
            ]
        );
		mascot_core_ereco_elementor_get_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_arraylist($this, 9);
		mascot_core_ereco_elementor_get_button_arraylist($this, 10);
		mascot_core_ereco_elementor_get_button_arraylist($this, 11);
		mascot_core_ereco_elementor_get_button_arraylist($this, 12);
		$this->add_control(
			'padding-topbottom',
			[
				'label' => esc_html__( "Padding Top Bottom", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} .btn' => 'padding-top: {{VALUE}};padding-bottom: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'padding-leftright',
			[
				'label' => esc_html__( "Padding Left Right", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} .btn' => 'padding-left: {{VALUE}};padding-right: {{VALUE}};'
				]
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_fields_btn_typo',
            [
                'label' => esc_html__('Color', 'mascot-core-elementor'),
            ]
        );
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 9);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_fields_btn_icon_options',
            [
                'label' => esc_html__('Icon', 'mascot-core-elementor'),
            ]
        );
		$this->add_control(
			'add_icon',
			[
				'label' => esc_html__( "Add icon?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
			]
		);
		$this->add_control(
			'button_icon_left',
			[
				'label' => esc_html__( "Icon Left", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);
		$this->add_control(
			'button_icon_right',
			[
				'label' => esc_html__( "Icon Right", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);
        $this->end_controls_tabs();
		$this->end_controls_section();


















		$this->start_controls_section(
			'social_links',
			[
				'label' => esc_html__( 'Social Links', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

        $this->start_controls_tabs('tabs_fields_social');
        $this->start_controls_tab(
            'tab_fields_social_basic',
            [
                'label' => esc_html__('Basic', 'mascot-core-elementor'),
            ]
        );
		$this->add_responsive_control(
			'text_alignment',
			[
				'label' => esc_html__( "Alignment", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_text_alignment_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
						'{{WRAPPER}} .tm-sc-social-links' => 'text-align: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'icon_style',
			[
				'label' => esc_html__( "Icon Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'icon-circled' => esc_html__( 'Circled', 'mascot-core-elementor' ),
					'icon-rounded' => esc_html__( 'Rounded', 'mascot-core-elementor' ),
				],
				'default' => ''
			]
		);
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( "Icon Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => esc_html__( 'Default', 'mascot-core-elementor' ),
					'icon-xs' => esc_html__( 'Extra Small', 'mascot-core-elementor' ),
					'icon-sm' => esc_html__( 'Small', 'mascot-core-elementor' ),
					'icon-md' => esc_html__( 'Medium', 'mascot-core-elementor' ),
					'icon-lg' => esc_html__( 'Large', 'mascot-core-elementor' ),
					'icon-xl' => esc_html__( 'Extra Large', 'mascot-core-elementor' ),
				],
				'default' => ''
			]
		);
		$this->add_control(
			'icon_outlined', [
				'label' => esc_html__( "Make Icon Outlined?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( "Icon Predefined Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'icon-dark' => esc_html__( 'Dark', 'mascot-core-elementor' ),
					'icon-light' => esc_html__( 'Light', 'mascot-core-elementor' ),
				],
				'default' => ''
			]
		);


		$this->add_control(
			'hr1-icon-border',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'border_options',
			[
				'label' => esc_html__( 'Border Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'none',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .social-link',
			]
		);
		$this->add_control(
			'border_hover_options',
			[
				'label' => esc_html__( 'Border (Hover) Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'none',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_hover',
				'label' => esc_html__( 'Border (Hover)', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .social-link:hover',
			]
		);

		$this->add_control(
			'hr1-icon-text',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'icon_text_color',
			[
				'label' => esc_html__( "Icon Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-link' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'icon_text_color_hover',
			[
				'label' => esc_html__( "Icon Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-link:hover' => 'color: {{VALUE}} !important;'
				]
			]
		);
		$this->add_control(
			'icon_theme_colored',
			[
				'label' => esc_html__( "Icon Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .social-link' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_control(
			'icon_theme_colored_hover',
			[
				'label' => esc_html__( "Icon Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .social-link:hover' => 'color: var(--theme-color{{VALUE}}) !important;'
				],
			]
		);



		$this->add_control(
			'hr1-icon-bg',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( "Icon BG Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-link' => 'background-color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'icon_bg_color_hover',
			[
				'label' => esc_html__( "Icon BG Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-link:hover' => 'background-color: {{VALUE}} !important;'
				]
			]
		);
		$this->add_control(
			'icon_bg_theme_colored',
			[
				'label' => esc_html__( "Icon BG Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .social-link' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_control(
			'icon_bg_theme_colored_hover',
			[
				'label' => esc_html__( "Icon BG Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .social-link:hover' => 'background-color: var(--theme-color{{VALUE}}) !important;'
				],
			]
		);


		$this->add_control(
			'hr2-icon',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);




		$this->add_control(
			'target',
			[
				'label' => esc_html__( "Link Target", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'_blank' => esc_html__( 'New Tab (Blank)', 'mascot-core-elementor' ),
					'_self' => esc_html__( 'Self', 'mascot-core-elementor' ),
				],
				'default' => ''
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_fields_social_url',
            [
                'label' => esc_html__('Social Url', 'mascot-core-elementor'),
            ]
        );
		$this->add_control(
			'url_twitter',
			[
				'label' => esc_html__( "Twitter URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_facebook',
			[
				'label' => esc_html__( "Facebook URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_youtube',
			[
				'label' => esc_html__( "Youtube URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_linkedin',
			[
				'label' => esc_html__( "Linkedin URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_instagram',
			[
				'label' => esc_html__( "Instagram URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'group_social_urls',
			[
				'label' => esc_html__( "Tumblr URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_vk',
			[
				'label' => esc_html__( "VK URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_pinterest',
			[
				'label' => esc_html__( "Pinterest URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
		$this->add_control(
			'url_reddit',
			[
				'label' => esc_html__( "Reddit URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => '',
				'default' => ''
			]
		);
        $this->end_controls_tabs();
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		//link url
		$settings['button']['target'] = ( $settings['link'] && $settings['link']['is_external'] ) ? ' target="_blank"' : '';
		$settings['button']['url'] = ( $settings['link'] && $settings['link']['url'] ) ? $settings['link']['url'] : '';
		//button classes
		$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );



		//classes
		$classes = array();
		$classes[] = $settings['custom_css_class'];
		if( $settings['design_style'] ) {
			$classes[] = 'header-nav-' . $settings['design_style'];
		}
		$settings['classes'] = $classes;





		//social_classes
		$social_classes = array();
		$social_classes[] = $settings['custom_css_class'];
		if( $settings['text_alignment'] ) {
			$social_classes[] = $settings['text_alignment'];
		}
		if( $settings['icon_style'] ) {
			$social_classes[] = $settings['icon_style'];
		}
		if( $settings['icon_size'] ) {
			$social_classes[] = $settings['icon_size'];
		}
		if( $settings['icon_outlined'] ) {
			$social_classes[] = 'links-outlined';
		}
		if( $settings['icon_color'] ) {
			$social_classes[] = $settings['icon_color'];
		}
		$settings['social_classes'] = $social_classes;



		$settings['settings'] = $settings;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = mascot_core_ereco_elementor_get_shortcode_current_theme_template_part( 'header-nav', $settings['design_style'], 'block-header-nav-row/tpl', $settings, true );

		echo $html;
	}
}
