<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_BlockTestimonial extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-block-testimonial';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Block Testimonial', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {

    $this->start_controls_section(
      'general',
      [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_css_class',
      [
        'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'design_style',
      [
        'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'style1' => esc_html__( 'Style 1', 'mascot-core-elementor' ),
          'style2' => esc_html__( 'Style 2', 'mascot-core-elementor' ),
        ],
        'default' => 'style1'
      ]
    );
    $this->end_controls_section();



    $this->start_controls_section(
      'thumb_options',
      [
        'label' => esc_html__( 'Thumb', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'thumb_img',
      [
        'label' => esc_html__( "Thumb Image", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
      ]
    );
    $this->add_control(
      'image_icon_predefined_image_size',
      [
        'label' => esc_html__( "Thumb Size", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
        'default' => 'full',
      ]
    );
    $this->add_control(
      'image_icon_custom_size',
      [
        'label' => esc_html__( "Thumb Custom Width (Only number)", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'selectors' => [
          '{{WRAPPER}} .thumb img' => 'width: {{VALUE}};'
        ]
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      'text_options',
      [
        'label' => esc_html__( 'Text', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'name_text',
      [
        'label' => esc_html__( "Name Text", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'content',
      [
        'label' => esc_html__( "Paragraph", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => esc_html__( "Lorem ipsum dolor sit amet magnam", 'mascot-core-elementor' ),
      ]
    );
    $this->add_control(
      'singnature_img',
      [
        'label' => esc_html__( "Signature Logo", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $html = '';
    $settings = $this->get_settings_for_display();

    //classes
    $classes = array();
    $classes[] = $settings['custom_css_class'];
    $settings['classes'] = $classes;

    //Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
    $html = mascot_core_ereco_elementor_get_shortcode_current_theme_template_part( 'block-testimonial', $settings['design_style'], 'block-testimonial/tpl', $settings, true );

    echo $html;
  }
}