<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Blog extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-blog';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Blog/News Grid', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
    $posts_array = mascot_core_ereco_get_post_list_array_by_post_type( 'post' );
    $categories_array = ereco_mascot_category_list_array( 'category' );
    $orderby_parameters_list1 = mascot_core_ereco_orderby_parameters_list();
    $orderby_parameters_list2 = array(
    );
    $orderby_parameters_list = array_merge( $orderby_parameters_list2, $orderby_parameters_list1 );

    $post_meta_array = array(
      'show-post-by-author' =>  esc_html__( 'Show Author', 'mascot-core-elementor' ),
      'show-post-date'  =>  esc_html__( 'Show Date', 'mascot-core-elementor' ),
      'show-post-date-split'  =>  esc_html__( 'Show Date Split', 'mascot-core-elementor' ),
      'show-post-category'  =>  esc_html__( 'Show Category', 'mascot-core-elementor' ),
      'show-post-comments-count'  =>  esc_html__( 'Show Comments Count', 'mascot-core-elementor' ),
      'show-post-tag' =>  esc_html__( 'Show Tag', 'mascot-core-elementor' ),
      'show-post-like-button'  =>  esc_html__( 'Show Like Button', 'mascot-core-elementor' )
    );

    $this->start_controls_section(
      'general', [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_css_class', [
        'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'design_style', [
        'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'blog-current-theme' => esc_html__( 'Style - Current Theme 1', 'mascot-core-elementor' ),
          'blog-current-theme2' => esc_html__( 'Style - Current Theme 2', 'mascot-core-elementor' ),
          'blog-base' => esc_html__( 'Style - Base', 'mascot-core-elementor' ),
          'blog-classic' => esc_html__( 'Style - Classic', 'mascot-core-elementor' ),
          'blog-modern' => esc_html__( 'Style - Modern', 'mascot-core-elementor' ),
          'blog-everything-over-image' => esc_html__( 'Style - Everything Over Image', 'mascot-core-elementor' ),
          'blog-vertical-list' => esc_html__( 'Style - Vertical List', 'mascot-core-elementor' ),
          'blog-alternative-design' => esc_html__( 'Style - Grid Alternative Design', 'mascot-core-elementor' ),
        ],
        'default' => 'blog-current-theme'
      ]
    );
    $this->add_control(
      'display_type', [
        'label' => esc_html__( "Display Type", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'grid'  =>  esc_html__( 'Grid', 'mascot-core-elementor' ),
          'masonry' =>  esc_html__( 'Masonry', 'mascot-core-elementor' ),
          'masonry-tiles' =>  esc_html__( 'Masonry Tiles', 'mascot-core-elementor' ),
          'carousel' =>  esc_html__( 'Carousel', 'mascot-core-elementor' ),
          'basic' =>  esc_html__( 'Basic', 'mascot-core-elementor' ),
          'floating-parallax'  =>  esc_html__( 'Floating Parallax', 'mascot-core-elementor' )
        ],
        'default' => 'grid'
      ]
    );
    $this->add_control(
      'columns', [
        'label' => esc_html__( "Columns Layout", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '1'  =>  '1',
          '2'  =>  '2',
          '3'  =>  '3',
          '4'  =>  '4',
          '5'  =>  '5',
          '6'  =>  '6',
        ],
        'default' => '3'
      ]
    );
    $this->add_control(
      'gutter',
      [
        'label' => esc_html__( "Gutter", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_isotope_gutter_list_elementor(),
        'default' => 'gutter-15',
        'condition' => [
          'display_type' => array('grid', 'masonry', 'masonry-tiles')
        ]
      ]
    );
    $this->add_control(
      'show_featured_image', [
        'label' => esc_html__( "Show Featured Image", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'featured_image_size', [
        'label' => esc_html__( "Featured Image Size", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
        'default' => 'post-thumbnail',
        'condition' => [
          'show_featured_image' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'use_masonry_tiles_featured_image_size', [
        'label' => esc_html__( "Use Predefined Image Size in Masonry Mode", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        "description" => esc_html__( "You can select predefined image size from each items edit page. If you choose yes, then 'Featured Image Size' will not work", 'mascot-core-elementor' ),
        'default' => 'yes',
        'condition' => [
          'display_type' => array('masonry-tiles')
        ]
      ]
    );

    $this->end_controls_section();




    $this->start_controls_section(
      'vertical_list-options', [
        'label' => esc_html__( 'Vertical List Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_responsive_control(
      'vertical_list_padding',
      [
        'label' => esc_html__( 'List Padding', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .blog-vertical-list article' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_responsive_control(
      'vertical_list_margin',
      [
        'label' => esc_html__( 'List Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .blog-vertical-list article' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_control(
      'vertical_list_bg_theme_colored',
      [
        'label' => esc_html__( "Background Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-vertical-list article' => 'background-color: {{VALUE}};'
        ],
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_control(
      'vertical_list_bg_theme_colored_hover',
      [
        'label' => esc_html__( "Background Color (Hover)", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-vertical-list article:hover' => 'background-color: {{VALUE}};'
        ],
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'vertical_list_boxshadow',
        'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .blog-vertical-list article',
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'vertical_list_boxshadow_hover',
        'label' => esc_html__( 'Box Shadow(Hover)', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .blog-vertical-list article:hover',
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'vertical_list_border',
        'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .blog-vertical-list article',
        'condition' => [
          'design_style' => array('blog-vertical-list')
        ]
      ]
    );
    $this->end_controls_section();




    //Carousel Options
    $this->start_controls_section(
      'carousel_options', [
        'label' => esc_html__( 'Carousel Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'display_type' => array('carousel')
        ]
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 2, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 3, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 4, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 5, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 6, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 7, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 8, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 9, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 10, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 11, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 12, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 13, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_arraylist( $this, 14, '', array('display_type' => array('carousel') ) );
    $this->end_controls_section();

    //Carousel Arrow Navigation Options
    $this->start_controls_section(
      'carousel_arrow_nav_options', [
        'label' => esc_html__( 'Carousel Arrow Navigation Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 2, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 3, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 4, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 5, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 6, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 7, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 8, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 9, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 10, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 11, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 12, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 13, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 14, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 15, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 16, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 17, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 18, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 19, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 20, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 21, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 22, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 23, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 24, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 25, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 26, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 27, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 28, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_arraylist( $this, 29, '');
    $this->end_controls_section();




    

    //Carousel Arrow Navigation Options
    $this->start_controls_section(
      'carousel_arrow_nav_bs5_breakpoints_options', [
        'label' => esc_html__( 'Carousel Arrow Nav Bootstrap5 Breakpoints', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 1, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 2, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 3, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 4, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 5, '');

    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 6, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 7, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 8, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 9, '');
    mascot_core_ereco_elementor_get_owl_carousel_nav_bs5_breakpoints_arraylist( $this, 10, '');
    $this->end_controls_section();






    //Carousel Bullets/Dots Options
    $this->start_controls_section(
      'carousel_arrow_dots_options', [
        'label' => esc_html__( 'Carousel Bullets/Dots Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 1, '', array('display_type' => array('carousel') ) );
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 2, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 3, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 4, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 5, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 6, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 7, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 8, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 9, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 10, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 11, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 12, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 13, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 14, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 15, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 16, '');
    mascot_core_ereco_elementor_get_owl_carousel_dots_arraylist( $this, 17, '');
    $this->end_controls_section();










    $this->start_controls_section(
      'query', [
        'label' => esc_html__( 'Query', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'total_items', [
        'label' => esc_html__( "Number of Items to Query from Database", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        "description" => esc_html__( "How many items do you wish to show? Put -1 to show all. Default 3", 'mascot-core-elementor' ),
        'default' => '3'
      ]
    );
    $this->add_control(
      'show_only_selected_single_post', [
        'label' => esc_html__( "Show Only Selected Single Item", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'no',
      ]
    );
    $this->add_control(
      'selected_single_post', [
        'label' => esc_html__( "Choose Single Item", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $posts_array,
        'condition' => [
          'show_only_selected_single_post' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'category', [
        'label' => esc_html__( "Category", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $categories_array,
      ]
    );
    $this->add_control(
      'order_by', [
        'label' => esc_html__( "Order By", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $orderby_parameters_list,
      ]
    );
    $this->add_control(
      'order', [
        'label' => esc_html__( "Order", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'DESC' => esc_html__( 'Descending', 'mascot-core-elementor' ),
          'ASC' => esc_html__( 'Ascending', 'mascot-core-elementor' ),
        ],
      ]
    );

    $this->end_controls_section();







    //Category Filter
    $this->start_controls_section(
      'cat_filter_section', [
        'label' => esc_html__( 'Category Filter', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 1, array('display_type' => array('grid', 'masonry', 'masonry-tiles', 'carousel') ) );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 2 );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 3 );
    mascot_core_ereco_elementor_get_cat_filter_arraylist( $this, 4 );

    $this->end_controls_section();








    //Content Options
    $this->start_controls_section(
      'content',
      [
        'label' => esc_html__( 'Content', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'show_title',
      [
        'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'title_tag',
      [
        'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_heading_tag_list(),
        'default' => 'h5',
        'condition' => [
          'show_title' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'show_excerpt', [
        'label' => esc_html__( "Show Excerpt", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'excerpt_length', [
        'label' => esc_html__( "Excerpt Length", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        "description" => esc_html__( "Number of words to display", 'mascot-core-elementor' ),
        'condition' => [
          'show_excerpt' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'show_post_meta',
      [
        'label' => esc_html__( "Show Post Meta", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_control(
      'post_meta_options',
      [
        'label' => esc_html__( "Choose Post Meta", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => $post_meta_array,
        'multiple' => true,
        'default' => [ 'show-post-by-author', 'show-post-date' ],
        'condition' => [
          'show_post_meta' => array('yes')
        ]
      ]
    );
    $this->add_control(
      'show_post_meta_over_featured_image',
      [
        'label' => esc_html__( "Show This Meta Over Thumbnail", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => $post_meta_array,
        'default' => 'show-post-by-author',
        'condition' => [
          'show_post_meta' => array('yes')
        ]
      ]
    );
    $this->end_controls_section();








    //Content Options
    $this->start_controls_section(
      'all_typography',
      [
        'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_typography',
        'label' => esc_html__( 'Title Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} article .entry-title',
      ]
    );
    $this->add_responsive_control(
      'title_margin',
      [
        'label' => esc_html__( 'Title Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} article .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );


    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'meta_typography',
        'label' => esc_html__( 'Post Meta Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} article .entry-meta',
      ]
    );
    $this->add_responsive_control(
      'post_meta_margin',
      [
        'label' => esc_html__( 'Post Meta Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} article .entry-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );



    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'single_meta_typography',
        'label' => esc_html__( 'Single Meta Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} article .post-single-meta',
      ]
    );
    $this->add_responsive_control(
      'single_meta_margin',
      [
        'label' => esc_html__( 'Single Meta Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} article .post-single-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'excerpt_typography',
        'label' => esc_html__( 'Post Excerpt Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} article .post-excerpt',
      ]
    );
    $this->add_responsive_control(
      'excerpt_margin',
      [
        'label' => esc_html__( 'Post Excerpt Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} article .post-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();








    $this->start_controls_section(
      'button_options', [
        'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
    mascot_core_ereco_elementor_get_button_arraylist($this, 1);
    mascot_core_ereco_elementor_get_button_arraylist($this, 2);
    mascot_core_ereco_elementor_get_button_arraylist($this, 3);
    mascot_core_ereco_elementor_get_button_arraylist($this, 4);
    mascot_core_ereco_elementor_get_button_arraylist($this, 5);
    mascot_core_ereco_elementor_get_button_arraylist($this, 6);
    mascot_core_ereco_elementor_get_button_arraylist($this, 7);
    mascot_core_ereco_elementor_get_button_arraylist($this, 8);
    mascot_core_ereco_elementor_get_button_arraylist($this, 9);
    mascot_core_ereco_elementor_get_button_arraylist($this, 10);
    mascot_core_ereco_elementor_get_button_arraylist($this, 11);
    mascot_core_ereco_elementor_get_button_arraylist($this, 12);
    $this->end_controls_section();



    $this->start_controls_section(
      'button_color_typo_options', [
        'label' => esc_html__( 'Button Color/Typography', 'mascot-core-elementor' ),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 1);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 2);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 3);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 4);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 5);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 6);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 7);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 8);
    mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 9);
    $this->end_controls_section();






    $this->start_controls_section(
      'loadmore_button_options', [
        'label' => esc_html__( 'Loadmore Button Options', 'mascot-core-elementor' ),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
    mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2,  esc_html__( "Load More", 'mascot-core-elementor' ), 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 1, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 2, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 3, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 4, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 5, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 6, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 7, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 8, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 9, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 10, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 11, 'loadmore_');
    mascot_core_ereco_elementor_get_button_arraylist($this, 12, 'loadmore_');

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $settings = $this->get_settings_for_display();
    $class_instance =  '';

    $settings['post_meta_options'] = implode(",", $settings['post_meta_options']);


    $settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('blog');


    if (  $settings['loadmore_show_view_details_button'] === 'yes' ) {
      $holder_id = str_replace('-', '_', $settings['holder_id']);
      $settings['holder_id_underline'] = $holder_id;
      $settings['wp_ajax_load_for_cpt'] = 'post';

      wp_localize_script( 'ereco-custom', 'tm_loadmore_params_'.$holder_id, array(
        'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php',

        'class_instance' => $class_instance,
        'params' => $settings,

        'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
      ) );
      wp_enqueue_script( 'ereco-custom' );
    }


    return mascot_core_ereco_elementor_sc_blog_render_output( $class_instance, $settings );

  }
}




if(!function_exists('mascot_core_ereco_elementor_sc_blog_render_output')) {
  /**
   * Output render
   */
  function mascot_core_ereco_elementor_sc_blog_render_output( $class_instance, $settings ) {
    $paged = isset($settings['paged']) ? $settings['paged'] : '';


    //if single post selected
    if( $settings['show_only_selected_single_post'] == 'yes' && !empty( $settings['selected_single_post'] )) {
      //query args
      $args = array(
        'p' => $settings['selected_single_post'],
      );
    } else {
      //query args
      $args = array(
        'orderby' => $settings['order_by'],
        'order' => $settings['order'],
        'posts_per_page' => $settings['total_items'],
        'paged' => $paged,
      );

      //if category selected
      if( $settings['category'] ) {
        $args['category_name'] = $settings['category'];
      }
    }

    $the_query = new \WP_Query( $args );
    $settings['the_query'] = $the_query;


    if ( !$the_query->have_posts() && isset( $settings['from_loadmore_ajax_handler'] ) && $settings['from_loadmore_ajax_handler'] === true ) {
      return;
    }


    //button classes
    $settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );
    $settings['loadmore_btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings, 'loadmore_' );

    $settings['params_array'] = $settings;


    //classes
    $classes = array();
    $classes[] = $settings['design_style'];
    $classes[] = $settings['custom_css_class'];
    $settings['classes'] = $classes;

    //Owl Carousel Data
    $settings['owl_carousel_data_info'] = ereco_mascot_prepare_owlcarousel_data_from_params( $settings );

    $settings['settings'] = $settings;

    //Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
    $html = mascot_core_ereco_elementor_get_shortcode_template_part( 'blog', $settings['display_type'], 'blog/tpl/type', $settings, true );

    echo $html;
  }
}