<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Give_Single_Campaign extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-cpt-give-single-campaign-custom';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Give Single Campaign', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$post_meta_array = array(
			'show-post-by-author' =>  esc_html__( 'Show Author', 'mascot-core-elementor' ),
			'show-post-date'  =>  esc_html__( 'Show Date', 'mascot-core-elementor' ),
			'show-post-category'  =>  esc_html__( 'Show Category', 'mascot-core-elementor' ),
			'show-post-comments-count'  =>  esc_html__( 'Show Comments Count', 'mascot-core-elementor' ),
			'show-post-tag' =>  esc_html__( 'Show Tag', 'mascot-core-elementor' ),
			'show-post-like-button'  =>  esc_html__( 'Show Like Button', 'mascot-core-elementor' )
		);

		$this->start_controls_section(
			'general', [
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_css_class', [
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'design_style', [
				'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default'	=>	esc_html__( 'Default', 'mascot-core-elementor' ),
					'current-theme-style1'	=>	esc_html__( 'Current Theme Style 1', 'mascot-core-elementor' ),
					'only-form'	=>	esc_html__( 'Style 2 - Only Form', 'mascot-core-elementor' ),
					'pie-chart-form'	=>	esc_html__( 'Style 3 - Pie Chart Form', 'mascot-core-elementor' ),
				],
				'default' => 'default'
			]
		);
		$this->add_control(
			'form_id', [
				'label' => esc_html__( "Choose Donation Form to Display", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_get_post_list_array_by_post_type( 'give_forms', false )
			]
		);
		$this->add_control(
			'custom_subtitle', [
				'label' => esc_html__( "Custom Sub Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => '',
				'default' => ''
			]
		);
		$this->add_control(
			'show_title', [
				'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'title_tag', [
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'h2',
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_excerpt', [
				'label' => esc_html__( "Show Excerpt", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'show_progress', [
				'label' => esc_html__( "Show Progress", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'show_donation_stats', [
				'label' => esc_html__( "Show Donation Stats", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'show_thumb', [
				'label' => esc_html__( "Show Thumbnail", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'feature_thumb_image_size', [
				'label' => esc_html__( "Thumbnail Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'condition' => [
					'show_thumb' => array('yes')
				]
			]
		);

		$this->end_controls_section();




		$this->start_controls_section(
			'button_options', [
					'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_arraylist($this, 9);
		mascot_core_ereco_elementor_get_button_arraylist($this, 10);
		mascot_core_ereco_elementor_get_button_arraylist($this, 11);
		mascot_core_ereco_elementor_get_button_arraylist($this, 12);

		$this->end_controls_section();


	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$class_instance =  array();
		$settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('give-single-form-custom');

		return mascot_core_ereco_elementor_sc_give_single_form_custom_render_output( $class_instance, $settings );
	}
}



if(!function_exists('mascot_core_ereco_elementor_sc_give_single_form_custom_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_ereco_elementor_sc_give_single_form_custom_render_output( $class_instance, $settings ) {
		//classes
		$classes = array();
		$classes[] = $settings['custom_css_class'];
		if( isset($settings['design_style']) ) {
			$classes[] = 'give-single-form-' . $settings['design_style'];
		}
		$settings['classes'] = $classes;

		//button classes
		$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );
		wp_register_script( 'jquery-easypiechart', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/jquery.easypiechart.min.js', array('jquery'), false, true );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'give-single-form-custom', $settings['design_style'], 'give-single-form-custom/tpl-single', $settings, true );
		
		echo $html;
	}
}