<?php
$goal_progress_stats = give_goal_progress_stats( $form_id );
$income = $goal_progress_stats['raw_actual'];
$goal   = $goal_progress_stats['raw_goal'];
$progress           = $goal ? round( ( $income / $goal ) * 100, 2 ) : 0;
$progress_bar_value = $income >= $goal ? 100 : $progress;
?>
<div class="tm-sc-give-single-form <?php echo esc_attr(implode(' ', $classes)); ?>">
	<div class="row">
		<div class="col-xl-6 form-left">
			<div class="form-info">
				<div class="donated"><?php echo esc_html( $progress_bar_value ); ?>%<br><?php esc_html_e( 'Donated', 'mascot-core-elementor'); ?></div>
				<div class="content">
					<?php if ( !empty($custom_subtitle) ) : ?>
					<h5 class="subtitle"><a href="<?php the_permalink() ?>"><?php echo esc_html( $custom_subtitle ); ?></a></h5>
					<?php endif; ?>
					<?php if ( $show_title == 'yes' ) : ?>
						<<?php echo esc_attr( $title_tag );?> class="title"><?php echo get_the_title($form_id) ?></<?php echo esc_attr( $title_tag );?>>
					<?php endif; ?>

					<?php if ( $show_excerpt == 'yes' ) : ?>
					<p class="excerpt"><?php echo get_the_excerpt($form_id) ?></p>
					<?php endif; ?>
					<?php echo do_shortcode( '[give_goal id="'. $form_id .'" show_text="true" show_bar="false"]' ); ?>
					<?php mascot_core_ereco_elementor_get_shortcode_template_part( 'button', null, 'give-single-form-custom/tpl-single', $params, false );?>
				</div>
			</div>
		</div>
		<div class="col-xl-6 form-right">
			<?php if ( $show_thumb == 'yes' && has_post_thumbnail( $form_id ) ) : ?>
			<div class="form-thumbnail">
				<a href="<?php the_permalink() ?>"><?php echo get_the_post_thumbnail( $form_id, $feature_thumb_image_size, array( 'class' => 'img-fullwidth' ) ); ?></a>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>


