<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Opening_Hours extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-opening-hours';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Opening Hours', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {
	$this->start_controls_section(
		'general',
		[
			'label' => esc_html__( 'General', 'mascot-core-elementor' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
	$this->add_control(
		'custom_css_class',
		[
			'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
		]
	);
	$this->add_control(
		'border_color',
		[
			'label' => esc_html__( "Border Color", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				'border-light' => esc_html__( 'Border Light', 'mascot-core-elementor' ),
				'border-dark' => esc_html__( 'Border Dark', 'mascot-core-elementor' ),
			],
			'default' => 'final-countdown-advanced-coupon'
		]
	);
	$this->add_control(
		'day_monday',
		[
			'label' => esc_html__( "Monday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9:00 - 17:00'
		]
	);
	$this->add_control(
		'day_tuesday',
		[
			'label' => esc_html__( "Tuesday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9:00 - 17:00'
		]
	);
	$this->add_control(
		'day_wednesday',
		[
			'label' => esc_html__( "Wednesday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9:00 - 17:00'
		]
	);
	$this->add_control(
		'day_thursday',
		[
			'label' => esc_html__( "Thursday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9:00 - 17:00'
		]
	);
	$this->add_control(
		'day_friday',
		[
			'label' => esc_html__( "Friday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '9:30 - 16:00'
		]
	);
	$this->add_control(
		'day_saturday',
		[
			'label' => esc_html__( "Saturday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '10:00 - 15:00'
		]
	);
	$this->add_control(
		'day_sunday',
		[
			'label' => esc_html__( "Sunday", 'mascot-core-elementor' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Closed'
		]
	);
	$this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();

	//classes
	$classes = array();
	$classes[] = $settings['custom_css_class'];
	$settings['classes'] = $classes;

	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'opening-hours', null, 'opening-hours/tpl', $settings, true );

	echo $html;
  }
}
