<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Page_Title extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-page-title';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Page Title', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {

    $this->start_controls_section(
      'general',
      [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'item_type', [
        'label' => esc_html__( "Choose Item", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'title' => esc_html__( 'Title', 'mascot-core-elementor' ),
          'breadcrumb' => esc_html__( 'Breadcrumb', 'mascot-core-elementor' ),
          'subtitle' => esc_html__( 'Subtitle', 'mascot-core-elementor' ),
        ],
        'default' => 'title'
      ]
    );
    $this->add_responsive_control(
      'icon_text_alignment',
      [
        'label' => esc_html__( "Text Alignment", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_elementor_text_alignment_list(),
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}}' => 'text-align: {{VALUE}};'
        ]
      ]
    );
    $this->end_controls_section();










    $this->start_controls_section(
      'title_options',
      [
        'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'item_type' => array('title')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_typography',
        'label' => esc_html__( 'Text Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .title',
      ]
    );
    $this->add_control(
      'title_text_color',
      [
        'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'title_theme_colored',
      [
        'label' => esc_html__( "Text Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_responsive_control(
      'title_margin',
      [
        'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();













    $this->start_controls_section(
      'subtitle_options',
      [
        'label' => esc_html__( 'Sub Title Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'item_type' => array('subtitle')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'subtitle_typography',
        'label' => esc_html__( 'Text Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .subtitle',
      ]
    );
    $this->add_control(
      'subtitle_text_color',
      [
        'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .subtitle' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'subtitle_theme_colored',
      [
        'label' => esc_html__( "Text Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .subtitle' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_responsive_control(
      'subtitle_margin',
      [
        'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();






















    $this->start_controls_section(
      'breadcrumb_options',
      [
        'label' => esc_html__( 'Breadcrumb Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'item_type' => array('breadcrumb')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'breadcrumb_typography',
        'label' => esc_html__( 'Text Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .breadcrumbs',
      ]
    );
    $this->add_control(
      'breadcrumb_text_color',
      [
        'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs .trail-item:not(.trail-end)' => 'color: {{VALUE}};',
          '{{WRAPPER}} .breadcrumbs a:not(.btn)' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'breadcrumb_text_color_hover',
      [
        'label' => esc_html__( "Text Color (Hover)", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs .trail-item:not(.trail-end):hover' => 'color: {{VALUE}};',
          '{{WRAPPER}} .breadcrumbs a:not(.btn):hover' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'breadcrumb_theme_colored',
      [
        'label' => esc_html__( "Text Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs .trail-item:not(.trail-end)' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .breadcrumbs a:not(.btn)' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'breadcrumb_theme_colored_hover',
      [
        'label' => esc_html__( "Text Theme Colored (Hover)", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs .trail-item:not(.trail-end):hover' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .breadcrumbs a:not(.btn):hover' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_responsive_control(
      'list_margin',
      [
        'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:not(:last-child)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'list_padding',
      [
        'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:not(:last-child)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();




    $this->start_controls_section(
      'breadcrumb_global_settings',
      [
        'label' => esc_html__( 'Breadcrumb Global Border/Spacing', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'item_type' => array('breadcrumb')
        ]
      ]
    );
    $this->add_control(
      'breadcrumb_disply_type',
      [
        'label' => esc_html__('Display Property', 'mascot-core-elementor'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'inline-block',
        'options' => mascot_core_ereco_disply_type_list_elementor(),
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs' => 'display: {{UNIT}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'breadcrumb_border',
        'label' => esc_html__( 'Border', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .breadcrumbs',
      ]
    );
    $this->add_responsive_control(
      'breadcrumb_border_radius',
      [
        'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs' => 'border-radius: {{VALUE}};'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'breadcrumb_box_shadow',
        'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .breadcrumbs',
      ]
    );
    $this->add_responsive_control(
      'breadcrumb_margin',
      [
        'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'breadcrumb_padding',
      [
        'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();










    $this->start_controls_section(
      'breadcrumb_last_item_options',
      [
        'label' => esc_html__( 'Breadcrumb Last Child/Item Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'item_type' => array('breadcrumb')
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'breadcrumb_last_item_typography',
        'label' => esc_html__( 'Text Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .breadcrumbs li:last-child, {{WRAPPER}} .breadcrumbs li:last-child a',
      ]
    );
    $this->add_control(
      'breadcrumb_last_item_text_color',
      [
        'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:last-child' => 'color: {{VALUE}};',
          '{{WRAPPER}} .breadcrumbs li:last-child a' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'breadcrumb_last_item_theme_colored',
      [
        'label' => esc_html__( "Text Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:last-child' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .breadcrumbs li:last-child a' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->end_controls_section();













    $this->start_controls_section(
      'breadcrumb_bullet_options',
      [
        'label' => esc_html__( 'Breadcrumb Bullet Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
          'item_type' => array('breadcrumb')
        ]
      ]
    );
    $this->add_control(
      'custom_bullet_unicode',
      [
        'label' => esc_html__( "Custom Bullet Unicode(Font Awesome 5)", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'description' => sprintf(__('Example: f111. Collect unicode from <a href="%s" target="_blank">FontAwesome 5</a>', 'mascot-core-elementor'), 'https://fontawesome.com/icons'),
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:not(:last-child):after' => 'content: "\{{VALUE}}";'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'breadcrumb_bullet_typography',
        'label' => esc_html__( 'Bullet Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .breadcrumbs li:after',
      ]
    );
    $this->add_control(
      'breadcrumb_bullet_text_color',
      [
        'label' => esc_html__( "Bullet Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:after' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'breadcrumb_bullet_theme_colored',
      [
        'label' => esc_html__( "Bullet Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .breadcrumbs li:after' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->end_controls_section();

  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $settings = $this->get_settings_for_display();
    switch ($settings['item_type']) {
      case 'title':
        ereco_mascot_get_title_area_title();
        break;
      case 'breadcrumb':
        ereco_mascot_display_breadcrumbs();
        break;
      case 'subtitle':
        ereco_mascot_get_title_area_subtitle();
        break;
      default:
        break;
    }
  }
}
