<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Pricing_Table extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-pricing-table';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Table', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'default' => ''
			]
		);
		$this->add_control(
			'custom_css_class',
			[
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'design_style',
			[
				'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-current-theme' => esc_html__( 'Ordering Title > Thumb > Price > List', 'mascot-core-elementor' ),
					'style-thumb-title-price-list' => esc_html__( 'Ordering Thumb > Title > Price > List', 'mascot-core-elementor' ),
					'style-thumb-price-title-list' => esc_html__( 'Ordering Thumb > Price > Title > List', 'mascot-core-elementor' ),
				],
				'default' => 'style-current-theme'
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "Sample Title", 'mascot-core-elementor' )
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => esc_html__( "Sub Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "Sample Sub Title", 'mascot-core-elementor' )
			]
		);
		$this->add_control(
			'price_prefix',
			[
				'label' => esc_html__( "Prefix", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "$", 'mascot-core-elementor' )
			]
		);
		$this->add_control(
			'price',
			[
				'label' => esc_html__( "Price", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "199", 'mascot-core-elementor' )
			]
		);
		$this->add_control(
			'price_separator',
			[
				'label' => esc_html__( "Separator", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => ''
			]
		);
		$this->add_control(
			'price_postfix',
			[
				'label' => esc_html__( "Postfix", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => ''
			]
		);
		$this->add_control(
			'label_text',
			[
				'label' => esc_html__( "Label/Offer/Tag Text", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => ''
			]
		);
		$this->end_controls_section();










		//Features
		$this->start_controls_section(
			'features_list_repeater',
			[
				'label' => esc_html__( 'Features List', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'disable_item', [
				'label' => esc_html__( "Disable This Item (Blur)?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'line_through', [
				'label' => esc_html__( "Add Line Through Text?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'content',
			[
				'label' => esc_html__( "Single Line Text", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => ''
			]
		);
		$this->add_control(
			'features_list',
			[
				'label' => esc_html__( "Features Items", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();












		//Features
		$this->start_controls_section(
			'features_list_icon_options',
			[
				'label' => esc_html__( 'List Icons Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'features_list_icon',
			[
				'label' => esc_html__( 'Icon', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'features_list_icon_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .features-list i' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'features_list_icon_color_hover',
			[
				'label' => esc_html__( "Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .features-list li:hover i' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'features_list_icon_theme_colored',
			[
				'label' => esc_html__( "Make Icon Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .features-list li i' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_control(
			'features_list_icon_theme_colored_hover',
			[
				'label' => esc_html__( "Make Icon Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .features-list li:hover i' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'features_list_icon_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .features-list i',
			]
		);
		$this->add_responsive_control(
			'features_icon_margin',
			[
				'label' => esc_html__( 'Icon Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .features-list i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();














		//Features
		$this->start_controls_section(
			'features_list_styling',
			[
				'label' => esc_html__( 'List Styling', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'features_list_text_color',
			[
				'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .features-list li' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'features_list_text_color_hover',
			[
				'label' => esc_html__( "Text Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .features-list li' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'features_list_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .features-list li',
			]
		);
		$this->add_control(
			'list_bordered',
			[
				'label' => esc_html__( "Make List(ul, li) Border Bottom?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'features_list_custom_border',
				'label' => esc_html__( 'Custom Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .features-list li',
			]
		);
		$this->add_control(
			'features_list_border_color',
			[
				'label' => esc_html__( "Border Bottom Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'list_bordered' => array('yes')
				],
				'selectors' => [
					'{{WRAPPER}} .features-list li' => 'border-color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'features_list_border_color_hover',
			[
				'label' => esc_html__( "Border Bottom Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .features-list li' => 'border-color: {{VALUE}};'
				]
			]
		);
		$this->add_responsive_control(
			'features_list_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .features-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'features_list_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .features-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();













		//Features
		$this->start_controls_section(
			'features_list_noaction_icon_options',
			[
				'label' => esc_html__( 'List Disabled Icons Styling', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'features_list_noaction_icon',
			[
				'label' => esc_html__( 'Icon', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'far fa-circle',
					'library' => 'regular',
				],
			]
		);
		$this->add_control(
			'features_list_noaction_icon_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .features-list .no-action i' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'features_list_noaction_icon_color_hover',
			[
				'label' => esc_html__( "Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .features-list .no-action:hover i' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'features_list_noaction_icon_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .features-list .no-action i',
			]
		);
		$this->end_controls_section();








		//Features
		$this->start_controls_section(
			'features_list_noaction_styling',
			[
				'label' => esc_html__( 'List Disabled Text Styling', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'features_list_noaction_text_color',
			[
				'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .features-list li.no-action' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'features_list_noaction_text_color_hover',
			[
				'label' => esc_html__( "Text Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .features-list li.no-action' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'features_list_noaction_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .features-list li.no-action',
			]
		);
		$this->end_controls_section();






		//Title
		$this->start_controls_section(
			'title_options',
			[
				'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_custom_css_class',
			[
				'label' => esc_html__( "Title Custom CSS Class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'h4'
			]
		);
		$this->add_control(
			'title_text_color',
			[
				'label' => esc_html__( "Title Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-title' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'title_text_color_hover',
			[
				'label' => esc_html__( "Title Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .pricing-table-title' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-title',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'title_border',
				'label' => esc_html__( 'Title Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();








		//Sub Title
		$this->start_controls_section(
			'sub_title_options',
			[
				'label' => esc_html__( 'Sub Title Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subtitle_custom_css_class',
			[
				'label' => esc_html__( "Sub Title Custom CSS Class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'subtitle_tag',
			[
				'label' => esc_html__( "Sub Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'p'
			]
		);
		//Content
		$this->add_control(
			'subtitle_text_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-subtitle' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'subtitle_text_color_hover',
			[
				'label' => esc_html__( "Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .pricing-table-subtitle' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-subtitle',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'subtitle_border',
				'label' => esc_html__( 'Sub Title Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-subtitle',
			]
		);
		$this->add_responsive_control(
			'subtitle_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'subtitle_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();





		//Price
		$this->start_controls_section(
			'price_options',
			[
				'label' => esc_html__( 'Price Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'price_text_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing, {{WRAPPER}} .pricing-table-pricing *' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'price_text_color_hover',
			[
				'label' => esc_html__( "Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .pricing-table-pricing, {{WRAPPER}}:hover .pricing-table-pricing *' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-pricing, {{WRAPPER}} .pricing-table-pricing *',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'pricing_border',
				'label' => esc_html__( 'Price Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-pricing',
			]
		);
		$this->add_responsive_control(
			'price_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);




		$this->add_control(
			'price_prefix_options',
			[
				'label' => esc_html__( 'Price Prefix Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_control(
			'price_prefix_text_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-prefix, {{WRAPPER}} .pricing-table-pricing .pricing-table-prefix *' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_prefix_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-pricing .pricing-table-prefix, {{WRAPPER}} .pricing-table-pricing .pricing-table-prefix *',
			]
		);
		$this->add_responsive_control(
			'price_prefix_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-prefix' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'price_prefix_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-prefix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);




		$this->add_control(
			'price_separator_options',
			[
				'label' => esc_html__( 'Price Separator Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_control(
			'price_separator_text_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-separator, {{WRAPPER}} .pricing-table-pricing .pricing-table-separator *' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_separator_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-pricing .pricing-table-separator, {{WRAPPER}} .pricing-table-pricing .pricing-table-separator *',
			]
		);
		$this->add_responsive_control(
			'price_separator_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-separator' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'price_separator_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-separator' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);






		$this->add_control(
			'price_postfix_options',
			[
				'label' => esc_html__( 'Price Postfix Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_control(
			'price_postfix_text_color',
			[
				'label' => esc_html__( "Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-postfix, {{WRAPPER}} .pricing-table-pricing .pricing-table-postfix *' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_postfix_typography',
				'label' => esc_html__( 'Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-pricing .pricing-table-postfix, {{WRAPPER}} .pricing-table-pricing .pricing-table-postfix *',
			]
		);
		$this->add_responsive_control(
			'price_postfix_margin',
			[
				'label' => esc_html__( 'Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-postfix' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'price_postfix_padding',
			[
				'label' => esc_html__( 'Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-pricing .pricing-table-postfix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();






		//Thumb
		$this->start_controls_section(
			'thumb_options',
			[
				'label' => esc_html__( 'Thumb Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'pricing_image',
			[
				'label' => esc_html__( "Pricing Thumbnail Image", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( "This image will be shown on the top of the pricing table", 'mascot-core-elementor' ),
			]
		);
		$this->add_control(
			'pricing_image_hover',
			[
				'label' => esc_html__( "Thumbnail Image (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( "This image will be shown on the top of the pricing table", 'mascot-core-elementor' ),
			]
		);
		$this->add_control(
			'pricing_predefined_image_size',
			[
				'label' => esc_html__( "Choose Predefined Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'default' => 'full',
			]
		);
		$this->add_control(
			'pricing_image_width',
			[
				'label' => esc_html__( "Custom Image Width", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-thumb img' => 'width: {{VALUE}};'
				]
			]
		);
		$this->add_responsive_control(
			'pricing_image_margin',
			[
				'label' => esc_html__( 'Image Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'pricing_image_padding',
			[
				'label' => esc_html__( 'Image Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .pricing-table-thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

























		//Features
		$this->start_controls_section(
			'container_options',
			[
				'label' => esc_html__( 'Container Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'parent_wrapper_custom_bg_color',
			[
				'label' => esc_html__( "Parent Wrapper Custom BG Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tm-sc-pricing-table' => 'background-color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'parent_wrapper_custom_bg_color_hover',
			[
				'label' => esc_html__( "Parent Wrapper Custom BG Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .tm-sc-pricing-table' => 'background-color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'parent_wrapper_border_options',
			[
				'label' => esc_html__( 'Parent Wrapper Border', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'parent_wrapper_border',
				'label' => esc_html__( 'Parent Wrapper Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .tm-sc-pricing-table',
			]
		);
		$this->add_control(
			'parent_wrapper_border_hover_options',
			[
				'label' => esc_html__( 'Parent Wrapper Border (Hover)', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'parent_wrapper_border_hover',
				'label' => esc_html__( 'Parent Wrapper Border (Hover)', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}}:hover .tm-sc-pricing-table',
			]
		);
		$this->add_responsive_control(
			'wrapper_padding',
			[
				'label' => esc_html__( 'Parent Wrapper Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tm-sc-pricing-table' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Content Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tm-sc-pricing-table .pricing-table-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'text_alignment',
			[
				'label' => esc_html__( "Text Alignment", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_text_alignment_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}} .tm-sc-pricing-table' => 'text-align: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'add_box_shadow_around_table',
			[
				'label' => esc_html__( "Add Box Shadow Around Table?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'make_this_table_featured',
			[
				'label' => esc_html__( "Make This Table Featured?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'description' => esc_html__( "Featured Pricing Table has some different looks to highlight it", 'mascot-core-elementor' ),
				'default' => 'no',
			]
		);
		$this->add_control(
			'make_hover_effect',
			[
				'label' => esc_html__( "Make Hover Effect on This Table?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'description' => esc_html__( "There will be a transition when hovering on this table", 'mascot-core-elementor' ),
			]
		);
		$this->end_controls_section();





		//Title
		$this->start_controls_section(
			'label_offer_options',
			[
				'label' => esc_html__( 'Label/Offer/Tag Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label_offer_text_color',
			[
				'label' => esc_html__( "Label Text Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-label' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'label_offer_text_color_hover',
			[
				'label' => esc_html__( "Label Text Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .pricing-table-label' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'label_offer_typography',
				'label' => esc_html__( 'Label Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .pricing-table-label',
			]
		);
		$this->add_control(
			'label_offer_custom_bg_color',
			[
				'label' => esc_html__( "Label Custom Background Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-table-label' => 'background-color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'label_offer_custom_bg_color_hover',
			[
				'label' => esc_html__( "Label Custom Background Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}:hover .pricing-table-label' => 'background-color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'label_offer_theme_colored',
			[
				'label' => esc_html__( "Label Background Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .pricing-table-label' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_control(
			'label_offer_theme_colored_hover',
			[
				'label' => esc_html__( "Label Background Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}:hover .pricing-table-label' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->end_controls_section();









		$this->start_controls_section(
			'button_options',
			[
				'label' => esc_html__( 'Button Options', 'mascot-core-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'link',
			[
			  'label' => esc_html__( "Link URL", 'mascot-core-elementor' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_arraylist($this, 9);
		mascot_core_ereco_elementor_get_button_arraylist($this, 10);
		mascot_core_ereco_elementor_get_button_arraylist($this, 11);
		mascot_core_ereco_elementor_get_button_arraylist($this, 12);
		$this->end_controls_section();



		$this->start_controls_section(
			'button_color_typo_options', [
				'label' => esc_html__( 'Button Color/Typography', 'mascot-core-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 1);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 2);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 3);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 4);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 5);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 6);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 7);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 8);
		mascot_core_ereco_elementor_get_button_text_color_typo_arraylist($this, 9);
		$this->end_controls_section();




	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		//link url
		$settings['button']['target'] = $settings['link']['is_external'] ? ' target="_blank"' : '';
		$settings['button']['url'] = $settings['link']['url'];

		//classes
		$classes = array();
		$classes[] = (!empty($settings['label_text']) ) ? 'has-label' : '';

		$classes[] = 'pricing-table-' . $settings['design_style'];

		if( $settings['list_bordered'] == 'yes' ) {
			$classes[] = 'pricing-list-bordered';
		}
		if( $settings['make_this_table_featured'] == 'yes' ) {
			$classes[] = 'pricing-table-featured';
		}
		if( $settings['make_hover_effect'] == 'yes' ) {
			$classes[] = 'pricing-table-hover-effect';
		}
		if( $settings['add_box_shadow_around_table'] == 'yes' ) {
			$classes[] = 'pricing-table-box-shadow';
		}

		$classes[] = $settings['custom_css_class'];
		$settings['classes'] = $classes;

		//button classes
		$settings['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $settings );

		//title classes
		$title_classes = array();
		$title_classes[] = $settings['title_custom_css_class'];
		$settings['title_classes'] = $title_classes;
		
		//sub title classes
		$sub_title_classes = array();
		$sub_title_classes[] = $settings['subtitle_custom_css_class'];
		$settings['sub_title_classes'] = $sub_title_classes;

		$settings['settings'] = $settings;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'pricing-table', $settings['design_style'], 'pricing-table/tpl', $settings, true );

		echo $html;
	}
}