<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_ProjectInfo extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-project-info';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Info', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "Sample Title", 'mascot-core-elementor' ),
			]
		);
		$repeater->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'h5'
			]
		);
		$repeater->add_control(
			'content',
			[
				'label' => esc_html__( "Content", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( "Lorem ipsum dolor sit amet", 'mascot-core-elementor' ),
			]
		);
		$this->add_control(
			'project_info_list',
			[
				'label' => esc_html__( "Fields", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'styling_options',
			[
				'label' => esc_html__( 'Title Styling Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .project-title',
			]
		);
		$this->add_control(
			'title_theme_colored',
			[
				'label' => esc_html__( "Title Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-title' => 'color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_control(
			'title_custom_color',
			[
				'label' => esc_html__( "Title Custom Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .project-title' => 'color: {{VALUE}};'
				]
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'content_styling_options',
			[
				'label' => esc_html__( 'Content Styling Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => esc_html__( 'Content Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .project-description, {{WRAPPER}} .project-description *',
			]
		);
		$this->add_control(
			'content_theme_colored',
			[
				'label' => esc_html__( "Content Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-description' => 'color: var(--theme-color{{VALUE}});',
					'{{WRAPPER}} .project-description *' => 'color: var(--theme-color{{VALUE}});',
				],
			]
		);
		$this->add_control(
			'content_custom_color',
			[
				'label' => esc_html__( "Content Custom Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .project-description' => 'color: {{VALUE}};',
					'{{WRAPPER}} .project-description *' => 'color: {{VALUE}};',
				]
			]
		);
		$this->end_controls_section();



		$this->start_controls_section(
			'list-options', [
				'label' => esc_html__( 'List Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'list_margin',
			[
				'label' => esc_html__( 'List Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tm-sc-project-info .each-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .tm-sc-project-info .each-item:last-child' => 'margin: 0;',
				],
			]
		);
		$this->add_responsive_control(
			'list_padding',
			[
				'label' => esc_html__( 'List Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .tm-sc-project-info .each-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .tm-sc-project-info .each-item:last-child' => 'padding: 0;',
				],
			]
		);
		$this->add_control(
			'list_border_options',
			[
				'label' => esc_html__( 'List Border Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'list_border',
				'label' => esc_html__( 'List Border', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .tm-sc-project-info .each-item',
			]
		);
		$this->add_control(
			'list_border_last_item_options',
			[
				'label' => esc_html__( 'List Border (Last Item) Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'list_border_last_item',
				'label' => esc_html__( 'List Border (Last Item)', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .tm-sc-project-info .each-item:last-child',
			]
		);
		$this->end_controls_section();






		$this->start_controls_section(
			'wrapper-options', [
				'label' => esc_html__( 'Wrapper Options', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'wrapper_bg_theme_colored',
			[
				'label' => esc_html__( "Wrapper BG Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->add_control(
			'wrapper_bg_theme_colored_hover',
			[
				'label' => esc_html__( "Wrapper BG Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}:hover' => 'background-color: var(--theme-color{{VALUE}});'
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$html = '';
		$settings = $this->get_settings_for_display();
		
		//classes
		$classes = array();
		$classes[] = 'tm-sc-project-info';
		$settings['classes'] = $classes;

	?>
		<div class="<?php echo esc_attr(implode(' ', $classes)); ?>">
	<?php
		if ( $settings['project_info_list'] ) { 
			$settings['iter'] = 1;
			foreach (  $settings['project_info_list'] as $item ) {
				$iter = $settings['iter']++;

				$item_classes = array();
				$item_classes[] = 'each-item elementor-repeater-item-' . $item['_id'];
				//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)

				?>
				<div class="<?php echo esc_attr(implode(' ', $item_classes)); ?>">
					<<?php echo esc_attr( $item['title_tag'] );?> class="project-title"><?php echo esc_html( $item['title'] );?></<?php echo esc_attr( $item['title_tag'] );?>>
					<div class="project-description"><?php echo do_shortcode($item['content']);?></div>
				</div>
				<?php
			}
		} 
	?>
		</div>
	<?php
	}
}