<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_FullPage extends Widget_Base {
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script( 'scrolloverflow', MASCOT_CORE_TEMPLATE_URI. '/assets/js/plugins/slider-fullpage/scrolloverflow.min.js', array('jquery'), false, true );
		wp_register_script( 'fullpage', MASCOT_CORE_TEMPLATE_URI. '/assets/js/plugins/slider-fullpage/fullpage.min.js', array('jquery'), false, true );
		wp_register_style( 'fullpage', MASCOT_CORE_TEMPLATE_URI. '/assets/js/plugins/slider-fullpage/fullpage.min.css' );
		wp_register_style( 'fullpage-rtl', MASCOT_CORE_TEMPLATE_URI. '/assets/js/plugins/slider-fullpage/fullpage.min-rtl.css' );
		
	}

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tm-ele-slider-fullpage';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Slider - FullPage', 'mascot-core-elementor' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tm-elementor-widget-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tm' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'mascot-core-hellojs', 'scrolloverflow', 'fullpage' ];
	}

	
	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @since 1.9.0
	 * @access public
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		if( is_rtl() ) {
			return [ 'fullpage-rtl' ];
		} else {
			return [ 'fullpage' ];
		}
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
		//Content Options
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Content', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'fp_auto_height', [
				'label' => esc_html__( "Make Auto Height Section", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		$repeater->add_control(
			'fp_auto_height_responsive', [
				'label' => esc_html__( "Make Responsive Auto Height Section", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$repeater->add_control(
			'hr1-bg',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'mascot-core-elementor' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
			]
		);



		$repeater->add_control(
			'hr2-wrapper',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_responsive_control(
			'text_alignment',
			[
				'label' => esc_html__( "Wrapper Text Alignment", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_text_alignment_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .section-wrapper' => 'text-align: {{VALUE}};'
				],
			]
		);
		$repeater->add_responsive_control(
			'wrapper_margin',
			[
				'label' => esc_html__( 'Wrapper Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .section-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$repeater->add_responsive_control(
			'wrapper_padding',
			[
				'label' => esc_html__( 'Wrapper Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .section-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$repeater->add_control(
			'hr3-title',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'show_title', [
				'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( "Title", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( "This is a section title", 'mascot-core-elementor' ),
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$repeater->add_control(
			'title_tag',
			[
				'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_heading_tag_list(),
				'default' => 'h2',
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .fp-title',
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$repeater->add_control(
			'title_color',
			[
				'label' => esc_html__( "Title Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-title *' => 'color: {{VALUE}};'
				],
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$repeater->add_control(
			'title_theme_colored',
			[
				'label' => esc_html__( "Make Title Theme Colored?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-title' => 'color: var(--theme-color{{VALUE}});'
				],
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$repeater->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Title Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);
		$repeater->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'show_title' => array('yes')
				]
			]
		);



		$repeater->add_control(
			'hr4-content',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$repeater->add_control(
			'show_content', [
				'label' => esc_html__( "Show Content", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$repeater->add_control(
			'content',
			[
				'label' => esc_html__( "Content", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => esc_html__( "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", 'mascot-core-elementor' ),
				'condition' => [
					'show_content' => array('yes')
				]
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => esc_html__( 'Content Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .fp-content, {{WRAPPER}} {{CURRENT_ITEM}} .fp-content *',
				'condition' => [
					'show_content' => array('yes')
				]
			]
		);
		$repeater->add_control(
			'content_color',
			[
				'label' => esc_html__( "Content Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-content' => 'color: {{VALUE}};',
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-content *' => 'color: {{VALUE}};'
				],
				'condition' => [
					'show_content' => array('yes')
				]
			]
		);
		$repeater->add_control(
			'content_theme_colored',
			[
				'label' => esc_html__( "Make Content Theme Colored?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-content' => 'color: var(--theme-color{{VALUE}});',
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-content *' => 'color: var(--theme-color{{VALUE}});'
				],
				'condition' => [
					'show_content' => array('yes')
				]
			]
		);
		$repeater->add_responsive_control(
			'content_margin',
			[
				'label' => esc_html__( 'Content Margin', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'show_content' => array('yes')
				]
			]
		);
		$repeater->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Content Padding', 'mascot-core-elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} .fp-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'show_content' => array('yes')
				]
			]
		);



		$repeater->add_control(
			'hr5-button',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($repeater, 1);
		mascot_core_ereco_elementor_get_viewdetails_button_arraylist($repeater, 2);
		$repeater->add_control(
			'link',
			[
				'label' => esc_html__( "Button Link URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'show_view_details_button' => array('yes')
				]
			]
		);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 1, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 2, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 3, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 4, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 5, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 6, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 7, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 8, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 9, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 10, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 11, '', true);
		mascot_core_ereco_elementor_get_button_arraylist($repeater, 12, '', true);


		$this->add_control(
			'multiscroll_items',
			[
				'label' => esc_html__( "Fields", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();













		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General Settings', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_anchor_menu', [
				'label' => esc_html__( "Show Anchor Menu", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'anchor_menu', [
				'label' => esc_html__( "Anchor Menu Items", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Put menu items seperated by comma. As for example: Home, Services, Contact", 'mascot-core-elementor' ),
				'default' => esc_html__( "Home, Services, Contact", 'mascot-core-elementor' ),
				'condition' => [
					'show_anchor_menu' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_navigation_bullet_menu', [
				'label' => esc_html__( "Show Navigation Bullet Menu", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'navigation_position',
			[
				'label' => esc_html__( "Navigation Position", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'right' => esc_html__( 'Right', 'mascot-core-elementor' ),
					'left' => esc_html__( 'Left', 'mascot-core-elementor' )
				],
				'default' => 'right',
				'condition' => [
					'show_navigation_bullet_menu' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_tooltips_on_navigation_bullet_menu', [
				'label' => esc_html__( "Show Tooltips on Navigation Bullet Menu", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		$this->add_control(
			'tooltips_on_navigation', [
				'label' => esc_html__( "Tooltips on Navigation Bullets", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Put Tooltips seperated by comma. As for example: Home, Services, Contact", 'mascot-core-elementor' ),
				'default' => esc_html__( "Home, Services, Contact", 'mascot-core-elementor' ),
				'condition' => [
					'show_tooltips_on_navigation_bullet_menu' => array('yes')
				]
			]
		);
		$this->add_control(
			'show_navigation_landscape_slider', [
				'label' => esc_html__( "Show Navigation for Each Landscape Slider", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		$this->add_control(
			'scrolling_speed', [
				'label' => esc_html__( "Scrolling Speed", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Defines the scrolling speed in milliseconds. Default: 700", 'mascot-core-elementor' ),
				'default' => '700'
			]
		);
		$this->add_control(
			'responsive_width', [
				'label' => esc_html__( "Responsive Width", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				"description" => esc_html__( "Normal scroll will be used under the defined width in pixels. Default: 1000", 'mascot-core-elementor' ),
				'default' => '1000',
			]
		);
		$this->add_control(
			'easing',
			[
				'label' => esc_html__( "Easing", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_jquery_easings_list(),
				'default' => 'easeInQuart',
				"description" => esc_html__( "Defines the transition effect to use for the vertical and horizontal scrolling. Default: easeInQuart", 'mascot-core-elementor' ),
			]
		);
		$this->add_control(
			'looptop', [
				'label' => esc_html__( "Loop Top", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->add_control(
			'loopbottom', [
				'label' => esc_html__( "Loop Bottom", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes'
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$html = '';
		$settings = $this->get_settings_for_display();
		extract($settings);

		//classes
		if( $show_anchor_menu == 'yes' ) {
			$show_anchor_menu = 'true';
		}
		if( $show_navigation_bullet_menu == 'yes' ) {
			$show_navigation_bullet_menu = 'true';
		}
		if( $show_tooltips_on_navigation_bullet_menu == 'yes' ) {
			$show_tooltips_on_navigation_bullet_menu = 'true';
		}
		if( $looptop == 'yes' ) {
			$looptop = 'true';
		}
		if( $loopbottom == 'yes' ) {
			$loopbottom = 'true';
		}
		$settings['settings'] = $settings;

		$html = "";
		$html .= '<div id="fullpage-container" class="tm-full-page-slider" data-anchor="'.esc_attr( $show_anchor_menu ).'" data-anchor-menu="'.esc_attr( $anchor_menu ).'" data-navigation="'.esc_attr( $show_navigation_bullet_menu ).'" data-navigation-position="'.esc_attr( $navigation_position ).'" data-navigation-tooltip="'.esc_attr( $show_tooltips_on_navigation_bullet_menu ).'" data-navigation-tooltips="'.esc_attr( $tooltips_on_navigation ).'" data-horizontal-navigation="'.esc_attr( $show_navigation_landscape_slider ).'" data-scrolling-speed="'.esc_attr( $scrolling_speed ).'" data-responsive-width="'.esc_attr( $responsive_width ).'" data-easing="'.esc_attr( $easing ).'" data-looptop="'.esc_attr( $looptop ).'" data-loopbottom="'.esc_attr( $loopbottom ).'">';


		$i = 0;

		$menu_list = explode(',', $anchor_menu);
		if( $show_anchor_menu && !empty($menu_list) ) {
			$html .= '<ul id="tm-full-page-menu">';
			foreach( $menu_list as $item ) {
				$item = trim( $item );
				$active = '';
				if($i==0) {
					$active = 'class="active"';
				}
				$html .= '<li data-menuanchor="'. esc_attr( $item ).'" '.esc_attr( $active ).'><a href="#'. esc_attr( $item ) .'">'. esc_html( $item ) .'</a></li>';
				$i++;
			}
			$html .= '</ul>';
		}

		//repeater
		if ( $settings['multiscroll_items'] ) { 
			$settings['iter'] = 1;
			foreach (  $settings['multiscroll_items'] as $item ) {
				$iter = $settings['iter']++;

				//classes
				$item['item'] = $item;
				
				//link url
				$item['target'] = ( $item['link'] && $item['link']['is_external'] ) ? ' target="_blank"' : '';
				$item['url'] = ( $item['link'] && $item['link']['url'] ) ? $item['link']['url'] : '';

				$item['btn_classes'] = ereco_mascot_prepare_button_classes_from_params( $item );


				//classes
				$section_classes = array();
				if ( $item['fp_auto_height'] == 'yes' ) {
					$section_classes[] = 'fp-auto-height';
				}
				if ( $item['fp_auto_height_responsive'] == 'yes' ) {
					$section_classes[] = 'fp-auto-height-responsive';
				}

				$html .= '<div class="section '.esc_attr(implode(' ', $section_classes)).'">';
				//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
				$html .= mascot_core_ereco_elementor_get_shortcode_template_part( 'slider-content-item', null, 'slider-fullpage/tpl', $item, true );
				$html .= '</div>';
			}
		}

		echo $html .= '</div>';
	}
}