<?php
$repeater_item_class = 'each-item elementor-repeater-item-' . $_id;
?>


<div class='slide <?php echo esc_attr( $repeater_item_class) ?>'>
	<div class="section-wrapper">
		<?php if ( $show_title == 'yes' ) : ?>
		<?php if( !empty( $title ) ) : ?>
		<<?php echo esc_attr( $title_tag );?> class="fp-title">
			<?php echo esc_html( $title );?>
		</<?php echo esc_attr( $title_tag );?>>
		<?php endif; ?>
		<?php endif; ?>


		<?php if ( $show_content == 'yes' ) : ?>
		<div class="fp-content"><?php echo do_shortcode($content); ?></div>
		<?php endif; ?>


		<?php if ( $show_view_details_button == 'yes' ) : ?>
		<div class="btn-view-details <?php echo esc_attr( $button_alignment );?>">
			<a  target="<?php echo ( ( $target == '' ) ? esc_attr( '_self' ) : esc_attr( $target ) ); ?>" 
				href="<?php echo esc_url( $url );?>"
				class="<?php echo esc_attr(implode(' ', $btn_classes)); ?>">
				<?php echo esc_html( $view_details_button_text  ); ?>
			</a>
		</div>
		<?php endif; ?>
	</div>
</div>
