<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Timeline extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
    return 'tm-ele-timeline';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
    return esc_html__( 'Timeline', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
    return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
    return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
    return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function _register_controls() {

    $this->start_controls_section(
      'general',
      [
        'label' => esc_html__( 'General', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'custom_css_class',
      [
        'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'display_type', [
        'label' => esc_html__( "Design", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          'timeline-basic' =>  esc_html__( 'Basic', 'mascot-core-elementor' ),
        ],
        'default' => 'timeline-basic'
      ]
    );
    $repeater = new \Elementor\Repeater();

    $repeater->add_control(
      'title',
      [
        'label' => esc_html__( "Title", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'title_tag',
      [
        'label' => esc_html__( "Title Tag", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => mascot_core_ereco_heading_tag_list(),
        'default' => 'h5',
      ]
    );
    $repeater->add_control(
      'subtitle',
      [
        'label' => esc_html__( "Sub Title", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'date_range',
      [
        'label' => esc_html__( "Date Range", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'content',
      [
        'label' => esc_html__( "Description", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => esc_html__( "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.", 'mascot-core-elementor' ),
      ]
    );


    $this->add_control(
      'timeline_items',
      [
        'label' => esc_html__( "Item", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
      ]
    );
    $this->end_controls_section();







    $this->start_controls_section(
      'styling_options',
      [
        'label' => esc_html__( 'Styling Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'title_color_options',
      [
        'label' => esc_html__( 'Title Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'show_title', [
        'label' => esc_html__( "Show Title", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'title_typography',
        'label' => esc_html__( 'Title Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .title',
      ]
    );
    $this->add_control(
      'title_theme_colored',
      [
        'label' => esc_html__( "Title Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'title_custom_color',
      [
        'label' => esc_html__( "Title Custom Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'title_margin',
      [
        'label' => esc_html__( 'Title Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );



    $this->add_control(
      'subtitle_color_options',
      [
        'label' => esc_html__( 'Sub Title Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'show_subtitle', [
        'label' => esc_html__( "Show Sub Title", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'subtitle_typography',
        'label' => esc_html__( 'Sub Title Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .subtitle',
      ]
    );
    $this->add_control(
      'subtitle_theme_colored',
      [
        'label' => esc_html__( "Sub Title Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .subtitle' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'subtitle_custom_color',
      [
        'label' => esc_html__( "Sub Title Custom Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .subtitle' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'subtitle_margin',
      [
        'label' => esc_html__( 'Sub Title Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );



    $this->add_control(
      'time_color_options',
      [
        'label' => esc_html__( 'Time Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'show_time', [
        'label' => esc_html__( "Show Time", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'time_typography',
        'label' => esc_html__( 'Time Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .time',
      ]
    );
    $this->add_control(
      'time_theme_colored',
      [
        'label' => esc_html__( "Time Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .time' => 'color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'time_custom_color',
      [
        'label' => esc_html__( "Time Custom Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .time' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'time_margin',
      [
        'label' => esc_html__( 'Time Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );



    $this->add_control(
      'excerpt_color_options',
      [
        'label' => esc_html__( 'Excerpt Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'show_excerpt', [
        'label' => esc_html__( "Show Excerpt", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes'
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'excerpt_typography',
        'label' => esc_html__( 'Excerpt Typography', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .content, {{WRAPPER}} .content *',
      ]
    );
    $this->add_control(
      'excerpt_theme_colored',
      [
        'label' => esc_html__( "Excerpt Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .content' => 'color: var(--theme-color{{VALUE}});',
          '{{WRAPPER}} .content *' => 'color: var(--theme-color{{VALUE}});',
        ],
      ]
    );
    $this->add_control(
      'excerpt_custom_color',
      [
        'label' => esc_html__( "Excerpt Custom Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .content' => 'color: {{VALUE}};',
          '{{WRAPPER}} .content *' => 'color: {{VALUE}};'
        ]
      ]
    );
    $this->add_responsive_control(
      'excerpt_margin',
      [
        'label' => esc_html__( 'Excerpt Margin', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();





    $this->start_controls_section(
      'bullet_pos_options',
      [
        'label' => esc_html__( 'Bullet Position Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_responsive_control(
      'bullet_pos_top',
      [
        'label' => esc_html__( "Bullet Top", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'top: {{VALUE}};bottom:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'bullet_pos_right',
      [
        'label' => esc_html__( "Bullet Right", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'right: {{VALUE}};left:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'bullet_pos_bottom',
      [
        'label' => esc_html__( "Bullet Bottom", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'bottom: {{VALUE}};top:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'bullet_pos_left',
      [
        'label' => esc_html__( "Bullet Left", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'left: {{VALUE}};right:auto;'
        ]
      ]
    );
    $this->add_control(
      'bullet_dimension_options',
      [
        'label' => esc_html__( 'Dimension Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'bullet_width',
      [
        'label' => esc_html__( "Bullet Width", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'width: {{VALUE}};',
        ]
      ]
    );
    $this->add_responsive_control(
      'bullet_height',
      [
        'label' => esc_html__( "Bullet Height", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'height: {{VALUE}};',
        ]
      ]
    );
    $this->add_control(
      'bullet_border_options',
      [
        'label' => esc_html__( 'Border Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'bullet_border',
        'label' => esc_html__( 'Bullet Border', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-timeline .info-box:before',
      ]
    );
    $this->add_responsive_control(
      'bullet_border_radius',
      [
        'label' => esc_html__( "Bullet Border Radius", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:before' => 'border-radius: {{VALUE}};'
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'bullet_box_shadow',
        'label' => esc_html__( 'Bullet Box Shadow', 'mascot-core-elementor' ),
        'selector' => '{{WRAPPER}} .tm-timeline .info-box:before',
      ]
    );
    $this->end_controls_section();














    $this->start_controls_section(
      'vertical_line_pos_options',
      [
        'label' => esc_html__( 'Vertical Line Options', 'mascot-core-elementor' ),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_responsive_control(
      'vertical_line_pos_top',
      [
        'label' => esc_html__( "Vertical Line Top", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'top: {{VALUE}};bottom:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'vertical_line_pos_right',
      [
        'label' => esc_html__( "Vertical Line Right", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'right: {{VALUE}};left:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'vertical_line_pos_bottom',
      [
        'label' => esc_html__( "Vertical Line Bottom", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'bottom: {{VALUE}};top:auto;'
        ]
      ]
    );
    $this->add_responsive_control(
      'vertical_line_pos_left',
      [
        'label' => esc_html__( "Vertical Line Left", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'left: {{VALUE}};right:auto;'
        ]
      ]
    );
    $this->add_control(
      'vertical_line_dimension_options',
      [
        'label' => esc_html__( 'Dimension Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'vertical_line_width',
      [
        'label' => esc_html__( "Vertical Line Width", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'width: {{VALUE}};',
        ]
      ]
    );
    $this->add_responsive_control(
      'vertical_line_height',
      [
        'label' => esc_html__( "Vertical Line Height", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'devices' => [ 'desktop', 'tablet', 'mobile' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'height: {{VALUE}};',
        ]
      ]
    );
    $this->add_control(
      'vertical_line_color_options',
      [
        'label' => esc_html__( 'Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'vertical_line_custom_bg_color',
      [
        'label' => esc_html__( "Vertical Line Custom Background Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'background-color: {{VALUE}};'
        ]
      ]
    );
    $this->add_control(
      'vertical_line_theme_colored',
      [
        'label' => esc_html__( "Vertical Line Theme Colored", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => ereco_mascot_theme_color_list(),
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:after' => 'background-color: var(--theme-color{{VALUE}});'
        ],
      ]
    );
    $this->add_control(
      'vertical_line_last_item_color_options',
      [
        'label' => esc_html__( 'Last Item Color Options', 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'vertical_line_last_item_custom_bg_color',
      [
        'label' => esc_html__( "Vertical Line Last Item BG Color", 'mascot-core-elementor' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box:last-child:after' => 'background-color: {{VALUE}};'
        ]
      ]
    );
    $this->end_controls_section();






    $this->start_controls_section(
      'content_wrapper_styling',
      [
        'label' => esc_html__( 'Content Wrapper Style', 'mascot-core-elementor' ),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_responsive_control(
      'content_wrapper_padding',
      [
        'label' => esc_html__( 'Wrapper Padding', 'mascot-core-elementor' ),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px', '%', 'em' ],
        'selectors' => [
          '{{WRAPPER}} .tm-timeline .info-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
    $html = '';
    $settings = $this->get_settings_for_display();
    
    //classes
    $classes = array();
    $classes[] = 'tm-timeline';
    $classes[] = $settings['custom_css_class'];
    $classes[] = $settings['display_type'];

    $settings['classes'] = $classes;

    $settings['holder_id'] = ereco_mascot_get_isotope_holder_ID('timeline');
  ?>
    <div id="<?php echo esc_attr( $settings['holder_id'] ) ?>" class="<?php echo esc_attr(implode(' ', $classes)); ?>">
  <?php
    if ( $settings['timeline_items'] ) { 
      $rand = rand(10,100);
      $i=1;
      foreach (  $settings['timeline_items'] as $item ) {
        $item['rand'] = $rand.''.$i;
        $item['holder_id'] = $settings['holder_id'];
        $settings['item'] = $item;

        //Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
        $html .= mascot_core_ereco_elementor_get_shortcode_template_part( $settings['display_type'], null, 'timeline/tpl', $settings, true );
        $i++;
      }
    } 
    echo $html;
  ?>
    </div>
  <?php
  }
}