<?php
namespace MascotCoreErecoElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TM_Elementor_Video_Popup extends Widget_Base {

  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name() {
		return 'tm-ele-video-popup';
  }

  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title() {
		return esc_html__( 'Video Popup', 'mascot-core-elementor' );
  }

  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon() {
		return 'tm-elementor-widget-icon';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories() {
		return [ 'tm' ];
  }

  /**
   * Retrieve the list of scripts the widget depended on.
   *
   * Used to set scripts dependencies required to run the widget.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget scripts dependencies.
   */
  public function get_script_depends() {
		return [ 'mascot-core-hellojs' ];
  }

  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'mascot-core-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_css_class',
			[
				'label' => esc_html__( "Custom CSS class", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'design_style',
			[
				'label' => esc_html__( "Design Style", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'description' => '',
				'options' => [
					'button-over-image' => esc_html__( 'Play Button over Featured Image', 'mascot-core-elementor' ),
					'button-over-image2' => esc_html__( 'Play Button over Featured Image2', 'mascot-core-elementor' ),
					//'style-current-theme' => esc_html__( 'Style Current Theme', 'mascot-core-elementor' ),
					'button-with-text-right' => esc_html__( 'Play Button with Text on Right', 'mascot-core-elementor' ),
					'css-button' => esc_html__( 'Only CSS Play Button', 'mascot-core-elementor' ),
					'custom-css-button' => esc_html__( 'Custom CSS Play Button', 'mascot-core-elementor' ),
				],
				'default' => 'css-button',
			]
		);


		$this->add_control(
			'style1_featured_image',
			[
				'label' => esc_html__( "Choose Featured Image", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				"description" => esc_html__( "You can upload & select background featured image", 'mascot-core-elementor' ),
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'style-current-theme')
				]
			]
		);
		$this->add_responsive_control(
			'featured_image_border_radius',
			[
				'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'style-current-theme')
				],
				'selectors' => [
					'{{WRAPPER}} .tm-sc-video-popup' => 'border-radius: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'style1_featured_image_size',
			[
				'label' => esc_html__( "Featured Image Size", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_get_available_image_sizes(),
				'default' => 'large',
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'style-current-theme')
				]
			]
		);
		$this->add_control(
			'style1_play_btn',
			[
				'label' => esc_html__( "Choose Play Button From Media", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				"description" => esc_html__( "You can upload and choose play button from media", 'mascot-core-elementor' ),
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'style-current-theme')
				]
			]
		);
		$this->add_control(
			'style1_pre_packaged_play_btn',
			[
				'label' => esc_html__( "Or Choose Play Button From", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'description' => '',
				'options' => [
					'' => esc_html__( 'Default Animated Button', 'mascot-core-elementor' ),
					's1.png' => esc_html__( 'Play Button 1', 'mascot-core-elementor' ),
					's1.png' => esc_html__( 'Play Button 1', 'mascot-core-elementor' ),
					's2.png' => esc_html__( 'Play Button 2', 'mascot-core-elementor' ),
					's3.png' => esc_html__( 'Play Button 3', 'mascot-core-elementor' ),
					's4.png' => esc_html__( 'Play Button 4', 'mascot-core-elementor' ),
					's5.png' => esc_html__( 'Play Button 5', 'mascot-core-elementor' ),
					's6.png' => esc_html__( 'Play Button 6', 'mascot-core-elementor' ),
					's7.png' => esc_html__( 'Play Button 7', 'mascot-core-elementor' ),
					's8.png' => esc_html__( 'Play Button 8', 'mascot-core-elementor' ),
					's9.png' => esc_html__( 'Play Button 9', 'mascot-core-elementor' ),
					's10.png' => esc_html__( 'Play Button 10', 'mascot-core-elementor' ),
					's11.png' => esc_html__( 'Play Button 11', 'mascot-core-elementor' ),
					's12.png' => esc_html__( 'Play Button 12', 'mascot-core-elementor' ),
					's13.png' => esc_html__( 'Play Button 13', 'mascot-core-elementor' ),
					's14.png' => esc_html__( 'Play Button 14', 'mascot-core-elementor' ),
					's15.png' => esc_html__( 'Play Button 15', 'mascot-core-elementor' ),
					's16.png' => esc_html__( 'Play Button 16', 'mascot-core-elementor' ),
					's17.png' => esc_html__( 'Play Button 17', 'mascot-core-elementor' )
				],
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'style-current-theme')
				]
			]
		);



		$this->add_control(
			'style2_play_btn',
			[
				'label' => esc_html__( "Choose Play Button From Media", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				"description" => esc_html__( "You can upload and choose play button from media", 'mascot-core-elementor' ),
				'condition' => [
					'design_style' => array('button-with-text-right')
				]
			]
		);
		$this->add_control(
			'style2_pre_packaged_play_btn',
			[
				'label' => esc_html__( "Or Choose Play Button From", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'description' => '',
				'options' => [
					's1.png' => esc_html__( 'Play Button 1', 'mascot-core-elementor' ),
					's1.png' => esc_html__( 'Play Button 1', 'mascot-core-elementor' ),
					's2.png' => esc_html__( 'Play Button 2', 'mascot-core-elementor' ),
					's3.png' => esc_html__( 'Play Button 3', 'mascot-core-elementor' ),
					's4.png' => esc_html__( 'Play Button 4', 'mascot-core-elementor' ),
					's5.png' => esc_html__( 'Play Button 5', 'mascot-core-elementor' ),
					's6.png' => esc_html__( 'Play Button 6', 'mascot-core-elementor' ),
					's7.png' => esc_html__( 'Play Button 7', 'mascot-core-elementor' ),
					's8.png' => esc_html__( 'Play Button 8', 'mascot-core-elementor' ),
					's9.png' => esc_html__( 'Play Button 9', 'mascot-core-elementor' ),
					's10.png' => esc_html__( 'Play Button 10', 'mascot-core-elementor' ),
					's11.png' => esc_html__( 'Play Button 11', 'mascot-core-elementor' ),
					's12.png' => esc_html__( 'Play Button 12', 'mascot-core-elementor' ),
					's13.png' => esc_html__( 'Play Button 13', 'mascot-core-elementor' ),
					's14.png' => esc_html__( 'Play Button 14', 'mascot-core-elementor' ),
					's15.png' => esc_html__( 'Play Button 15', 'mascot-core-elementor' ),
					's16.png' => esc_html__( 'Play Button 16', 'mascot-core-elementor' ),
					's17.png' => esc_html__( 'Play Button 17', 'mascot-core-elementor' )
				],
				'condition' => [
					'design_style' => array('button-with-text-right')
				]
			]
		);

		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( "Title Text", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'popup_video_url',
			[
				'label' => esc_html__( "Popup Video URL", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_responsive_control(
			'icon_text_alignment',
			[
				'label' => esc_html__( "Text Alignment", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => mascot_core_ereco_elementor_text_alignment_list(),
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .tm-sc-video-popup' => 'display: inline-block;'
				]
			]
		);
		$this->end_controls_section();





		$this->start_controls_section(
			'icon_styling',
			[
				'label' => esc_html__( 'Play Button Styling', 'mascot-core-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		//custom-css-button

		//button-with-text-right
		$this->add_control(
			'button_with_text_right_icon_width',
			[
				'label' => esc_html__( "Play Icon Width", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'design_style' => array('button-with-text-right')
				],
				'selectors' => [
					'{{WRAPPER}} .thumb img' => 'width: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'button_with_text_right_color',
			[
				'label' => esc_html__( "Text Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'design_style' => array('button-with-text-right')
				],
				'selectors' => [
					'{{WRAPPER}} .video-button-text' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_right_icon_typography',
				'label' => esc_html__( 'Text Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .video-button-text',
				'condition' => [
					'design_style' => array('button-with-text-right')
				],
			]
		);





		//button-over-image2
		$this->add_control(
			'icon_options',
			[
				'label' => esc_html__( 'Icon Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( "Icon Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'color: {{VALUE}};',
					'{{WRAPPER}} .animated-css-play-button .play-icon i' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'icon_color_hover',
			[
				'label' => esc_html__( "Icon Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}}:hover .video-play-button' => 'color: {{VALUE}};',
					'{{WRAPPER}}:hover .animated-css-play-button .play-icon i' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => esc_html__( 'Icon Typography', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .video-play-button, {{WRAPPER}} .animated-css-play-button .play-icon i',
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
			]
		);
		$this->add_control(
			'icon_bg_options',
			[
				'label' => esc_html__( 'Background Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
			]
		);
		$this->add_control(
			'icon_bg_theme_colored',
			[
				'label' => esc_html__( "Icon Background Theme Colored", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'background-color: var(--theme-color{{VALUE}});',
					'{{WRAPPER}} .animated-css-play-button .play-icon' => 'background-color: var(--theme-color{{VALUE}});',
				],
			]
		);
		$this->add_control(
			'icon_bg_theme_colored_hover',
			[
				'label' => esc_html__( "Icon Background Theme Colored (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => ereco_mascot_theme_color_list(),
				'default' => '',
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}}:hover .video-play-button' => 'background-color: var(--theme-color{{VALUE}});',
					'{{WRAPPER}}:hover .animated-css-play-button .play-icon' => 'background-color: var(--theme-color{{VALUE}});',
				],
			]
		);
		$this->add_control(
			'iconb_bg_color',
			[
				'label' => esc_html__( "Icon Custom Background Color", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .animated-css-play-button .play-icon' => 'background-color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'icon_bg_color_hover',
			[
				'label' => esc_html__( "Icon Custom Background Color (Hover)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}}:hover .video-play-button' => 'background-color: {{VALUE}};',
					'{{WRAPPER}}:hover .animated-css-play-button .play-icon' => 'background-color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'icon_size_options',
			[
				'label' => esc_html__( 'Size Options', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
			]
		);
		$this->add_responsive_control(
			'height',
			[
				'label' => esc_html__( "Dimension (Width and Height)", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'width: {{VALUE}}; height: {{VALUE}};',
					'{{WRAPPER}} .animated-css-play-button .play-icon' => 'width: {{VALUE}}; height: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( "Border Radius", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'border-radius: {{VALUE}};',
					'{{WRAPPER}} .animated-css-play-button .play-icon' => 'border-radius: {{VALUE}};',
					'{{WRAPPER}} .animated-css-play-button .play-icon:before' => 'border-radius: {{VALUE}};',
					'{{WRAPPER}} .animated-css-play-button .play-icon:after' => 'border-radius: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'area_round', [
				'label' => esc_html__( "Make It Round?", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'design_style' => array('button-over-image', 'button-over-image2', 'custom-css-button', 'css-button'),
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'border-radius: 50%;',
					'{{WRAPPER}} .animated-css-play-button .play-icon' => 'border-radius: 50%;',
				]
			]
		);







		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Box Shadow', 'mascot-core-elementor' ),
				'selector' => '{{WRAPPER}} .video-play-button',
				'condition' => [
					'design_style' => array('button-over-image2')
				],
			]
		);
		$this->add_control(
			'icon_pos_options',
			[
				'label' => esc_html__( 'Position', 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'condition' => [
					'design_style' => array('button-over-image2')
				],
			]
		);
		$this->add_responsive_control(
			'pos_top',
			[
				'label' => esc_html__( "Top", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image2')
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'top: {{VALUE}}; transform:translate(0%, 0%)'
				]
			]
		);
		$this->add_responsive_control(
			'pos_right',
			[
				'label' => esc_html__( "Right", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image2')
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'right: {{VALUE}}; left: auto; transform:translate(0%, 0%)'
				]
			]
		);
		$this->add_responsive_control(
			'pos_bottom',
			[
				'label' => esc_html__( "Bottom", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image2')
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'bottom: {{VALUE}}; top:auto; transform:translate(0%, 0%)'
				]
			]
		);
		$this->add_responsive_control(
			'pos_left',
			[
				'label' => esc_html__( "Left", 'mascot-core-elementor' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'condition' => [
					'design_style' => array('button-over-image2')
				],
				'selectors' => [
					'{{WRAPPER}} .video-play-button' => 'left: {{VALUE}};right:auto; transform:translate(0%, 0%)'
				]
			]
		);
		$this->end_controls_section();

	}

  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render() {
	$settings = $this->get_settings_for_display();

	wp_register_script( 'nivo-lightbox', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/nivo-lightbox/nivo-lightbox.min.js', array('jquery'), false, true );
	wp_register_style( 'nivo-lightbox', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/nivo-lightbox/nivo-lightbox.min.css' );
	wp_register_style( 'nivo-lightbox-theme', MASCOT_CORE_TEMPLATE_URI . '/assets/js/plugins/nivo-lightbox/themes/default/nivo-lightbox-theme.css' );
	wp_enqueue_script( 'nivo-lightbox' );
	wp_enqueue_style( 'nivo-lightbox' );
	wp_enqueue_style( 'nivo-lightbox-theme' );
	
	//classes
	$classes = array();
	$classes[] = 'tm-sc-video-popup';
	$classes[] = $settings['custom_css_class'];
	$classes[] = $settings['design_style'];

	$settings['classes'] = $classes;

	//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
	$html = mascot_core_ereco_elementor_get_shortcode_template_part( 'video-popup', $settings['design_style'], 'video-popup/tpl', $settings, true );

	echo $html;
  }
}